/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine.api.tree;

import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.util.StringUtils;
import net.openhft.chronicle.engine.api.tree.RequestContext;
import org.jetbrains.annotations.NotNull;

public class RequestContextInterner {
    @NotNull
    private final StringToRequestContext[] interner;
    private final int mask;

    public RequestContextInterner(int capacity) {
        int n = Maths.nextPower2((int)capacity, (int)128);
        this.interner = new StringToRequestContext[n];
        this.mask = n - 1;
    }

    public RequestContext intern(@NotNull CharSequence cs) {
        int h = Maths.hash32((CharSequence)cs) & this.mask;
        StringToRequestContext s = this.interner[h];
        if (s != null && StringUtils.isEqual((CharSequence)s.name, (CharSequence)cs)) {
            return s.requestContext;
        }
        String s2 = cs.toString();
        RequestContext rc = RequestContext.requestContext(cs);
        rc.seal();
        this.interner[h] = new StringToRequestContext(s2, rc);
        return rc;
    }

    static class StringToRequestContext {
        final String name;
        final RequestContext requestContext;

        StringToRequestContext(String name, RequestContext requestContext) {
            this.name = name;
            this.requestContext = requestContext;
        }
    }
}

