/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine.map;

import java.util.Iterator;
import java.util.Map;
import net.openhft.chronicle.engine.api.EngineReplication;
import net.openhft.chronicle.engine.api.map.KeyValueStore;
import net.openhft.chronicle.engine.api.map.MapEvent;
import net.openhft.chronicle.engine.api.pubsub.InvalidSubscriberException;
import net.openhft.chronicle.engine.api.pubsub.SubscriptionConsumer;
import net.openhft.chronicle.engine.api.tree.Asset;
import net.openhft.chronicle.engine.api.tree.RequestContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AbstractKeyValueStore<K, V>
implements KeyValueStore<K, V> {
    @NotNull
    public final KeyValueStore<K, V> kvStore;
    @NotNull
    final Asset asset;
    private final Class<K> keyType;
    private final Class<V> valueType;

    AbstractKeyValueStore(@NotNull RequestContext rc, @NotNull Asset asset, @NotNull KeyValueStore<K, V> kvStore) {
        assert (asset != null);
        assert (kvStore != null);
        this.keyType = rc.keyType();
        this.valueType = rc.valueType();
        this.asset = asset;
        this.kvStore = kvStore;
    }

    @Override
    @NotNull
    public KeyValueStore underlying() {
        return this.kvStore;
    }

    @Override
    @Nullable
    public V getAndPut(K key, V value) {
        return this.kvStore.getAndPut(key, value);
    }

    @Override
    @Nullable
    public V getAndRemove(K key) {
        return this.kvStore.getAndRemove(key);
    }

    @Override
    @Nullable
    public V getUsing(K key, Object value) {
        return this.kvStore.getUsing(key, value);
    }

    @Override
    public Iterator<Map.Entry<K, V>> entrySetIterator() {
        return this.kvStore.entrySetIterator();
    }

    @Override
    public long longSize() {
        return this.kvStore.longSize();
    }

    @Override
    public void keysFor(int segment, SubscriptionConsumer<K> kConsumer) throws InvalidSubscriberException {
        this.kvStore.keysFor(segment, kConsumer);
    }

    @Override
    public void entriesFor(int segment, SubscriptionConsumer<MapEvent<K, V>> kvConsumer) throws InvalidSubscriberException {
        this.kvStore.entriesFor(segment, kvConsumer);
    }

    @Override
    public Asset asset() {
        return this.kvStore.asset();
    }

    @Override
    public void clear() {
        this.kvStore.clear();
    }

    @Override
    @Nullable
    public V replace(K key, V value) {
        return this.kvStore.replace(key, value);
    }

    public void close() {
        this.kvStore.close();
    }

    @Override
    public boolean put(K key, V value) {
        return this.kvStore.put(key, value);
    }

    @Override
    public boolean remove(K key) {
        return this.kvStore.remove(key);
    }

    @Override
    @Nullable
    public V get(K key) {
        return this.kvStore.get(key);
    }

    @Override
    public boolean containsKey(K key) {
        return this.kvStore.containsKey(key);
    }

    @Override
    public boolean isReadOnly() {
        return this.kvStore.isReadOnly();
    }

    @Override
    public int segments() {
        return this.kvStore.segments();
    }

    @Override
    public int segmentFor(K key) {
        return this.kvStore.segmentFor(key);
    }

    @Override
    public boolean replaceIfEqual(K key, V oldValue, V newValue) {
        return this.kvStore.replaceIfEqual(key, oldValue, newValue);
    }

    @Override
    public boolean removeIfEqual(K key, V value) {
        return this.kvStore.removeIfEqual(key, value);
    }

    @Override
    public boolean isKeyType(Object key) {
        return this.kvStore.isKeyType(key);
    }

    @Override
    @Nullable
    public V putIfAbsent(K key, V value) {
        return this.kvStore.putIfAbsent(key, value);
    }

    @Override
    public boolean keyedView() {
        return this.kvStore.keyedView();
    }

    @Override
    public boolean containsValue(V value) {
        throw new UnsupportedOperationException("todo");
    }

    @Override
    public Iterator<K> keySetIterator() {
        return this.kvStore.keySetIterator();
    }

    public Class<K> keyType() {
        return this.keyType;
    }

    public Class<V> valueType() {
        return this.valueType;
    }

    @Override
    public void accept(EngineReplication.ReplicationEntry replicationEntry) {
        throw new UnsupportedOperationException("todo");
    }
}

