/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine.map;

import com.sun.nio.file.SensitivityWatchEventModifier;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.FileSystemException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.FileAttribute;
import java.util.AbstractMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.core.util.ThrowingConsumer;
import net.openhft.chronicle.engine.api.EngineReplication;
import net.openhft.chronicle.engine.api.map.KeyValueStore;
import net.openhft.chronicle.engine.api.map.MapEvent;
import net.openhft.chronicle.engine.api.map.StringBytesStoreKeyValueStore;
import net.openhft.chronicle.engine.api.pubsub.InvalidSubscriberException;
import net.openhft.chronicle.engine.api.pubsub.SubscriptionConsumer;
import net.openhft.chronicle.engine.api.tree.Asset;
import net.openhft.chronicle.engine.api.tree.AssetNotFoundException;
import net.openhft.chronicle.engine.api.tree.RequestContext;
import net.openhft.chronicle.engine.map.Buffers;
import net.openhft.chronicle.engine.map.FileRecord;
import net.openhft.chronicle.engine.map.InsertedEvent;
import net.openhft.chronicle.engine.map.RawKVSSubscription;
import net.openhft.chronicle.engine.map.RemovedEvent;
import net.openhft.chronicle.engine.map.UpdatedEvent;
import net.openhft.chronicle.threads.Threads;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilePerKeyValueStore
implements StringBytesStoreKeyValueStore,
Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(FilePerKeyValueStore.class);
    private final Path dirPath;
    private final Map<File, FileRecord<BytesStore>> lastFileRecordMap = new ConcurrentHashMap<File, FileRecord<BytesStore>>();
    @NotNull
    private final Thread fileFpmWatcher;
    @NotNull
    private final RawKVSSubscription<String, BytesStore> subscriptions;
    @NotNull
    private final Asset asset;
    private final WatchService watcher;
    private volatile boolean closed = false;

    public FilePerKeyValueStore(@NotNull RequestContext context, @NotNull Asset asset) throws IORuntimeException, AssetNotFoundException {
        this(context, asset, context.type(), context.basePath(), context.name());
        asset.registerView(StringBytesStoreKeyValueStore.class, this);
    }

    private FilePerKeyValueStore(RequestContext context, @NotNull Asset asset, Class type, String basePath, String name) throws AssetNotFoundException {
        this.asset = asset;
        assert (type == String.class);
        String first = basePath;
        String dirName = first == null ? name : first + "/" + name;
        this.dirPath = Paths.get(dirName, new String[0]);
        try {
            Files.createDirectories(this.dirPath, new FileAttribute[0]);
            this.watcher = FileSystems.getDefault().newWatchService();
            this.dirPath.register(this.watcher, new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY}, SensitivityWatchEventModifier.HIGH);
        }
        catch (IOException e) {
            throw new IORuntimeException((Throwable)e);
        }
        this.fileFpmWatcher = new Thread((Runnable)new FPMWatcher(this.watcher), Threads.threadGroupPrefix() + " watcher for " + dirName);
        this.fileFpmWatcher.setDaemon(true);
        this.fileFpmWatcher.start();
        this.subscriptions = asset.acquireView(RawKVSSubscription.class, context);
        this.subscriptions.setKvStore(this);
    }

    @Override
    @NotNull
    public RawKVSSubscription<String, BytesStore> subscription(boolean createIfAbsent) {
        return this.subscriptions;
    }

    @Override
    public long longSize() {
        return this.getFiles().count();
    }

    @Override
    @Nullable
    public BytesStore getUsing(String key, Object value) {
        Path path = this.dirPath.resolve(key);
        return this.getFileContents(path, (Bytes)value);
    }

    @Override
    public void keysFor(int segment, @NotNull SubscriptionConsumer<String> stringConsumer) {
        this.keysFor0(stringConsumer);
    }

    private void keysFor0(@NotNull SubscriptionConsumer<String> stringConsumer) {
        this.getFiles().forEach(ThrowingConsumer.asConsumer(p -> stringConsumer.accept(p.getFileName().toString())));
    }

    @Override
    public void entriesFor(int segment, @NotNull SubscriptionConsumer<MapEvent<String, BytesStore>> kvConsumer) throws InvalidSubscriberException {
        this.entriesFor0(kvConsumer);
    }

    private void entriesFor0(@NotNull SubscriptionConsumer<MapEvent<String, BytesStore>> kvConsumer) throws InvalidSubscriberException {
        this.getFiles().forEach(p -> {
            BytesStore fileContents = null;
            try {
                fileContents = this.getFileContents((Path)p, null);
                if (fileContents != null) {
                    InsertedEvent<String, BytesStore> e = InsertedEvent.of(this.asset.fullName(), p.getFileName().toString(), fileContents, false);
                    kvConsumer.accept(e);
                }
            }
            catch (InvalidSubscriberException ise) {
                throw Jvm.rethrow((Throwable)ise);
            }
            finally {
                if (fileContents != null) {
                    fileContents.release();
                }
            }
        });
    }

    @Override
    public Iterator<String> keySetIterator() {
        return this.getFiles().map(p -> p.getFileName().toString()).iterator();
    }

    @Override
    public Iterator<Map.Entry<String, BytesStore>> entrySetIterator() {
        return this.getEntryStream().iterator();
    }

    private Stream<Map.Entry<String, BytesStore>> getEntryStream() {
        return this.getFiles().map(p -> {
            BytesStore fileContents = null;
            try {
                fileContents = this.getFileContents((Path)p, null);
                AbstractMap.SimpleEntry<String, BytesStore> simpleEntry = new AbstractMap.SimpleEntry<String, BytesStore>(p.getFileName().toString(), fileContents);
                return simpleEntry;
            }
            finally {
                if (fileContents != null) {
                    fileContents.release();
                }
            }
        });
    }

    @Override
    public boolean put(String key, @NotNull BytesStore value) {
        if (this.closed) {
            throw new IllegalStateException("closed");
        }
        Path path = this.dirPath.resolve(key);
        FileRecord<BytesStore> fr = this.lastFileRecordMap.get(path.toFile());
        this.writeToFile(path, value);
        if (fr != null) {
            fr.valid = false;
        }
        return fr != null;
    }

    @Override
    @Nullable
    public BytesStore getAndPut(String key, @NotNull BytesStore value) {
        if (this.closed) {
            throw new IllegalStateException("closed");
        }
        Path path = this.dirPath.resolve(key);
        FileRecord<BytesStore> fr = this.lastFileRecordMap.get(path.toFile());
        BytesStore existingValue = this.getFileContents(path, null);
        this.writeToFile(path, value);
        if (fr != null) {
            fr.valid = false;
        }
        return existingValue == null ? null : existingValue;
    }

    @Override
    @Nullable
    public BytesStore getAndRemove(String key) {
        if (this.closed) {
            throw new IllegalStateException("closed");
        }
        BytesStore existing = (BytesStore)this.get(key);
        if (existing != null) {
            try {
                this.deleteFile(this.dirPath.resolve(key));
            }
            catch (IOException e) {
                Jvm.warn().on(this.getClass(), "Unable to delete " + key);
            }
        }
        return existing;
    }

    @Override
    public boolean remove(String key) {
        FileRecord<BytesStore> fr;
        if (this.closed) {
            throw new IllegalStateException("closed");
        }
        Path path = this.dirPath.resolve(key);
        if (path.toFile().isFile()) {
            try {
                this.deleteFile(path);
            }
            catch (IOException e) {
                Jvm.warn().on(this.getClass(), "Unable to delete " + key);
            }
        }
        return (fr = this.lastFileRecordMap.get(path.toFile())) != null;
    }

    @Override
    public void clear() {
        AtomicInteger count = new AtomicInteger();
        Stream<Path> files = this.getFiles();
        files.forEach(path -> {
            try {
                this.deleteFile((Path)path);
            }
            catch (Exception e) {
                count.incrementAndGet();
            }
        });
        if (count.intValue() > 0) {
            Jvm.pause((long)100L);
            this.getFiles().forEach(path -> {
                try {
                    this.deleteFile((Path)path);
                }
                catch (IOException e) {
                    Jvm.warn().on(this.getClass(), "Unable to delete " + path + " " + e);
                }
            });
        }
    }

    @Override
    public boolean containsValue(BytesStore value) {
        throw new UnsupportedOperationException("todo");
    }

    private Stream<Path> getFiles() {
        try {
            return Files.walk(this.dirPath, new FileVisitOption[0]).filter(p -> !Files.isDirectory(p, new LinkOption[0])).filter(this::isVisible);
        }
        catch (IOException e) {
            throw Jvm.rethrow((Throwable)e);
        }
    }

    private boolean isVisible(@NotNull Path p) {
        return !p.getFileName().startsWith(".");
    }

    @Nullable
    private BytesStore getFileContents(@NotNull Path path, Bytes using) {
        BytesStore contents;
        File file = path.toFile();
        FileRecord<BytesStore> lastFileRecord = this.lastFileRecordMap.get(file);
        if (lastFileRecord != null && lastFileRecord.valid && file.lastModified() == lastFileRecord.timestamp && (contents = lastFileRecord.contents()) != null) {
            return contents;
        }
        return this.getFileContentsFromDisk(path, using);
    }

    @Nullable
    private Bytes getFileContentsFromDisk(@NotNull Path path, Bytes using) {
        for (int i = 1; i <= 5; ++i) {
            try {
                return this.getFileContentsFromDisk0(path, using);
            }
            catch (IOException e) {
                Jvm.pause((long)(i * i * 2));
                continue;
            }
        }
        return null;
    }

    private Bytes getFileContentsFromDisk0(@NotNull Path path, Bytes using) throws IOException {
        if (!Files.exists(path, new LinkOption[0])) {
            return null;
        }
        File file = path.toFile();
        Buffers b = Buffers.BUFFERS.get();
        Bytes<ByteBuffer> readingBytes = b.valueBuffer;
        try (FileChannel fc = new FileInputStream(file).getChannel();){
            readingBytes.ensureCapacity(fc.size());
            ByteBuffer dst = (ByteBuffer)readingBytes.underlyingObject();
            dst.clear();
            fc.read(dst);
            readingBytes.readPositionRemaining(0L, (long)dst.position());
            dst.flip();
        }
        readingBytes.reserve();
        return readingBytes;
    }

    private void writeToFile(@NotNull Path path, @NotNull BytesStore value) {
        Bytes<ByteBuffer> writingBytes;
        if (value.underlyingObject() instanceof ByteBuffer) {
            writingBytes = value;
        } else {
            Buffers b = Buffers.BUFFERS.get();
            Bytes<ByteBuffer> valueBuffer = b.valueBuffer;
            valueBuffer.clear();
            valueBuffer.write((BytesStore)value);
            writingBytes = valueBuffer;
        }
        File file = path.toFile();
        File tmpFile = new File(file.getParentFile(), "." + file.getName() + "." + System.nanoTime());
        try (FileChannel fc = new FileOutputStream(tmpFile).getChannel();){
            ByteBuffer byteBuffer = (ByteBuffer)writingBytes.underlyingObject();
            byteBuffer.position(0);
            byteBuffer.limit((int)writingBytes.readLimit());
            fc.write(byteBuffer);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        for (int i = 1; i < 5; ++i) {
            try {
                Files.move(tmpFile.toPath(), file.toPath(), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
                break;
            }
            catch (FileSystemException fse) {
                if (LOG.isDebugEnabled()) {
                    Jvm.debug().on(this.getClass(), "Unable to rename file " + fse);
                }
                try {
                    Thread.sleep(i * i * 2);
                    continue;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    break;
                }
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    private void deleteFile(@NotNull Path path) throws IOException {
        Files.deleteIfExists(path);
    }

    public void close() {
        this.closed = true;
        this.fileFpmWatcher.interrupt();
        Closeable.closeQuietly((Object)this.watcher);
    }

    @Override
    @NotNull
    public Asset asset() {
        return this.asset;
    }

    @Override
    @Nullable
    public KeyValueStore<String, BytesStore> underlying() {
        return null;
    }

    @Override
    public void accept(EngineReplication.ReplicationEntry replicationEntry) {
        throw new UnsupportedOperationException("todo");
    }

    private class FPMWatcher
    implements Runnable {
        private final WatchService watcher;

        public FPMWatcher(WatchService watcher) {
            this.watcher = watcher;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                while (!FilePerKeyValueStore.this.closed) {
                    WatchKey key = null;
                    try {
                        key = this.processKey();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        return;
                    }
                    finally {
                        if (key == null) continue;
                        key.reset();
                    }
                }
                return;
            }
            catch (Throwable e) {
                if (FilePerKeyValueStore.this.closed) return;
                Jvm.warn().on(this.getClass(), e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        private WatchKey processKey() throws InterruptedException {
            WatchKey key = this.watcher.take();
            for (WatchEvent<?> event : key.pollEvents()) {
                Path p;
                WatchEvent<?> ev;
                Path fileName;
                String mapKey;
                WatchEvent.Kind<?> kind = event.kind();
                if (kind == StandardWatchEventKinds.OVERFLOW || (mapKey = (fileName = (Path)(ev = event).context()).toString()).startsWith(".")) continue;
                if (kind == StandardWatchEventKinds.ENTRY_CREATE || kind == StandardWatchEventKinds.ENTRY_MODIFY) {
                    p = FilePerKeyValueStore.this.dirPath.resolve(fileName);
                    Bytes mapVal = FilePerKeyValueStore.this.getFileContentsFromDisk(p, null);
                    FileRecord prev = (FileRecord)FilePerKeyValueStore.this.lastFileRecordMap.get(p.toFile());
                    BytesStore prevContents = prev == null ? null : (BytesStore)prev.contents();
                    try {
                        if (mapVal != null && mapVal.contentEquals(prevContents)) continue;
                        if (mapVal == null) {
                            if (prev != null) {
                                mapVal = prevContents;
                            }
                        } else {
                            FilePerKeyValueStore.this.lastFileRecordMap.put(p.toFile(), new FileRecord<BytesStore>(p.toFile().lastModified(), mapVal.copy()));
                        }
                        if (prev == null) {
                            FilePerKeyValueStore.this.subscriptions.notifyEvent(InsertedEvent.of(FilePerKeyValueStore.this.asset.fullName(), p.toFile().getName(), mapVal, false));
                            continue;
                        }
                        FilePerKeyValueStore.this.subscriptions.notifyEvent(UpdatedEvent.of(FilePerKeyValueStore.this.asset.fullName(), p.toFile().getName(), prevContents, mapVal, false, prevContents == null ? true : !prevContents.equals(mapVal)));
                        continue;
                    }
                    finally {
                        if (prevContents != null) {
                            prevContents.release();
                        }
                        continue;
                    }
                }
                if (kind != StandardWatchEventKinds.ENTRY_DELETE) continue;
                p = FilePerKeyValueStore.this.dirPath.resolve(fileName);
                FileRecord prev = (FileRecord)FilePerKeyValueStore.this.lastFileRecordMap.remove(p.toFile());
                BytesStore lastVal = prev == null ? null : (BytesStore)prev.contents();
                try {
                    FilePerKeyValueStore.this.subscriptions.notifyEvent(RemovedEvent.of(FilePerKeyValueStore.this.asset.fullName(), p.toFile().getName(), lastVal, false));
                }
                finally {
                    if (lastVal == null) continue;
                    lastVal.release();
                }
            }
            return key;
        }
    }
}

