/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine.map;

import java.util.function.BiFunction;
import java.util.function.Function;
import net.openhft.chronicle.engine.api.map.MapEvent;
import net.openhft.chronicle.engine.api.map.MapEventListener;
import net.openhft.chronicle.wire.AbstractMarshallable;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireKey;
import net.openhft.chronicle.wire.WireOut;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InsertedEvent<K, V>
extends AbstractMarshallable
implements MapEvent<K, V> {
    private boolean isReplicationEvent;
    @Nullable
    private String assetName;
    @NotNull
    private K key;
    @Nullable
    private V value;

    private InsertedEvent(String assetName, @NotNull K key, @Nullable V value, boolean isReplicationEvent) {
        this.assetName = assetName;
        this.key = key;
        this.value = value;
        this.isReplicationEvent = isReplicationEvent;
    }

    @NotNull
    public static <K, V> InsertedEvent<K, V> of(String assetName, @NotNull K key, V value, boolean isReplicationEvent) {
        return new InsertedEvent<K, V>(assetName, key, value, isReplicationEvent);
    }

    @Override
    @Nullable
    public String assetName() {
        return this.assetName;
    }

    @Override
    @NotNull
    public <K2, V2> MapEvent<K2, V2> translate(@NotNull Function<K, K2> keyFunction, @NotNull Function<V, V2> valueFunction) {
        return new InsertedEvent<K2, V2>(this.assetName, keyFunction.apply(this.key), valueFunction.apply(this.value), this.isReplicationEvent);
    }

    @Override
    @NotNull
    public <K2, V2> MapEvent<K2, V2> translate(@NotNull BiFunction<K, K2, K2> keyFunction, @NotNull BiFunction<V, V2, V2> valueFunction) {
        return new InsertedEvent<K2, V2>(this.assetName, keyFunction.apply(this.key, null), valueFunction.apply(this.value, null), this.isReplicationEvent);
    }

    @Override
    @Nullable
    public K getKey() {
        return this.key;
    }

    @Override
    @Nullable
    public V oldValue() {
        return null;
    }

    @Override
    @Nullable
    public V getValue() {
        return this.value;
    }

    @Override
    public void apply(@NotNull MapEventListener<K, V> listener) {
        listener.insert(this.assetName, this.key, this.value);
    }

    @Override
    @NotNull
    public V setValue(V value) {
        throw new UnsupportedOperationException();
    }

    public void readMarshallable(@NotNull WireIn wire) throws IllegalStateException {
        this.assetName = wire.read((WireKey)MapEvent.MapEventFields.assetName).text();
        this.key = wire.read((WireKey)MapEvent.MapEventFields.key).object(Object.class);
        this.value = wire.read((WireKey)MapEvent.MapEventFields.value).object(Object.class);
        this.isReplicationEvent = wire.read((WireKey)MapEvent.MapEventFields.isReplicationEvent).bool();
    }

    public void writeMarshallable(@NotNull WireOut wire) {
        wire.write((WireKey)MapEvent.MapEventFields.assetName).text(this.assetName);
        wire.write((WireKey)MapEvent.MapEventFields.key).object(this.key);
        wire.write((WireKey)MapEvent.MapEventFields.value).object(this.value);
        wire.write((WireKey)MapEvent.MapEventFields.isReplicationEvent).bool(Boolean.valueOf(this.isReplicationEvent));
    }
}

