/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine.query;

import java.util.function.Function;
import net.openhft.chronicle.engine.tree.MessageAdaptor;
import net.openhft.chronicle.wire.WireType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QueueConfig {
    @NotNull
    Function<String, Integer> source;
    boolean acknowledgment;
    @Nullable
    MessageAdaptor messageAdaptor;
    @NotNull
    WireType wireType;

    public QueueConfig(@NotNull Function<String, Integer> masterIDFunction, boolean acknowledgment, @Nullable MessageAdaptor messageAdaptor, @NotNull WireType wireType) {
        this.source = masterIDFunction;
        this.messageAdaptor = messageAdaptor;
        this.acknowledgment = acknowledgment;
        this.wireType = wireType;
    }

    public Integer sourceHostId(@NotNull String uri) {
        return this.source.apply(uri);
    }

    public boolean acknowledgment() {
        return this.acknowledgment;
    }

    @Nullable
    public MessageAdaptor bytesFunction() {
        return this.messageAdaptor;
    }

    @NotNull
    public WireType wireType() {
        return this.wireType;
    }
}

