/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine.server.internal;

import java.time.LocalTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.threads.EventLoop;
import net.openhft.chronicle.engine.api.collection.ValuesCollection;
import net.openhft.chronicle.engine.api.column.ColumnView;
import net.openhft.chronicle.engine.api.column.ColumnViewInternal;
import net.openhft.chronicle.engine.api.column.ColumnViewIterator;
import net.openhft.chronicle.engine.api.column.MapColumnView;
import net.openhft.chronicle.engine.api.column.QueueColumnView;
import net.openhft.chronicle.engine.api.column.VaadinChart;
import net.openhft.chronicle.engine.api.map.MapView;
import net.openhft.chronicle.engine.api.pubsub.Publisher;
import net.openhft.chronicle.engine.api.pubsub.Reference;
import net.openhft.chronicle.engine.api.pubsub.Replication;
import net.openhft.chronicle.engine.api.pubsub.SubscriptionCollection;
import net.openhft.chronicle.engine.api.pubsub.TopicPublisher;
import net.openhft.chronicle.engine.api.query.IndexQueueView;
import net.openhft.chronicle.engine.api.session.Heartbeat;
import net.openhft.chronicle.engine.api.set.EntrySetView;
import net.openhft.chronicle.engine.api.set.KeySetView;
import net.openhft.chronicle.engine.api.tree.Asset;
import net.openhft.chronicle.engine.api.tree.AssetNotFoundException;
import net.openhft.chronicle.engine.api.tree.RequestContext;
import net.openhft.chronicle.engine.api.tree.RequestContextInterner;
import net.openhft.chronicle.engine.cfg.UserStat;
import net.openhft.chronicle.engine.collection.CollectionWireHandler;
import net.openhft.chronicle.engine.map.ObjectSubscription;
import net.openhft.chronicle.engine.server.internal.AbstractHandler;
import net.openhft.chronicle.engine.server.internal.ColumnViewHandler;
import net.openhft.chronicle.engine.server.internal.ColumnViewIteratorHandler;
import net.openhft.chronicle.engine.server.internal.CspManager;
import net.openhft.chronicle.engine.server.internal.EngineWireNetworkContext;
import net.openhft.chronicle.engine.server.internal.GenericWireAdapter;
import net.openhft.chronicle.engine.server.internal.IndexQueueViewHandler;
import net.openhft.chronicle.engine.server.internal.MapWireHandler;
import net.openhft.chronicle.engine.server.internal.ObjectKVSubscriptionHandler;
import net.openhft.chronicle.engine.server.internal.PublisherHandler;
import net.openhft.chronicle.engine.server.internal.ReferenceHandler;
import net.openhft.chronicle.engine.server.internal.ReplicationHandler;
import net.openhft.chronicle.engine.server.internal.SystemHandler;
import net.openhft.chronicle.engine.server.internal.TopicPublisherHandler;
import net.openhft.chronicle.engine.server.internal.TopologySubscriptionHandler;
import net.openhft.chronicle.engine.server.internal.VaadinChartHandler;
import net.openhft.chronicle.engine.server.internal.WireAdapter;
import net.openhft.chronicle.engine.tree.HostIdentifier;
import net.openhft.chronicle.engine.tree.QueueView;
import net.openhft.chronicle.engine.tree.TopologySubscription;
import net.openhft.chronicle.network.ClientClosedProvider;
import net.openhft.chronicle.network.NetworkContextManager;
import net.openhft.chronicle.network.WireTcpHandler;
import net.openhft.chronicle.network.api.session.SessionDetails;
import net.openhft.chronicle.network.api.session.SessionDetailsProvider;
import net.openhft.chronicle.network.api.session.SessionProvider;
import net.openhft.chronicle.network.connection.CoreFields;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.ReadMarshallable;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireKey;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.WireType;
import net.openhft.chronicle.wire.Wires;
import net.openhft.chronicle.wire.YamlLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EngineWireHandler
extends WireTcpHandler<EngineWireNetworkContext>
implements ClientClosedProvider,
NetworkContextManager<EngineWireNetworkContext>,
CspManager {
    private static final Logger LOG = LoggerFactory.getLogger(EngineWireHandler.class);
    private final StringBuilder cspText = new StringBuilder();
    @NotNull
    private final CollectionWireHandler keySetHandler;
    @NotNull
    private final ColumnViewIteratorHandler columnViewIteratorHandler;
    @NotNull
    private final ColumnViewHandler columnViewHandler;
    @NotNull
    private final MapWireHandler mapWireHandler;
    @NotNull
    private final CollectionWireHandler entrySetHandler;
    @NotNull
    private final CollectionWireHandler valuesHandler;
    @NotNull
    private final ObjectKVSubscriptionHandler subscriptionHandler;
    @NotNull
    private final TopologySubscriptionHandler topologySubscriptionHandler;
    @NotNull
    private final TopicPublisherHandler topicPublisherHandler;
    @NotNull
    private final PublisherHandler publisherHandler;
    @NotNull
    private final IndexQueueViewHandler indexQueueViewHandler;
    @NotNull
    private final ReferenceHandler referenceHandler;
    @NotNull
    private final ReplicationHandler replicationHandler;
    @NotNull
    private final VaadinChartHandler barChatHandler;
    @NotNull
    private final ReadMarshallable metaDataConsumer;
    private final StringBuilder lastCsp = new StringBuilder();
    private final StringBuilder eventName = new StringBuilder();
    @NotNull
    private final SystemHandler systemHandler;
    private final RequestContextInterner requestContextInterner = new RequestContextInterner(128);
    private final StringBuilder currentLogMessage = new StringBuilder();
    private final StringBuilder prevLogMessage = new StringBuilder();
    @NotNull
    private Asset rootAsset;
    @Nullable
    private SessionProvider sessionProvider;
    @Nullable
    private EventLoop eventLoop;
    private boolean isServerSocket;
    private Asset contextAsset;
    private WireAdapter<?, ?> wireAdapter;
    private Object view;
    private boolean isSystemMessage = true;
    private RequestContext requestContext;
    private SessionDetailsProvider sessionDetails;
    @NotNull
    private final Map<Long, String> cidToCsp = new HashMap<Long, String>();
    @NotNull
    private final Map<Long, Object> cidToObject = new HashMap<Long, Object>();
    @NotNull
    private final Map<String, Long> cspToCid = new HashMap<String, Long>();
    @Nullable
    private Class viewType;
    private long tid;
    private long cid;
    @Nullable
    private HostIdentifier hostIdentifier;
    private final Class[] views = new Class[]{MapView.class, EntrySetView.class, ValuesCollection.class, KeySetView.class, ObjectSubscription.class, TopicPublisher.class, Publisher.class, Reference.class, TopologySubscription.class, Replication.class, QueueView.class, Heartbeat.class, IndexQueueView.class, MapColumnView.class, QueueColumnView.class, ColumnView.class, ColumnViewIterator.class, VaadinChart.class};
    private final AtomicLong nextCid = new AtomicLong(1L);
    private final StringBuilder cspBuff = new StringBuilder();

    public EngineWireHandler() {
        this.mapWireHandler = new MapWireHandler(this);
        this.metaDataConsumer = this.metaDataConsumer();
        this.keySetHandler = new CollectionWireHandler();
        this.entrySetHandler = new CollectionWireHandler();
        this.valuesHandler = new CollectionWireHandler();
        this.subscriptionHandler = new ObjectKVSubscriptionHandler();
        this.topologySubscriptionHandler = new TopologySubscriptionHandler();
        this.topicPublisherHandler = new TopicPublisherHandler();
        this.publisherHandler = new PublisherHandler();
        this.referenceHandler = new ReferenceHandler();
        this.replicationHandler = new ReplicationHandler();
        this.systemHandler = new SystemHandler();
        this.indexQueueViewHandler = new IndexQueueViewHandler();
        this.columnViewHandler = new ColumnViewHandler(this);
        this.columnViewIteratorHandler = new ColumnViewIteratorHandler(this);
        this.barChatHandler = new VaadinChartHandler(this);
    }

    protected void onInitialize() {
        EngineWireNetworkContext nc = (EngineWireNetworkContext)this.nc();
        if (this.wireType() == null && nc.wireType() != null) {
            this.wireType(nc.wireType());
        }
        this.publisher(nc.wireOutPublisher());
        this.rootAsset = nc.rootAsset().root();
        this.contextAsset = nc.isAcceptor() ? this.rootAsset : nc.rootAsset();
        this.hostIdentifier = this.rootAsset.findOrCreateView(HostIdentifier.class);
        this.sessionProvider = this.rootAsset.getView(SessionProvider.class);
        this.eventLoop = this.rootAsset.findOrCreateView(EventLoop.class);
        assert (this.eventLoop != null);
        try {
            this.eventLoop.start();
        }
        catch (RejectedExecutionException e) {
            Jvm.debug().on(this.getClass(), (Throwable)e);
        }
        this.isServerSocket = nc.isAcceptor();
        this.sessionDetails = nc.sessionDetails();
        this.rootAsset = nc.rootAsset();
    }

    public void onEndOfConnection(boolean heartbeatTimeOut) {
        for (AbstractHandler abstractHandler : new AbstractHandler[]{this.mapWireHandler, this.subscriptionHandler, this.topologySubscriptionHandler, this.publisherHandler, this.replicationHandler}) {
            try {
                abstractHandler.onEndOfConnection();
            }
            catch (Exception e) {
                Jvm.debug().on(this.getClass(), "Failed while for " + abstractHandler, (Throwable)e);
            }
        }
    }

    @NotNull
    private ReadMarshallable metaDataConsumer() {
        return wire -> {
            block20: {
                assert (this.outWire.startUse());
                try {
                    long startWritePosition;
                    block21: {
                        startWritePosition = this.outWire.bytes().writePosition();
                        boolean bl = this.isSystemMessage = wire.bytes().readRemaining() == 0L;
                        if (this.isSystemMessage) {
                            if (LOG.isDebugEnabled()) {
                                Jvm.debug().on(this.getClass(), "received system-meta-data");
                            }
                            return;
                        }
                        this.readCsp(wire);
                        this.readTid(wire);
                        if (!this.hasCspChanged(this.cspText)) break block20;
                        if (LOG.isDebugEnabled()) {
                            Jvm.debug().on(this.getClass(), "received meta-data:\n" + wire.bytes().toHexString());
                        }
                        this.requestContext = this.requestContextInterner.intern(this.cspText);
                        String fullName = this.requestContext.fullName();
                        if (!"/".equals(fullName)) {
                            this.contextAsset = this.rootAsset.acquireAsset(fullName);
                        }
                        this.viewType = this.requestContext.viewType();
                        if (this.viewType != null) break block21;
                        if (LOG.isDebugEnabled()) {
                            Jvm.debug().on(this.getClass(), "received system-meta-data");
                        }
                        this.isSystemMessage = true;
                        return;
                    }
                    try {
                        if (this.viewType == ColumnView.class) {
                            try {
                                this.view = this.contextAsset.acquireView(QueueColumnView.class);
                            }
                            catch (AssetNotFoundException e) {
                                this.view = this.contextAsset.acquireView(MapColumnView.class);
                            }
                        } else {
                            this.view = this.viewType != ColumnViewIterator.class ? this.contextAsset.acquireView(this.requestContext) : this.cidToObject.get(this.cid);
                        }
                        if (this.isValid(this.viewType)) {
                            Class type = this.requestContext.keyType() == null ? String.class : this.requestContext.keyType();
                            Class type2 = this.requestContext.valueType() == null ? String.class : this.requestContext.valueType();
                            this.wireAdapter = new GenericWireAdapter(type, type2);
                            break block20;
                        }
                        throw new UnsupportedOperationException("unsupported view type");
                    }
                    catch (Throwable e) {
                        Jvm.warn().on(this.getClass(), "", e);
                        this.outWire.bytes().writePosition(startWritePosition);
                        this.outWire.writeDocument(true, w -> w.writeEventName((WireKey)CoreFields.tid).int64(this.tid));
                        this.outWire.writeDocument(false, out -> out.writeEventName(() -> "exception").throwable(e));
                        this.logYamlToStandardOut((WireIn)this.outWire);
                        Jvm.rethrow((Throwable)e);
                    }
                }
                finally {
                    assert (this.outWire.endUse());
                }
            }
        };
    }

    private boolean isValid(@NotNull Class viewType) {
        for (Class v : this.views) {
            if (!v.isAssignableFrom(viewType)) continue;
            return true;
        }
        return false;
    }

    private boolean hasCspChanged(@NotNull StringBuilder cspText) {
        boolean result;
        boolean bl = result = !cspText.equals(this.lastCsp);
        if (result) {
            this.lastCsp.setLength(0);
            this.lastCsp.append((CharSequence)cspText);
        }
        return result;
    }

    private void readTid(@NotNull WireIn metaDataWire) {
        ValueIn valueIn = metaDataWire.readEventName(this.eventName);
        if (CoreFields.tid.contentEquals((CharSequence)this.eventName)) {
            this.tid = valueIn.int64();
            this.eventName.setLength(0);
        } else {
            this.tid = -1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onRead(@NotNull DocumentContext inDc, @NotNull WireOut out) {
        Wire in = inDc.wire();
        assert (in.startUse());
        this.sessionProvider.set((SessionDetails)((EngineWireNetworkContext)this.nc()).sessionDetails());
        try {
            this.onRead0(inDc, out, (WireIn)in);
        }
        finally {
            this.sessionProvider.remove();
            assert (in.endUse());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onRead0(@NotNull DocumentContext inDc, @NotNull WireOut out, @NotNull WireIn in) {
        if (!YamlLogging.showHeartBeats()) {
            this.prevLogMessage.setLength(0);
            this.prevLogMessage.append((CharSequence)this.currentLogMessage);
            this.currentLogMessage.setLength(0);
            this.logToBuffer(in, this.currentLogMessage, in.bytes().readPosition() - 4L);
        } else {
            this.logYamlToStandardOut(in);
        }
        if (inDc.isMetaData()) {
            this.metaDataConsumer.readMarshallable(in);
        } else {
            try {
                Map<String, UserStat> userMonitoringMap;
                if (LOG.isDebugEnabled()) {
                    Jvm.debug().on(this.getClass(), "received data:\n" + in.bytes().toHexString());
                }
                Consumer<WireType> wireTypeConsumer = wt -> {
                    this.wireType((WireType)wt);
                    this.checkWires(in.bytes(), out.bytes(), this.wireType());
                };
                if (this.isSystemMessage) {
                    this.systemHandler.process(in, out, this.tid, this.sessionDetails, this.getMonitoringMap(), this.isServerSocket, () -> ((EngineWireHandler)this).publisher(), this.hostIdentifier, wireTypeConsumer, this.wireType());
                    if (!this.systemHandler.wasHeartBeat() && !YamlLogging.showHeartBeats()) {
                        this.logBufferToStandardOut(this.prevLogMessage.append((CharSequence)this.currentLogMessage));
                    }
                    return;
                }
                if (!YamlLogging.showHeartBeats()) {
                    this.logBufferToStandardOut(this.prevLogMessage.append((CharSequence)this.currentLogMessage));
                }
                if ((userMonitoringMap = this.getMonitoringMap()) != null) {
                    UserStat userStat = userMonitoringMap.get(this.sessionDetails.userId());
                    if (userStat == null) {
                        throw new AssertionError((Object)"User should have been logged in");
                    }
                    userStat.setRecentInteraction(LocalTime.now());
                    userStat.setTotalInteractions(userStat.getTotalInteractions() + 1);
                    userMonitoringMap.put(this.sessionDetails.userId(), userStat);
                }
                if (this.wireAdapter != null) {
                    if (this.viewType == null) {
                        return;
                    }
                    if (MapView.class.isAssignableFrom(this.viewType)) {
                        this.mapWireHandler.process(in, out, (MapView)this.view, this.tid, this.wireAdapter, this.requestContext);
                        return;
                    }
                    if (EntrySetView.class.isAssignableFrom(this.viewType)) {
                        this.entrySetHandler.process(in, out, (EntrySetView)this.view, this.wireAdapter.entryToWire(), this.wireAdapter.wireToEntry(), HashSet::new, this.tid);
                        return;
                    }
                    if (KeySetView.class.isAssignableFrom(this.viewType)) {
                        this.keySetHandler.process(in, out, (KeySetView)this.view, this.wireAdapter.keyToWire(), this.wireAdapter.wireToKey(), HashSet::new, this.tid);
                        return;
                    }
                    if (MapColumnView.class.isAssignableFrom(this.viewType) || QueueColumnView.class.isAssignableFrom(this.viewType) || this.viewType == ColumnView.class) {
                        this.columnViewHandler.process(in, out, (ColumnViewInternal)this.view, this.tid);
                        return;
                    }
                    if (ColumnViewIterator.class.isAssignableFrom(this.viewType)) {
                        this.columnViewIteratorHandler.process(in, out, this.tid, (Iterator)this.view, this.cid);
                        return;
                    }
                    if (ValuesCollection.class.isAssignableFrom(this.viewType)) {
                        this.valuesHandler.process(in, out, (ValuesCollection)this.view, this.wireAdapter.keyToWire(), this.wireAdapter.wireToKey(), ArrayList::new, this.tid);
                        return;
                    }
                    if (ObjectSubscription.class.isAssignableFrom(this.viewType)) {
                        this.subscriptionHandler.process(in, this.requestContext, this.publisher(), this.contextAsset, this.tid, this.outWire, (SubscriptionCollection)this.view);
                        return;
                    }
                    if (TopologySubscription.class.isAssignableFrom(this.viewType)) {
                        this.topologySubscriptionHandler.process(in, this.requestContext, this.publisher(), this.contextAsset, this.tid, this.outWire, (TopologySubscription)this.view);
                        return;
                    }
                    if (Reference.class.isAssignableFrom(this.viewType)) {
                        this.referenceHandler.process(in, this.requestContext, this.publisher(), this.tid, (Reference)this.view, this.cspText, this.outWire, this.wireAdapter);
                        return;
                    }
                    if (TopicPublisher.class.isAssignableFrom(this.viewType) || QueueView.class.isAssignableFrom(this.viewType)) {
                        this.topicPublisherHandler.process(in, this.publisher(), this.tid, this.outWire, (TopicPublisher)this.view, this.wireAdapter);
                        return;
                    }
                    if (Publisher.class.isAssignableFrom(this.viewType)) {
                        this.publisherHandler.process(in, this.requestContext, this.publisher(), this.tid, (Publisher)this.view, this.outWire, this.wireAdapter);
                        return;
                    }
                    if (Replication.class.isAssignableFrom(this.viewType)) {
                        this.replicationHandler.process(in, this.publisher(), this.tid, this.outWire, this.hostIdentifier, (Replication)this.view, this.eventLoop);
                        return;
                    }
                    if (IndexQueueView.class.isAssignableFrom(this.viewType)) {
                        this.indexQueueViewHandler.process(in, this.requestContext, this.contextAsset, this.publisher(), this.tid, this.outWire);
                        return;
                    }
                    if (VaadinChart.class.isAssignableFrom(this.viewType)) {
                        this.barChatHandler.process(in, out, (VaadinChart)this.view, this.tid);
                    }
                }
            }
            catch (Exception e) {
                Jvm.warn().on(this.getClass(), in.readingPeekYaml() + "/n" + in.bytes().toDebugString(), (Throwable)e);
            }
            finally {
                if (this.sessionProvider != null) {
                    this.sessionProvider.remove();
                }
                this.cid = 0L;
            }
        }
    }

    @Nullable
    private Map<String, UserStat> getMonitoringMap() {
        Map userMonitoringMap = null;
        Asset userAsset = this.rootAsset.root().getAsset("proc/users");
        if (userAsset != null && userAsset.getView(MapView.class) != null) {
            userMonitoringMap = userAsset.getView(MapView.class);
        }
        return userMonitoringMap;
    }

    private void logYamlToStandardOut(@NotNull WireIn in) {
        if (YamlLogging.showServerReads()) {
            try {
                LOG.info("\nServer Receives:\n" + Wires.fromSizePrefixedBlobs((WireIn)in));
            }
            catch (Exception e) {
                LOG.info("\n\n" + Bytes.toString((Bytes)in.bytes()));
            }
        }
    }

    private void logToBuffer(@NotNull WireIn in, @NotNull StringBuilder logBuffer, long start) {
        if (YamlLogging.showServerReads()) {
            logBuffer.setLength(0);
            try {
                logBuffer.append("\nServer Receives:\n").append(Wires.fromSizePrefixedBlobs((Bytes)in.bytes(), (long)start));
            }
            catch (Exception e) {
                logBuffer.append("\n\n").append(Bytes.toString((Bytes)in.bytes(), (long)start, (long)(in.bytes().readLimit() - start)));
            }
        }
    }

    private void logBufferToStandardOut(@NotNull StringBuilder logBuffer) {
        if (logBuffer.length() > 0) {
            LOG.info("\n" + logBuffer.toString());
        }
    }

    private void readCsp(@NotNull WireIn wireIn) {
        StringBuilder event = Wires.acquireStringBuilder();
        this.cspText.setLength(0);
        ValueIn read = wireIn.readEventName(event);
        if (CoreFields.csp.contentEquals((CharSequence)event)) {
            read.textTo(this.cspText);
            this.tryReadEvent(wireIn, (that, wire) -> {
                long cid1;
                StringBuilder e = Wires.acquireStringBuilder();
                ValueIn valueIn = wireIn.readEventName(e);
                if (!CoreFields.cid.contentEquals((CharSequence)e)) {
                    return false;
                }
                that.cid = cid1 = valueIn.int64();
                this.setCid(this.cspText.toString(), cid1);
                return true;
            });
        } else if (CoreFields.cid.contentEquals((CharSequence)event)) {
            long cid = read.int64();
            CharSequence s = this.getCspForCid(cid);
            this.cspText.append(s);
            this.cid = cid;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryReadEvent(@NotNull WireIn wire, @NotNull BiFunction<EngineWireHandler, WireIn, Boolean> f) {
        long readPosition = wire.bytes().readPosition();
        boolean success = false;
        try {
            success = f.apply(this, wire);
        }
        finally {
            if (!success) {
                wire.bytes().readPosition(readPosition);
            }
        }
    }

    public boolean hasClientClosed() {
        return this.systemHandler.hasClientClosed();
    }

    public void close() {
        this.onEndOfConnection(false);
        this.publisher().close();
        super.close();
    }

    @Override
    public long acquireCid(@NotNull CharSequence csp) {
        long newCid = this.nextCid.incrementAndGet();
        String cspStr = csp.toString();
        Long aLong = this.cspToCid.putIfAbsent(cspStr, newCid);
        if (aLong != null) {
            return aLong;
        }
        this.cidToCsp.put(newCid, cspStr);
        return newCid;
    }

    @Override
    public void storeObject(long cid, Object object) {
        this.cidToObject.put(cid, object);
    }

    @Override
    public void removeCid(long cid) {
        this.cidToObject.remove(cid);
        String removed = this.cidToCsp.remove(cid);
        if (removed != null) {
            this.cspToCid.remove(removed);
        }
    }

    @Override
    public long createProxy(String type) {
        this.createProxy0(type, this.cspBuff);
        long cid = this.acquireCid(this.cspBuff);
        this.outWire.writeEventName((WireKey)CoreFields.reply).typePrefix((CharSequence)"set-proxy").marshallable(w -> {
            w.writeEventName((WireKey)CoreFields.csp).text((CharSequence)this.cspBuff);
            w.writeEventName((WireKey)CoreFields.cid).int64(cid);
        });
        return cid;
    }

    @Override
    public long createProxy(String type, long token) {
        this.createProxy0(type, this.cspBuff);
        this.cspBuff.append("&token=" + token);
        long cid = this.acquireCid(this.cspBuff);
        this.outWire.writeEventName((WireKey)CoreFields.reply).typePrefix((CharSequence)"set-proxy").marshallable(w -> {
            w.writeEventName((WireKey)CoreFields.csp).text((CharSequence)this.cspBuff);
            w.writeEventName((WireKey)CoreFields.cid).int64(cid);
        });
        return cid;
    }

    private void createProxy0(String type, StringBuilder cspBuff) {
        Class valueType;
        this.cspBuff.setLength(0);
        this.cspBuff.append(this.requestContext.fullName());
        this.cspBuff.append("?");
        this.cspBuff.append("view=").append(type);
        Class keyType = this.requestContext.keyType();
        if (keyType != null) {
            this.cspBuff.append("&keyType=").append(keyType.getName());
        }
        if ((valueType = this.requestContext.valueType()) != null) {
            this.cspBuff.append("&valueType=").append(valueType.getName());
        }
    }

    public CharSequence getCspForCid(long cid) {
        return this.cidToCsp.get(cid);
    }

    public void setCid(String csp, long cid) {
        this.cidToCsp.put(cid, csp);
    }
}

