/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine.server.internal;

import java.io.Serializable;
import net.openhft.chronicle.core.annotation.UsedViaReflection;
import net.openhft.chronicle.engine.api.map.MapView;
import net.openhft.chronicle.engine.api.tree.Asset;
import net.openhft.chronicle.engine.cfg.EngineClusterContext;
import net.openhft.chronicle.engine.tree.VanillaAsset;
import net.openhft.chronicle.network.ConnectionListener;
import net.openhft.chronicle.network.MarshallableFunction;
import net.openhft.chronicle.network.NetworkContext;
import net.openhft.chronicle.network.ServerThreadingStrategy;
import net.openhft.chronicle.network.VanillaNetworkContext;
import net.openhft.chronicle.network.api.TcpHandler;
import net.openhft.chronicle.network.cluster.ClusterContext;
import net.openhft.chronicle.wire.AbstractMarshallable;
import net.openhft.chronicle.wire.Demarshallable;
import net.openhft.chronicle.wire.WireIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EngineWireNetworkContext<T extends EngineWireNetworkContext>
extends VanillaNetworkContext<T> {
    static final Logger LOG = LoggerFactory.getLogger(EngineWireNetworkContext.class);
    private static final String PROC_CONNECTIONS_CLUSTER = "/proc/connections/cluster/";
    private static final String CONNECTIVITY_URI = "/proc/connections/cluster/connectivity";
    private static final String CONNECTIVITY_HOSTS_URI = "/proc/connections/cluster/hosts";
    private Asset rootAsset;
    private MapView<ConnectionDetails, ConnectionEvent> hostByConnectionStatus;
    private MapView<String, ConnectionStatus> connectivityHosts;
    private TcpHandler handler;

    public TcpHandler handler() {
        return this.handler;
    }

    public EngineWireNetworkContext(@NotNull Asset asset) {
        this.rootAsset = asset.root();
        this.serverThreadingStrategy(ServerThreadingStrategy.CONCURRENT);
        ((VanillaAsset)this.rootAsset.acquireAsset("/proc")).configMapServer();
        this.hostByConnectionStatus = this.rootAsset.root().acquireMap(CONNECTIVITY_URI, ConnectionDetails.class, ConnectionEvent.class);
        this.connectivityHosts = this.rootAsset.root().acquireMap(CONNECTIVITY_HOSTS_URI, String.class, ConnectionStatus.class);
    }

    @NotNull
    public Asset rootAsset() {
        return this.rootAsset;
    }

    public void onHandlerChanged(TcpHandler handler) {
        this.handler = handler;
    }

    @Nullable
    public ConnectionListener acquireConnectionListener() {
        return new ConnectionListener(){

            public void onConnected(int localIdentifier, int remoteIdentifier, boolean isAcceptor) {
                ConnectionDetails key = new ConnectionDetails(localIdentifier, remoteIdentifier, isAcceptor);
                EngineWireNetworkContext.this.hostByConnectionStatus.put(key, new ConnectionEvent(ConnectionStatus.CONNECTED));
                LOG.info(key + ", connectionStatus=" + ConnectionStatus.CONNECTED);
                this.onConnectionChanged(localIdentifier, remoteIdentifier, isAcceptor);
            }

            public void onDisconnected(int localIdentifier, int remoteIdentifier, boolean isAcceptor) {
                ConnectionDetails key = new ConnectionDetails(localIdentifier, remoteIdentifier, isAcceptor);
                EngineWireNetworkContext.this.hostByConnectionStatus.put(key, new ConnectionEvent(ConnectionStatus.DISCONNECTED));
                LOG.info(key + ", connectionStatus=" + ConnectionStatus.DISCONNECTED);
                this.onConnectionChanged(localIdentifier, remoteIdentifier, isAcceptor);
            }

            private void onConnectionChanged(int localIdentifier, int remoteIdentifier, boolean isAcceptor) {
                ConnectionDetails k1a = new ConnectionDetails(localIdentifier, remoteIdentifier, isAcceptor);
                ConnectionDetails k1b = new ConnectionDetails(remoteIdentifier, localIdentifier, !isAcceptor);
                ConnectionDetails k2a = new ConnectionDetails(localIdentifier, remoteIdentifier, !isAcceptor);
                ConnectionDetails k2b = new ConnectionDetails(remoteIdentifier, localIdentifier, isAcceptor);
                ConnectionStatus connectionStatus = ConnectionStatus.DISCONNECTED;
                if (this.get(k1a) == ConnectionStatus.CONNECTED && this.get(k1b) == ConnectionStatus.CONNECTED || this.get(k2a) == ConnectionStatus.CONNECTED && this.get(k2b) == ConnectionStatus.CONNECTED) {
                    connectionStatus = ConnectionStatus.CONNECTED;
                }
                EngineWireNetworkContext.this.connectivityHosts.put("" + localIdentifier + "<->" + remoteIdentifier, connectionStatus);
            }

            private ConnectionStatus get(ConnectionDetails connectionDetails) {
                ConnectionEvent connectionEvent = (ConnectionEvent)EngineWireNetworkContext.this.hostByConnectionStatus.get(connectionDetails);
                if (connectionEvent == null) {
                    return ConnectionStatus.DISCONNECTED;
                }
                return connectionEvent.connectionStatus;
            }
        };
    }

    @NotNull
    public String toString() {
        return "hostByConnectionStatus=" + this.hostByConnectionStatus.entrySet().toString();
    }

    public static class Factory
    implements MarshallableFunction<ClusterContext, NetworkContext>,
    Demarshallable {
        @UsedViaReflection
        private Factory(@NotNull WireIn wireIn) {
        }

        public Factory() {
        }

        @NotNull
        public NetworkContext apply(@NotNull ClusterContext context) {
            return new EngineWireNetworkContext(((EngineClusterContext)context).assetRoot());
        }
    }

    public static class ConnectionDetails
    extends AbstractMarshallable
    implements Serializable {
        public int localIdentifier;
        public int remoteIdentifier;
        public boolean isAcceptor;

        ConnectionDetails(int localIdentifier, int remoteIdentifier, boolean isAcceptor) {
            this.localIdentifier = localIdentifier;
            this.remoteIdentifier = remoteIdentifier;
            this.isAcceptor = isAcceptor;
        }

        public int localIdentifier() {
            return this.localIdentifier;
        }

        public int remoteIdentifier() {
            return this.remoteIdentifier;
        }

        @NotNull
        public String toString() {
            return "localId=" + this.localIdentifier + ", remoteId=" + this.remoteIdentifier + ", isAcceptor=" + this.isAcceptor;
        }
    }

    private static class ConnectionEvent
    extends AbstractMarshallable
    implements Serializable {
        public ConnectionStatus connectionStatus;
        public long timeStamp;

        ConnectionEvent(ConnectionStatus connectionStatus) {
            this.connectionStatus = connectionStatus;
            this.timeStamp = System.currentTimeMillis();
        }
    }

    static enum ConnectionStatus implements Serializable
    {
        CONNECTED,
        DISCONNECTED;

    }
}

