/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine.server.internal;

import java.util.function.BiConsumer;
import java.util.function.Function;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.pool.StringBuilderPool;
import net.openhft.chronicle.core.util.SerializableBiFunction;
import net.openhft.chronicle.core.util.SerializableUpdaterWithArg;
import net.openhft.chronicle.engine.api.map.MapView;
import net.openhft.chronicle.engine.api.tree.RequestContext;
import net.openhft.chronicle.engine.map.remote.RemoteKeyValueStore;
import net.openhft.chronicle.engine.server.internal.AbstractHandler;
import net.openhft.chronicle.engine.server.internal.CspManager;
import net.openhft.chronicle.engine.server.internal.WireAdapter;
import net.openhft.chronicle.map.ChronicleMap;
import net.openhft.chronicle.network.connection.CoreFields;
import net.openhft.chronicle.wire.ParameterizeWireKey;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.ValueOut;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireKey;
import net.openhft.chronicle.wire.WireOut;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapWireHandler<K, V>
extends AbstractHandler {
    private static final StringBuilderPool SBP = new StringBuilderPool();
    private static final Logger LOG = LoggerFactory.getLogger(MapWireHandler.class);
    private final StringBuilder eventName = new StringBuilder();
    private final CspManager cspManager;
    private BiConsumer<ValueOut, V> vToWire;
    @Nullable
    private Function<ValueIn, K> wireToK;
    @Nullable
    private Function<ValueIn, V> wireToV;
    @Nullable
    private WireIn inWire = null;
    @Nullable
    private MapView<K, V> map;
    private boolean charSequenceValue;
    private long tid;
    private final BiConsumer<WireIn, Long> dataConsumer = new BiConsumer<WireIn, Long>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void accept(WireIn wireIn, Long inputTid) {
            block12: {
                try {
                    MapWireHandler.this.eventName.setLength(0);
                    ValueIn valueIn = MapWireHandler.this.inWire.readEventName(MapWireHandler.this.eventName);
                    assert (MapWireHandler.this.startEnforceInValueReadCheck(MapWireHandler.this.inWire));
                    if (EventId.put.contentEquals(MapWireHandler.this.eventName)) {
                        valueIn.marshallable(wire -> {
                            Params[] params = (Params[])EventId.put.params();
                            Object key = MapWireHandler.this.wireToK.apply(wire.read((WireKey)params[0]));
                            Object value = MapWireHandler.this.wireToV.apply(wire.read((WireKey)params[1]));
                            AbstractHandler.nullCheck(key);
                            AbstractHandler.nullCheck(value);
                            if (LOG.isDebugEnabled()) {
                                Jvm.debug().on(this.getClass(), "putting key=" + key);
                            }
                            MapWireHandler.this.map.put(key, value);
                        });
                        return;
                    }
                    if (EventId.remove.contentEquals(MapWireHandler.this.eventName)) {
                        Object key = MapWireHandler.this.wireToK.apply(valueIn);
                        AbstractHandler.nullCheck(key);
                        MapWireHandler.this.map.remove(key);
                        return;
                    }
                    if (EventId.update2.contentEquals(MapWireHandler.this.eventName)) {
                        valueIn.marshallable(wire -> {
                            Params[] params = (Params[])EventId.update2.params();
                            SerializableUpdaterWithArg updater = (SerializableUpdaterWithArg)wire.read((WireKey)params[0]).object(Object.class);
                            Object arg = wire.read((WireKey)params[1]).object(Object.class);
                            MapWireHandler.this.map.asyncUpdate(updater, arg);
                        });
                        return;
                    }
                    MapWireHandler.this.outWire.writeDocument(true, wire -> MapWireHandler.this.outWire.writeEventName((WireKey)CoreFields.tid).int64(MapWireHandler.this.tid));
                    MapWireHandler.this.writeData(MapWireHandler.this.inWire, out -> {
                        if (EventId.clear.contentEquals(MapWireHandler.this.eventName)) {
                            MapWireHandler.this.skipValue(valueIn);
                            MapWireHandler.this.map.clear();
                            return;
                        }
                        if (EventId.putAll.contentEquals(MapWireHandler.this.eventName)) {
                            valueIn.sequence((Object)MapWireHandler.this.map, (m, v) -> {
                                while (v.hasNextSequenceItem()) {
                                    valueIn.marshallable(wire -> m.put(MapWireHandler.this.wireToK.apply(wire.read(EventId.put.params()[0])), MapWireHandler.this.wireToV.apply(wire.read(EventId.put.params()[1]))));
                                }
                            });
                            return;
                        }
                        if (EventId.putIfAbsent.contentEquals(MapWireHandler.this.eventName)) {
                            valueIn.marshallable(wire -> {
                                Params[] params = (Params[])EventId.putIfAbsent.params();
                                Object key = MapWireHandler.this.wireToK.apply(wire.read((WireKey)params[0]));
                                Object newValue = MapWireHandler.this.wireToV.apply(wire.read((WireKey)params[1]));
                                Object result = MapWireHandler.this.map.putIfAbsent(key, newValue);
                                AbstractHandler.nullCheck(key);
                                AbstractHandler.nullCheck(newValue);
                                MapWireHandler.this.vToWire.accept(MapWireHandler.this.outWire.writeEventName((WireKey)CoreFields.reply), result);
                            });
                            return;
                        }
                        if (EventId.size.contentEquals(MapWireHandler.this.eventName)) {
                            MapWireHandler.this.skipValue(valueIn);
                            MapWireHandler.this.outWire.writeEventName((WireKey)CoreFields.reply).int64(MapWireHandler.this.map.longSize());
                            return;
                        }
                        if (EventId.keySet.contentEquals(MapWireHandler.this.eventName) || EventId.values.contentEquals(MapWireHandler.this.eventName) || EventId.entrySet.contentEquals(MapWireHandler.this.eventName)) {
                            MapWireHandler.this.skipValue(valueIn);
                            MapWireHandler.this.cspManager.createProxy(MapWireHandler.this.eventName.toString());
                            return;
                        }
                        if (EventId.containsKey.contentEquals(MapWireHandler.this.eventName)) {
                            Object key = MapWireHandler.this.wireToK.apply(valueIn);
                            AbstractHandler.nullCheck(key);
                            MapWireHandler.this.outWire.writeEventName((WireKey)CoreFields.reply).bool(Boolean.valueOf(MapWireHandler.this.map.containsKey(key)));
                            return;
                        }
                        if (EventId.containsValue.contentEquals(MapWireHandler.this.eventName)) {
                            Object value = MapWireHandler.this.wireToV.apply(valueIn);
                            AbstractHandler.nullCheck(value);
                            boolean aBoolean = MapWireHandler.this.map.containsValue(value);
                            MapWireHandler.this.outWire.writeEventName((WireKey)CoreFields.reply).bool(Boolean.valueOf(aBoolean));
                            return;
                        }
                        if (EventId.get.contentEquals(MapWireHandler.this.eventName)) {
                            Object key = MapWireHandler.this.wireToK.apply(valueIn);
                            AbstractHandler.nullCheck(key);
                            if (MapWireHandler.this.charSequenceValue) {
                                StringBuilder sb = SBP.acquireStringBuilder();
                                MapWireHandler.this.vToWire.accept(MapWireHandler.this.outWire.writeEventName((WireKey)CoreFields.reply), ((ChronicleMap)MapWireHandler.this.map).getUsing(key, (Object)sb));
                            } else {
                                MapWireHandler.this.vToWire.accept(MapWireHandler.this.outWire.writeEventName((WireKey)CoreFields.reply), MapWireHandler.this.map.get(key));
                            }
                            return;
                        }
                        if (EventId.getAndPut.contentEquals(MapWireHandler.this.eventName)) {
                            valueIn.marshallable(wire -> {
                                Params[] params = (Params[])EventId.getAndPut.params();
                                Object key = MapWireHandler.this.wireToK.apply(wire.read((WireKey)params[0]));
                                Object value = MapWireHandler.this.wireToV.apply(wire.read((WireKey)params[1]));
                                AbstractHandler.nullCheck(key);
                                AbstractHandler.nullCheck(value);
                                MapWireHandler.this.vToWire.accept(MapWireHandler.this.outWire.writeEventName((WireKey)CoreFields.reply), MapWireHandler.this.map.getAndPut(key, value));
                            });
                            return;
                        }
                        if (EventId.getAndRemove.contentEquals(MapWireHandler.this.eventName)) {
                            Object key = MapWireHandler.this.wireToK.apply(valueIn);
                            AbstractHandler.nullCheck(key);
                            MapWireHandler.this.vToWire.accept(MapWireHandler.this.outWire.writeEventName((WireKey)CoreFields.reply), MapWireHandler.this.map.getAndRemove(key));
                            return;
                        }
                        if (EventId.replace.contentEquals(MapWireHandler.this.eventName)) {
                            valueIn.marshallable(wire -> {
                                Params[] params = (Params[])EventId.replace.params();
                                Object key = MapWireHandler.this.wireToK.apply(wire.read((WireKey)params[0]));
                                Object value = MapWireHandler.this.wireToV.apply(wire.read((WireKey)params[1]));
                                AbstractHandler.nullCheck(key);
                                AbstractHandler.nullCheck(value);
                                MapWireHandler.this.vToWire.accept(MapWireHandler.this.outWire.writeEventName((WireKey)CoreFields.reply), MapWireHandler.this.map.replace(key, value));
                            });
                            return;
                        }
                        if (EventId.replaceForOld.contentEquals(MapWireHandler.this.eventName)) {
                            valueIn.marshallable(wire -> {
                                Params[] params = (Params[])EventId.replaceForOld.params();
                                Object key = MapWireHandler.this.wireToK.apply(wire.read((WireKey)params[0]));
                                Object oldValue = MapWireHandler.this.wireToV.apply(wire.read((WireKey)params[1]));
                                if (MapWireHandler.this.charSequenceValue) {
                                    oldValue = oldValue.toString();
                                }
                                Object newValue = MapWireHandler.this.wireToV.apply(wire.read((WireKey)params[2]));
                                AbstractHandler.nullCheck(key);
                                AbstractHandler.nullCheck(oldValue);
                                AbstractHandler.nullCheck(newValue);
                                MapWireHandler.this.outWire.writeEventName((WireKey)CoreFields.reply).bool(Boolean.valueOf(MapWireHandler.this.map.replace(key, oldValue, newValue)));
                            });
                            return;
                        }
                        if (EventId.putIfAbsent.contentEquals(MapWireHandler.this.eventName)) {
                            valueIn.marshallable(wire -> {
                                Params[] params = (Params[])EventId.putIfAbsent.params();
                                Object key = MapWireHandler.this.wireToK.apply(wire.read((WireKey)params[0]));
                                Object value = MapWireHandler.this.wireToV.apply(wire.read((WireKey)params[1]));
                                AbstractHandler.nullCheck(key);
                                AbstractHandler.nullCheck(value);
                                MapWireHandler.this.vToWire.accept(MapWireHandler.this.outWire.writeEventName((WireKey)CoreFields.reply), MapWireHandler.this.map.putIfAbsent(key, value));
                            });
                            return;
                        }
                        if (EventId.removeWithValue.contentEquals(MapWireHandler.this.eventName)) {
                            valueIn.marshallable(wire -> {
                                Params[] params = (Params[])EventId.removeWithValue.params();
                                Object key = MapWireHandler.this.wireToK.apply(wire.read((WireKey)params[0]));
                                Object value = MapWireHandler.this.wireToV.apply(wire.read((WireKey)params[1]));
                                AbstractHandler.nullCheck(key);
                                AbstractHandler.nullCheck(value);
                                MapWireHandler.this.outWire.writeEventName((WireKey)CoreFields.reply).bool(Boolean.valueOf(MapWireHandler.this.map.remove(key, value)));
                            });
                        }
                        if (EventId.hashCode.contentEquals(MapWireHandler.this.eventName)) {
                            MapWireHandler.this.skipValue(valueIn);
                            MapWireHandler.this.outWire.writeEventName((WireKey)CoreFields.reply).int32(MapWireHandler.this.map.hashCode());
                            return;
                        }
                        if (EventId.applyTo2.contentEquals(MapWireHandler.this.eventName)) {
                            valueIn.marshallable(wire -> {
                                Params[] params = (Params[])EventId.applyTo2.params();
                                SerializableBiFunction function = (SerializableBiFunction)wire.read((WireKey)params[0]).object(Object.class);
                                Object arg = wire.read((WireKey)params[1]).object(Object.class);
                                MapWireHandler.this.outWire.writeEventName((WireKey)CoreFields.reply).object(MapWireHandler.this.map.applyTo(function, arg));
                            });
                            return;
                        }
                        if (EventId.update4.contentEquals(MapWireHandler.this.eventName)) {
                            valueIn.marshallable(wire -> {
                                Params[] params = (Params[])EventId.update4.params();
                                SerializableUpdaterWithArg updater = (SerializableUpdaterWithArg)wire.read((WireKey)params[0]).object(Object.class);
                                Object updateArg = wire.read((WireKey)params[1]).object(Object.class);
                                SerializableBiFunction returnFunction = (SerializableBiFunction)wire.read((WireKey)params[2]).object(Object.class);
                                Object returnArg = wire.read((WireKey)params[3]).object(Object.class);
                                MapWireHandler.this.outWire.writeEventName((WireKey)CoreFields.reply).object(MapWireHandler.this.map.syncUpdate(updater, updateArg, returnFunction, returnArg));
                            });
                            return;
                        }
                        throw new IllegalStateException("unsupported event=" + MapWireHandler.this.eventName);
                    });
                }
                catch (Exception e) {
                    Jvm.warn().on(this.getClass(), (Throwable)e);
                }
                finally {
                    if ($assertionsDisabled || MapWireHandler.this.endEnforceInValueReadCheck(MapWireHandler.this.inWire)) break block12;
                    throw new AssertionError();
                }
            }
        }
    };

    public MapWireHandler(CspManager cspManager) {
        this.cspManager = cspManager;
    }

    public void process(@NotNull WireIn in, @NotNull WireOut out, @NotNull MapView map, long tid, @NotNull WireAdapter wireAdapter, @NotNull RequestContext requestContext) {
        this.vToWire = wireAdapter.valueToWire();
        this.wireToK = wireAdapter.wireToKey();
        this.wireToV = wireAdapter.wireToValue();
        this.requestContext = requestContext;
        this.setOutWire(out);
        try {
            this.inWire = in;
            this.outWire = out;
            this.map = map;
            boolean bl = this.charSequenceValue = map instanceof ChronicleMap && CharSequence.class == ((ChronicleMap)map).valueClass();
            assert (!(map instanceof RemoteKeyValueStore)) : "the server should not be a remove map";
            this.tid = tid;
            this.dataConsumer.accept(in, tid);
        }
        catch (Exception e) {
            Jvm.warn().on(this.getClass(), "", (Throwable)e);
        }
    }

    public static enum EventId implements ParameterizeWireKey
    {
        size(new WireKey[0]),
        containsKey((WireKey[])new Params[]{Params.key}),
        containsValue((WireKey[])new Params[]{Params.value}),
        get((WireKey[])new Params[]{Params.key}),
        getAndPut((WireKey[])new Params[]{Params.key, Params.value}),
        put((WireKey[])new Params[]{Params.key, Params.value}),
        getAndRemove((WireKey[])new Params[]{Params.key}),
        remove((WireKey[])new Params[]{Params.key}),
        clear(new WireKey[0]),
        keySet(new WireKey[0]),
        values(new WireKey[0]),
        entrySet(new WireKey[0]),
        replace((WireKey[])new Params[]{Params.key, Params.value}),
        replaceForOld((WireKey[])new Params[]{Params.key, Params.oldValue, Params.newValue}),
        putIfAbsent((WireKey[])new Params[]{Params.key, Params.value}),
        removeWithValue((WireKey[])new Params[]{Params.key, Params.value}),
        toString(new WireKey[0]),
        putAll(new WireKey[0]),
        hashCode(new WireKey[0]),
        createChannel(new WireKey[0]),
        entrySetRestricted(new WireKey[0]),
        mapForKey(new WireKey[0]),
        putMapped(new WireKey[0]),
        keyBuilder(new WireKey[0]),
        valueBuilder(new WireKey[0]),
        remoteIdentifier(new WireKey[0]),
        numberOfSegments(new WireKey[0]),
        applyTo2((WireKey[])new Params[]{Params.function, Params.arg}),
        update2((WireKey[])new Params[]{Params.updateFunction, Params.updateArg}),
        update4((WireKey[])new Params[]{Params.updateFunction, Params.updateArg, Params.function, Params.arg}),
        bootstrap(new WireKey[0]);

        private final WireKey[] params;

        private <P extends WireKey> EventId(P ... params) {
            this.params = params;
        }

        @NotNull
        public <P extends WireKey> P[] params() {
            return this.params;
        }
    }

    public static enum Params implements WireKey
    {
        key,
        value,
        oldValue,
        eventType,
        newValue,
        timestamp,
        identifier,
        entry,
        updateFunction,
        updateArg,
        function,
        arg;

    }
}

