/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine.server.internal;

import java.util.function.BiConsumer;
import java.util.function.Function;
import net.openhft.chronicle.engine.api.pubsub.Publisher;
import net.openhft.chronicle.engine.api.pubsub.Subscriber;
import net.openhft.chronicle.engine.api.tree.RequestContext;
import net.openhft.chronicle.engine.server.internal.AbstractHandler;
import net.openhft.chronicle.engine.server.internal.WireAdapter;
import net.openhft.chronicle.network.connection.CoreFields;
import net.openhft.chronicle.network.connection.WireOutPublisher;
import net.openhft.chronicle.wire.ParameterizeWireKey;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireKey;
import net.openhft.chronicle.wire.WireOut;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PublisherHandler<E>
extends AbstractHandler {
    private final StringBuilder eventName = new StringBuilder();
    private WireOutPublisher publisher;
    private Publisher<E> view;
    @Nullable
    private Function<ValueIn, E> wireToE;
    private final BiConsumer<WireIn, Long> dataConsumer = new BiConsumer<WireIn, Long>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void accept(@NotNull WireIn inWire, Long inputTid) {
            PublisherHandler.this.eventName.setLength(0);
            ValueIn valueIn = inWire.readEventName(PublisherHandler.this.eventName);
            assert (PublisherHandler.this.startEnforceInValueReadCheck(inWire));
            try {
                if (EventId.registerSubscriber.contentEquals(PublisherHandler.this.eventName)) {
                    Publisher key = PublisherHandler.this.view;
                    Subscriber<Object> listener = message -> {
                        WireOutPublisher wireOutPublisher = PublisherHandler.this.publisher;
                        synchronized (wireOutPublisher) {
                            PublisherHandler.this.publisher.put(key, publish -> {
                                publish.writeDocument(true, wire -> wire.writeEventName((WireKey)CoreFields.tid).int64(inputTid.longValue()));
                                publish.writeNotCompleteDocument(false, wire -> wire.writeEventName((WireKey)CoreFields.reply).marshallable(m -> m.write((WireKey)Params.message).object(message)));
                            });
                        }
                    };
                    boolean bootstrap = true;
                    try {
                        valueIn.marshallable(m -> PublisherHandler.this.view.registerSubscriber(bootstrap, PublisherHandler.this.requestContext.throttlePeriodMs(), listener));
                    }
                    catch (Exception e) {
                        throw new AssertionError((Object)e);
                    }
                    return;
                }
                if (EventId.publish.contentEquals(PublisherHandler.this.eventName)) {
                    valueIn.marshallable(w -> {
                        Params[] params = (Params[])EventId.publish.params();
                        Params param = params[0];
                        ValueIn read = w.read((WireKey)param);
                        Object message = PublisherHandler.this.wireToE.apply(read);
                        AbstractHandler.nullCheck(message);
                        PublisherHandler.this.view.publish(message);
                    });
                }
            }
            finally {
                assert (PublisherHandler.this.endEnforceInValueReadCheck(inWire));
            }
        }
    };

    void process(@NotNull WireIn inWire, @NotNull RequestContext requestContext, @NotNull WireOutPublisher publisher, long tid, @NotNull Publisher view, @NotNull Wire outWire, @NotNull WireAdapter wireAdapter) {
        this.setOutWire((WireOut)outWire);
        this.outWire = outWire;
        this.publisher = publisher;
        this.view = view;
        this.wireToE = wireAdapter.wireToValue();
        this.requestContext = requestContext;
        this.dataConsumer.accept(inWire, tid);
    }

    public static enum EventId implements ParameterizeWireKey
    {
        publish((WireKey[])new Params[]{Params.message}),
        onEndOfSubscription(new WireKey[0]),
        registerSubscriber((WireKey[])new Params[]{Params.message});

        private final WireKey[] params;

        private <P extends WireKey> EventId(P ... params) {
            this.params = params;
        }

        @NotNull
        public <P extends WireKey> P[] params() {
            return this.params;
        }
    }

    public static enum Params implements WireKey
    {
        message;

    }
}

