/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine.server.internal;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.util.SerializableBiFunction;
import net.openhft.chronicle.engine.api.pubsub.Reference;
import net.openhft.chronicle.engine.api.pubsub.Subscriber;
import net.openhft.chronicle.engine.api.tree.RequestContext;
import net.openhft.chronicle.engine.server.internal.AbstractHandler;
import net.openhft.chronicle.engine.server.internal.WireAdapter;
import net.openhft.chronicle.network.connection.CoreFields;
import net.openhft.chronicle.network.connection.WireOutPublisher;
import net.openhft.chronicle.wire.ParameterizeWireKey;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.ValueOut;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireKey;
import net.openhft.chronicle.wire.WireOut;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReferenceHandler<E, T>
extends AbstractHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ReferenceHandler.class);
    private final StringBuilder eventName = new StringBuilder();
    private final Map<Long, Object> tidToListener = new ConcurrentHashMap<Long, Object>();
    private WireOutPublisher publisher;
    private Reference<E> view;
    private StringBuilder csp;
    private BiConsumer<ValueOut, E> vToWire;
    @Nullable
    private final BiConsumer<WireIn, Long> dataConsumer = new BiConsumer<WireIn, Long>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void accept(@NotNull WireIn inWire, final Long inputTid) {
            ReferenceHandler.this.eventName.setLength(0);
            ValueIn valueIn = inWire.readEventName(ReferenceHandler.this.eventName);
            assert (ReferenceHandler.this.startEnforceInValueReadCheck(inWire));
            try {
                if (EventId.set.contentEquals(ReferenceHandler.this.eventName)) {
                    ReferenceHandler.this.view.set(valueIn.object(ReferenceHandler.this.view.getType()));
                    return;
                }
                if (EventId.remove.contentEquals(ReferenceHandler.this.eventName)) {
                    ReferenceHandler.this.skipValue(valueIn);
                    ReferenceHandler.this.view.remove();
                    return;
                }
                if (EventId.update2.contentEquals(ReferenceHandler.this.eventName)) {
                    valueIn.marshallable(wire -> {
                        Params[] params = (Params[])EventId.update2.params();
                        SerializableBiFunction updater = (SerializableBiFunction)wire.read((WireKey)params[0]).object(Object.class);
                        Object arg = wire.read((WireKey)params[1]).object(Object.class);
                        ReferenceHandler.this.view.asyncUpdate(updater, arg);
                    });
                    return;
                }
                if (EventId.registerSubscriber.contentEquals(ReferenceHandler.this.eventName)) {
                    char e;
                    ReferenceHandler.this.skipValue(valueIn);
                    final Reference key = ReferenceHandler.this.view;
                    Subscriber listener = new Subscriber(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void onMessage(Object message) {
                            WireOutPublisher wireOutPublisher = ReferenceHandler.this.publisher;
                            synchronized (wireOutPublisher) {
                                ReferenceHandler.this.publisher.put((Object)key, publish -> {
                                    publish.writeDocument(true, wire -> wire.writeEventName((WireKey)CoreFields.tid).int64(inputTid.longValue()));
                                    publish.writeNotCompleteDocument(false, wire -> wire.writeEventName((WireKey)CoreFields.reply).marshallable(m -> m.write((WireKey)Params.message).object(message)));
                                });
                            }
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void onEndOfSubscription() {
                            WireOutPublisher wireOutPublisher = ReferenceHandler.this.publisher;
                            synchronized (wireOutPublisher) {
                                if (!ReferenceHandler.this.publisher.isClosed()) {
                                    ReferenceHandler.this.publisher.put(null, publish -> {
                                        publish.writeDocument(true, wire -> wire.writeEventName((WireKey)CoreFields.tid).int64(inputTid.longValue()));
                                        publish.writeDocument(false, wire -> wire.writeEventName((WireKey)EventId.onEndOfSubscription).text(""));
                                    });
                                }
                            }
                        }
                    };
                    int p = ReferenceHandler.this.csp.indexOf("bootstrap=");
                    boolean bootstrap = true;
                    if (p != -1 && 'f' == (e = ReferenceHandler.this.csp.charAt(p + 10))) {
                        bootstrap = false;
                    }
                    ReferenceHandler.this.tidToListener.put(inputTid, listener);
                    ReferenceHandler.this.view.registerSubscriber(bootstrap, ReferenceHandler.this.requestContext.throttlePeriodMs(), listener);
                    return;
                }
                if (EventId.unregisterSubscriber.contentEquals(ReferenceHandler.this.eventName)) {
                    long subscriberTid = valueIn.int64();
                    Subscriber listener = (Subscriber)ReferenceHandler.this.tidToListener.remove(subscriberTid);
                    if (listener == null) {
                        Jvm.debug().on(this.getClass(), "No subscriber to present to unregisterSubscriber (" + subscriberTid + ")");
                        return;
                    }
                    ReferenceHandler.this.view.unregisterSubscriber(listener);
                    return;
                }
                ReferenceHandler.this.outWire.writeDocument(true, wire -> ReferenceHandler.this.outWire.writeEventName((WireKey)CoreFields.tid).int64(inputTid.longValue()));
                ReferenceHandler.this.writeData(inWire, out -> {
                    if (EventId.get.contentEquals(ReferenceHandler.this.eventName)) {
                        ReferenceHandler.this.skipValue(valueIn);
                        ReferenceHandler.this.vToWire.accept(ReferenceHandler.this.outWire.writeEventName((WireKey)CoreFields.reply), ReferenceHandler.this.view.get());
                        return;
                    }
                    if (EventId.getAndSet.contentEquals(ReferenceHandler.this.eventName)) {
                        ReferenceHandler.this.vToWire.accept(ReferenceHandler.this.outWire.writeEventName((WireKey)CoreFields.reply), ReferenceHandler.this.view.getAndSet(valueIn.object(ReferenceHandler.this.view.getType())));
                        return;
                    }
                    if (EventId.getAndRemove.contentEquals(ReferenceHandler.this.eventName)) {
                        ReferenceHandler.this.skipValue(valueIn);
                        ReferenceHandler.this.vToWire.accept(ReferenceHandler.this.outWire.writeEventName((WireKey)CoreFields.reply), ReferenceHandler.this.view.getAndRemove());
                        return;
                    }
                    if (EventId.countSubscribers.contentEquals(ReferenceHandler.this.eventName)) {
                        ReferenceHandler.this.skipValue(valueIn);
                        ReferenceHandler.this.outWire.writeEventName((WireKey)CoreFields.reply).int64((long)ReferenceHandler.this.view.subscriberCount());
                        return;
                    }
                    if (EventId.update4.contentEquals(ReferenceHandler.this.eventName)) {
                        valueIn.marshallable(wire -> {
                            Params[] params = (Params[])EventId.update4.params();
                            SerializableBiFunction updater = (SerializableBiFunction)wire.read((WireKey)params[0]).object(Object.class);
                            Object updateArg = wire.read((WireKey)params[1]).object(Object.class);
                            SerializableBiFunction returnFunction = (SerializableBiFunction)wire.read((WireKey)params[2]).object(Object.class);
                            Object returnArg = wire.read((WireKey)params[3]).object(Object.class);
                            ReferenceHandler.this.outWire.writeEventName((WireKey)CoreFields.reply).object(ReferenceHandler.this.view.syncUpdate(updater, updateArg, returnFunction, returnArg));
                        });
                        return;
                    }
                    valueIn.marshallable(wire -> {
                        Params[] params = (Params[])EventId.applyTo2.params();
                        SerializableBiFunction function = (SerializableBiFunction)wire.read((WireKey)params[0]).object(Object.class);
                        Object arg = wire.read((WireKey)params[1]).object(Object.class);
                        ReferenceHandler.this.outWire.writeEventName((WireKey)CoreFields.reply).object(ReferenceHandler.this.view.applyTo(function, arg));
                    });
                });
            }
            finally {
                assert (ReferenceHandler.this.endEnforceInValueReadCheck(inWire));
            }
        }
    };

    @Override
    protected void unregisterAll() {
        this.tidToListener.forEach((k, listener) -> this.view.unregisterSubscriber((Subscriber)listener));
        this.tidToListener.clear();
    }

    void process(@NotNull WireIn inWire, RequestContext requestContext, @NotNull WireOutPublisher publisher, long tid, Reference view, StringBuilder csp, @NotNull Wire outWire, @NotNull WireAdapter wireAdapter) {
        this.csp = csp;
        this.vToWire = wireAdapter.valueToWire();
        this.requestContext = requestContext;
        this.publisher = this.publisher(publisher);
        this.setOutWire((WireOut)outWire);
        this.outWire = outWire;
        this.view = view;
        this.dataConsumer.accept(inWire, tid);
    }

    public static enum EventId implements ParameterizeWireKey
    {
        set(new WireKey[0]),
        get(new WireKey[0]),
        remove(new WireKey[0]),
        getAndRemove(new WireKey[0]),
        applyTo2((WireKey[])new Params[]{Params.function, Params.arg}),
        update2((WireKey[])new Params[]{Params.function, Params.arg}),
        update4((WireKey[])new Params[]{Params.updateFunction, Params.updateArg, Params.function, Params.arg}),
        getAndSet((WireKey[])new Params[]{Params.value}),
        asyncUpdate(new WireKey[0]),
        registerSubscriber(new WireKey[0]),
        unregisterSubscriber(new WireKey[0]),
        countSubscribers(new WireKey[0]),
        onEndOfSubscription(new WireKey[0]);

        private final WireKey[] params;

        private <P extends WireKey> EventId(P ... params) {
            this.params = params;
        }

        @NotNull
        public <P extends WireKey> P[] params() {
            return this.params;
        }
    }

    public static enum Params implements WireKey
    {
        value,
        function,
        updateFunction,
        updateArg,
        arg,
        message;

    }
}

