/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine.server.internal;

import java.util.function.BiConsumer;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.threads.EventHandler;
import net.openhft.chronicle.core.threads.EventLoop;
import net.openhft.chronicle.core.threads.HandlerPriority;
import net.openhft.chronicle.core.threads.InvalidEventHandlerException;
import net.openhft.chronicle.engine.api.EngineReplication;
import net.openhft.chronicle.engine.api.pubsub.Replication;
import net.openhft.chronicle.engine.api.tree.RequestContext;
import net.openhft.chronicle.engine.map.CMap2EngineReplicator;
import net.openhft.chronicle.engine.map.replication.Bootstrap;
import net.openhft.chronicle.engine.server.internal.AbstractHandler;
import net.openhft.chronicle.engine.tree.HostIdentifier;
import net.openhft.chronicle.network.connection.CoreFields;
import net.openhft.chronicle.network.connection.WireOutPublisher;
import net.openhft.chronicle.wire.ParameterizeWireKey;
import net.openhft.chronicle.wire.ReadMarshallable;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireKey;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.WriteMarshallable;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplicationHandler2<E>
extends AbstractHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ReplicationHandler2.class);
    private final StringBuilder eventName = new StringBuilder();
    private Replication replication;
    private WireOutPublisher publisher;
    private HostIdentifier hostId;
    private long tid;
    private boolean isAcceptor;
    private EventLoop eventLoop;
    private byte remoteIdentifier;
    private byte localIdentifier;
    private RequestContext requestContext;
    private long cid;
    @NotNull
    private final BiConsumer<WireIn, Long> dataConsumer = new BiConsumer<WireIn, Long>(){
        final ThreadLocal<CMap2EngineReplicator.VanillaReplicatedEntry> vre = ThreadLocal.withInitial(CMap2EngineReplicator.VanillaReplicatedEntry::new);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void accept(@NotNull WireIn inWire, Long inputTid) {
            ReplicationHandler2.this.eventName.setLength(0);
            ValueIn valueIn = inWire.readEventName(ReplicationHandler2.this.eventName);
            assert (ReplicationHandler2.this.startEnforceInValueReadCheck(inWire));
            try {
                if (CoreFields.lastUpdateTime.contentEquals((CharSequence)ReplicationHandler2.this.eventName)) {
                    if (Jvm.isDebug()) {
                        LOG.info("server : received lastUpdateTime");
                    }
                    long time = valueIn.int64();
                    byte id = inWire.read(() -> "id").int8();
                    ReplicationHandler2.this.replication.setLastModificationTime(id, time);
                    return;
                }
                if (EventId.replicationEvent.contentEquals(ReplicationHandler2.this.eventName)) {
                    if (Jvm.isDebug() && LOG.isDebugEnabled()) {
                        Jvm.debug().on(this.getClass(), "server : received replicationEvent");
                    }
                    CMap2EngineReplicator.VanillaReplicatedEntry replicatedEntry = this.vre.get();
                    valueIn.marshallable((ReadMarshallable)replicatedEntry);
                    if (Jvm.isDebug() && LOG.isDebugEnabled()) {
                        Jvm.debug().on(this.getClass(), "*****\t\t\t\t ->  RECEIVED : SERVER : replication latency=" + (System.currentTimeMillis() - replicatedEntry.timestamp()) + "ms  ");
                    }
                    ReplicationHandler2.this.replication.applyReplication(replicatedEntry);
                    return;
                }
                assert (ReplicationHandler2.this.outWire != null);
                if (EventId.bootstrap.contentEquals(ReplicationHandler2.this.eventName)) {
                    String name = Thread.currentThread().getName();
                    long timestamp = valueIn.int64();
                    assert (this.checkIdentifier());
                    EngineReplication.ModificationIterator mi = ReplicationHandler2.this.replication.acquireModificationIterator(ReplicationHandler2.this.remoteIdentifier);
                    if (mi != null) {
                        mi.dirtyEntries(timestamp);
                    }
                    if (ReplicationHandler2.this.isAcceptor) {
                        ReplicationHandler2.this.outWire.writeDocument(true, d -> {
                            String fullName = ReplicationHandler2.this.requestContext.fullName();
                            ReplicationHandler2.this.outWire.write((WireKey)CoreFields.csp).text(fullName + "?view=Replication").write((WireKey)CoreFields.cid).int64(ReplicationHandler2.this.cid);
                        });
                        ReplicationHandler2.this.outWire.writeDocument(false, d -> ReplicationHandler2.this.outWire.write((WireKey)EventId.bootstrap).int64(ReplicationHandler2.this.replication.lastModificationTime(ReplicationHandler2.this.remoteIdentifier)).writeComment((CharSequence)("localIdentifier=" + ReplicationHandler2.this.hostId.hostId() + ",remoteIdentifier=" + ReplicationHandler2.this.remoteIdentifier)));
                        ReplicationHandler2.this.logYaml();
                    }
                    if (Jvm.isDebug()) {
                        LOG.info("server : received simplebootstrap");
                    }
                    if (mi == null) {
                        return;
                    }
                    mi.setModificationNotifier(() -> ((EventLoop)ReplicationHandler2.this.eventLoop).unpause());
                    ReplicationHandler2.this.eventLoop.addHandler(true, (EventHandler)new ReplicationEventHandler(mi, ReplicationHandler2.this.remoteIdentifier, inputTid));
                    return;
                }
                ReplicationHandler2.this.outWire.writeDocument(true, wire -> ReplicationHandler2.this.outWire.writeEventName((WireKey)CoreFields.tid).int64(ReplicationHandler2.this.tid));
                if (EventId.identifier.contentEquals(ReplicationHandler2.this.eventName)) {
                    ReplicationHandler2.this.writeData(inWire, out -> ReplicationHandler2.this.outWire.write((WireKey)EventId.identifierReply).int8(ReplicationHandler2.this.hostId.hostId()));
                }
                if (EventId.bootstrap.contentEquals(ReplicationHandler2.this.eventName)) {
                    ReplicationHandler2.this.writeData(true, inWire.bytes(), out -> {
                        Bootstrap inBootstrap;
                        if (LOG.isDebugEnabled()) {
                            Jvm.debug().on(this.getClass(), "server : received bootstrap request");
                        }
                        if ((inBootstrap = (Bootstrap)((Object)((Object)valueIn.typedMarshallable()))) == null) {
                            return;
                        }
                        byte id = inBootstrap.identifier();
                        EngineReplication.ModificationIterator mi = ReplicationHandler2.this.replication.acquireModificationIterator(id);
                        if (mi != null) {
                            mi.dirtyEntries(inBootstrap.lastUpdatedTime());
                        }
                        Bootstrap outBootstrap = new Bootstrap();
                        outBootstrap.identifier(ReplicationHandler2.this.hostId.hostId());
                        outBootstrap.lastUpdatedTime(ReplicationHandler2.this.replication.lastModificationTime(id));
                        ReplicationHandler2.this.outWire.writeEventName((WireKey)EventId.bootstrap).typedMarshallable((WriteMarshallable)outBootstrap);
                        if (Jvm.isDebug()) {
                            LOG.info("server : received replicationSubscribe");
                        }
                        if (mi == null) {
                            return;
                        }
                        mi.setModificationNotifier(() -> ((EventLoop)ReplicationHandler2.this.eventLoop).unpause());
                        ReplicationHandler2.this.eventLoop.addHandler(true, (EventHandler)new ReplicationEventHandler(mi, id, inputTid));
                    });
                }
            }
            finally {
                assert (ReplicationHandler2.this.endEnforceInValueReadCheck(inWire));
            }
        }

        private boolean checkIdentifier() {
            if (ReplicationHandler2.this.localIdentifier != ReplicationHandler2.this.remoteIdentifier) {
                Jvm.warn().on(this.getClass(), "identifier comparison: " + ReplicationHandler2.this.localIdentifier + " != " + ReplicationHandler2.this.remoteIdentifier);
            }
            return true;
        }
    };

    void process(@NotNull WireIn inWire, WireOutPublisher publisher, long tid, @NotNull Wire outWire, HostIdentifier hostId, Replication replication, EventLoop eventLoop, boolean isServerSocket, byte remoteIdentifier, RequestContext requestContext, long cid, byte localIdentifier) {
        this.eventLoop = eventLoop;
        this.isAcceptor = isServerSocket;
        this.setOutWire((WireOut)outWire);
        this.localIdentifier = localIdentifier;
        this.hostId = hostId;
        this.publisher = publisher;
        this.replication = replication;
        this.tid = tid;
        this.remoteIdentifier = remoteIdentifier;
        this.requestContext = requestContext;
        this.cid = cid;
        this.dataConsumer.accept(inWire, tid);
    }

    private class ReplicationEventHandler
    implements EventHandler {
        private final EngineReplication.ModificationIterator mi;
        private final byte id;
        boolean hasSentLastUpdateTime;
        long lastUpdateTime;
        boolean hasLogged;
        int count;
        long startBufferFullTimeStamp;

        public ReplicationEventHandler(EngineReplication.ModificationIterator mi, byte id, Long inputTid) {
            this.mi = mi;
            this.id = id;
            this.lastUpdateTime = 0L;
            this.hasLogged = false;
            this.count = 0;
            this.startBufferFullTimeStamp = 0L;
        }

        @NotNull
        public HandlerPriority priority() {
            return HandlerPriority.REPLICATION;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean action() throws InvalidEventHandlerException {
            WireOutPublisher publisher;
            if (ReplicationHandler2.this.connectionClosed) {
                throw new InvalidEventHandlerException();
            }
            WireOutPublisher wireOutPublisher = publisher = ReplicationHandler2.this.publisher;
            synchronized (wireOutPublisher) {
                if (!publisher.canTakeMoreData()) {
                    if (this.startBufferFullTimeStamp == 0L) {
                        this.startBufferFullTimeStamp = System.currentTimeMillis();
                    }
                    return false;
                }
                if (!this.mi.hasNext()) {
                    if (this.startBufferFullTimeStamp != 0L) {
                        long timetaken = System.currentTimeMillis() - this.startBufferFullTimeStamp;
                        if (timetaken > 100L) {
                            LOG.info("blocked - outbound buffer full=" + timetaken + "ms");
                        }
                        this.startBufferFullTimeStamp = 0L;
                    }
                    if (!this.hasSentLastUpdateTime && this.lastUpdateTime > 0L) {
                        publisher.put(null, w -> {
                            w.writeDocument(true, d -> d.write((WireKey)CoreFields.cid).int64(ReplicationHandler2.this.cid));
                            w.writeNotCompleteDocument(false, d -> {
                                d.writeEventName((WireKey)CoreFields.lastUpdateTime).int64(this.lastUpdateTime);
                                d.write(() -> "id").int8(this.id);
                            });
                        });
                        this.hasSentLastUpdateTime = true;
                        if (!this.hasLogged) {
                            LOG.info("received ALL replication the EVENTS for id=" + this.id);
                            this.hasLogged = true;
                        }
                    }
                    return false;
                }
                this.mi.nextEntry(e -> publisher.put(null, w -> {
                    if (e.remoteIdentifier() == ReplicationHandler2.this.hostId.hostId()) {
                        return;
                    }
                    long newlastUpdateTime = Math.max(this.lastUpdateTime, e.timestamp());
                    if (newlastUpdateTime > this.lastUpdateTime) {
                        this.hasSentLastUpdateTime = false;
                        this.lastUpdateTime = newlastUpdateTime;
                    }
                    if (LOG.isDebugEnabled()) {
                        Jvm.debug().on(this.getClass(), "publish from server response from iterator localIdentifier=" + ReplicationHandler2.this.hostId + " ,remoteIdentifier=" + this.id + " event=" + e);
                    }
                    w.writeDocument(true, d -> d.write((WireKey)CoreFields.cid).int64(ReplicationHandler2.this.cid));
                    w.writeNotCompleteDocument(false, d -> d.writeEventName((WireKey)EventId.replicationEvent).typedMarshallable((WriteMarshallable)e));
                }));
            }
            return true;
        }

        @NotNull
        public String toString() {
            return "ReplicationEventHandler{id=" + this.id + ",connectionClosed=" + ReplicationHandler2.this.connectionClosed + '}';
        }
    }

    public static enum EventId implements ParameterizeWireKey
    {
        publish(new WireKey[0]),
        onEndOfSubscription(new WireKey[0]),
        apply(new WireKey[0]),
        replicationEvent(new WireKey[0]),
        identifierReply(new WireKey[0]),
        bootstrap(new WireKey[0]),
        identifier(new WireKey[0]);

        private final WireKey[] params;

        @SafeVarargs
        private <P extends WireKey> EventId(P ... params) {
            this.params = params;
        }

        @NotNull
        public <P extends WireKey> P[] params() {
            return this.params;
        }
    }
}

