/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine.server.internal;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.engine.api.map.MapEvent;
import net.openhft.chronicle.engine.api.pubsub.InvalidSubscriberException;
import net.openhft.chronicle.engine.api.pubsub.Subscriber;
import net.openhft.chronicle.engine.api.pubsub.SubscriptionCollection;
import net.openhft.chronicle.engine.api.tree.Asset;
import net.openhft.chronicle.engine.api.tree.AssetNotFoundException;
import net.openhft.chronicle.engine.api.tree.RequestContext;
import net.openhft.chronicle.engine.query.Filter;
import net.openhft.chronicle.engine.server.internal.AbstractHandler;
import net.openhft.chronicle.engine.server.internal.ObjectKVSubscriptionHandler;
import net.openhft.chronicle.network.connection.CoreFields;
import net.openhft.chronicle.network.connection.WireOutPublisher;
import net.openhft.chronicle.wire.ParameterizeWireKey;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireKey;
import net.openhft.chronicle.wire.Wires;
import net.openhft.chronicle.wire.WriteMarshallable;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscriptionHandler<T extends SubscriptionCollection>
extends AbstractHandler {
    private static final Logger LOG = LoggerFactory.getLogger(SubscriptionHandler.class);
    final StringBuilder eventName = new StringBuilder();
    final Map<Long, Object> tidToListener = new ConcurrentHashMap<Long, Object>();
    Wire outWire;
    T subscription;
    WireOutPublisher publisher;
    Asset asset;

    boolean after(@NotNull StringBuilder eventName) {
        if (SubscriptionEventID.topicSubscriberCount.contentEquals(eventName)) {
            this.outWire.writeEventName((WireKey)CoreFields.reply).int8((long)this.subscription.topicSubscriberCount());
            return true;
        }
        if (SubscriptionEventID.keySubscriberCount.contentEquals(eventName)) {
            this.outWire.writeEventName((WireKey)CoreFields.reply).int8((long)this.subscription.keySubscriberCount());
            return true;
        }
        if (SubscriptionEventID.entrySubscriberCount.contentEquals(eventName)) {
            this.outWire.writeEventName((WireKey)CoreFields.reply).int8((long)this.subscription.entrySubscriberCount());
            return true;
        }
        return false;
    }

    boolean before(Long tid, @NotNull ValueIn valueIn) throws AssetNotFoundException {
        if (SubscriptionEventID.registerSubscriber.contentEquals(this.eventName)) {
            Filter filter;
            Class subscriptionType = valueIn.typeLiteral();
            StringBuilder sb = Wires.acquireStringBuilder();
            ValueIn valueIn1 = valueIn.wireIn().readEventName(sb);
            Filter filter2 = filter = "filter".contentEquals(sb) ? (Filter)valueIn1.object(Filter.class) : Filter.empty();
            if (this.tidToListener.containsKey(tid)) {
                LOG.info("Duplicate registration for tid " + tid);
                return true;
            }
            WireOutPublisher pub = this.requestContext.throttlePeriodMs() == 0 ? this.publisher : WireOutPublisher.newThrottledWireOutPublisher((int)this.requestContext.throttlePeriodMs(), (WireOutPublisher)this.publisher);
            LocalSubscriber listener = new LocalSubscriber(tid, pub);
            this.tidToListener.put(tid, listener);
            RequestContext rc = this.requestContext.clone().elementType(subscriptionType);
            SubscriptionCollection subscription = this.asset.acquireSubscription(rc);
            subscription.registerSubscriber(rc, listener, filter);
            return true;
        }
        if (SubscriptionEventID.unregisterSubscriber.contentEquals(this.eventName)) {
            this.skipValue(valueIn);
            Subscriber listener = (Subscriber)this.tidToListener.remove(tid);
            if (listener == null) {
                Jvm.debug().on(this.getClass(), "No subscriber to present to unregisterSubscriber (" + tid + ")");
                return true;
            }
            this.asset.unregisterSubscriber(this.requestContext, listener);
            return true;
        }
        return false;
    }

    @Override
    protected void unregisterAll() {
        this.tidToListener.forEach((k, listener) -> this.asset.unregisterSubscriber(this.requestContext, (Subscriber)listener));
        this.tidToListener.clear();
    }

    class LocalSubscriber
    implements Subscriber<Object> {
        private final Long tid;
        private final WireOutPublisher publisher;
        volatile boolean subscriptionEnded;

        LocalSubscriber(Long tid, WireOutPublisher publisher) {
            this.tid = tid;
            this.publisher = publisher;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onMessage(Object e) throws InvalidSubscriberException {
            if (this.subscriptionEnded) {
                return;
            }
            WriteMarshallable event = p -> {
                p.writeDocument(true, wire -> wire.writeEventName((WireKey)CoreFields.tid).int64(this.tid.longValue()));
                p.writeNotCompleteDocument(false, wire -> wire.write((WireKey)CoreFields.reply).object(e));
            };
            Object key = e instanceof MapEvent ? ((MapEvent)e).getKey() : e;
            WireOutPublisher wireOutPublisher = this.publisher;
            synchronized (wireOutPublisher) {
                this.publisher.put(key, event);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onEndOfSubscription() {
            this.subscriptionEnded = true;
            WireOutPublisher wireOutPublisher = this.publisher;
            synchronized (wireOutPublisher) {
                if (!this.publisher.isClosed()) {
                    WriteMarshallable toPublish = publish -> {
                        publish.writeDocument(true, wire -> wire.writeEventName((WireKey)CoreFields.tid).int64(this.tid.longValue()));
                        publish.writeDocument(false, wire -> wire.writeEventName((WireKey)ObjectKVSubscriptionHandler.EventId.onEndOfSubscription).text(""));
                    };
                    this.publisher.put(null, toPublish);
                }
            }
        }

        @NotNull
        public String toString() {
            return "LocalSubscriber{tid=" + this.tid + '}';
        }
    }

    public static enum SubscriptionEventID implements ParameterizeWireKey
    {
        registerSubscriber(new WireKey[0]),
        unregisterSubscriber(new WireKey[0]),
        keySubscriberCount(new WireKey[0]),
        entrySubscriberCount(new WireKey[0]),
        topicSubscriberCount(new WireKey[0]);

        private final WireKey[] params;

        private <P extends WireKey> SubscriptionEventID(P ... params) {
            this.params = params;
        }

        @NotNull
        public <P extends WireKey> P[] params() {
            return this.params;
        }
    }
}

