/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine.server.internal;

import java.time.LocalTime;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.openhft.chronicle.engine.cfg.UserStat;
import net.openhft.chronicle.engine.server.internal.AbstractHandler;
import net.openhft.chronicle.engine.tree.HostIdentifier;
import net.openhft.chronicle.network.ClientClosedProvider;
import net.openhft.chronicle.network.SessionMode;
import net.openhft.chronicle.network.api.session.SessionDetailsProvider;
import net.openhft.chronicle.network.connection.CoreFields;
import net.openhft.chronicle.network.connection.WireOutPublisher;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.VanillaWireParser;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireKey;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.WireParser;
import net.openhft.chronicle.wire.WireType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SystemHandler
extends AbstractHandler
implements ClientClosedProvider {
    private final StringBuilder eventName = new StringBuilder();
    private SessionDetailsProvider sessionDetails;
    private final WireParser<Void> wireParser = this.wireParser();
    @Nullable
    private Map<String, UserStat> monitoringMap;
    private volatile boolean hasClientClosed;
    private boolean wasHeartBeat;
    @NotNull
    private final BiConsumer<WireIn, Long> dataConsumer = (inWire, tid) -> {
        this.eventName.setLength(0);
        ValueIn valueIn = inWire.readEventName(this.eventName);
        try {
            assert (this.startEnforceInValueReadCheck((WireIn)inWire));
            if (EventId.userId.contentEquals(this.eventName)) {
                this.sessionDetails.userId(valueIn.text());
                if (this.monitoringMap != null) {
                    UserStat userStat = new UserStat();
                    userStat.setLoggedIn(LocalTime.now());
                    this.monitoringMap.put(this.sessionDetails.userId(), userStat);
                }
                while (inWire.bytes().readRemaining() > 0L) {
                    this.wireParser.parseOne(inWire, null);
                }
                return;
            }
            this.skipValue(valueIn);
            if (!EventId.heartbeat.contentEquals(this.eventName) && !EventId.onClientClosing.contentEquals(this.eventName)) {
                return;
            }
            this.wasHeartBeat = true;
            this.outWire.writeDocument(true, wire -> this.outWire.writeEventName((WireKey)CoreFields.tid).int64(tid.longValue()));
            this.writeData((WireIn)inWire, out -> {
                if (EventId.heartbeat.contentEquals(this.eventName)) {
                    this.outWire.write((WireKey)EventId.heartbeatReply).int64(valueIn.int64());
                } else if (EventId.onClientClosing.contentEquals(this.eventName)) {
                    this.hasClientClosed = true;
                    this.outWire.write((WireKey)EventId.onClosingReply).text("");
                }
            });
        }
        finally {
            assert (this.endEnforceInValueReadCheck((WireIn)inWire));
        }
    };

    public boolean wasHeartBeat() {
        return this.wasHeartBeat;
    }

    void process(@NotNull WireIn inWire, @NotNull WireOut outWire, long tid, @NotNull SessionDetailsProvider sessionDetails, @Nullable Map<String, UserStat> monitoringMap, boolean isServerSocket, @Nullable Supplier<WireOutPublisher> publisher, @Nullable HostIdentifier hostId, @NotNull Consumer<WireType> onWireType, @Nullable WireType wireType0) {
        this.wasHeartBeat = false;
        this.sessionDetails = sessionDetails;
        this.monitoringMap = monitoringMap;
        this.setOutWire(outWire);
        this.dataConsumer.accept(inWire, tid);
        if (wireType0 == null && sessionDetails.wireType() != null) {
            onWireType.accept(sessionDetails.wireType());
        }
    }

    @NotNull
    private WireParser<Void> wireParser() {
        VanillaWireParser parser = new VanillaWireParser((s, v, $) -> {});
        parser.register(EventId.domain::toString, (s, v, $) -> v.text((Object)this, (o, x) -> o.sessionDetails.domain(x)));
        parser.register(EventId.sessionMode::toString, (s, v, $) -> v.text((Object)this, (o, x) -> o.sessionDetails.sessionMode(SessionMode.valueOf((String)x))));
        parser.register(EventId.securityToken::toString, (s, v, $) -> v.text((Object)this, (o, x) -> o.sessionDetails.securityToken(x)));
        parser.register(EventId.clientId::toString, (s, v, $) -> v.text((Object)this, (o, x) -> o.sessionDetails.clientId(UUID.fromString(x))));
        parser.register(EventId.wireType::toString, (s, v, $) -> v.text((Object)this, (o, x) -> o.sessionDetails.wireType(WireType.valueOf((String)x))));
        parser.register(EventId.hostId::toString, (s, v, $) -> v.int8((Object)this, (o, x) -> o.sessionDetails.hostId(x)));
        return parser;
    }

    public boolean hasClientClosed() {
        return this.hasClientClosed;
    }

    public static enum EventId implements WireKey
    {
        heartbeat,
        heartbeatReply,
        onClientClosing,
        onClosingReply,
        userId,
        sessionMode,
        domain,
        securityToken,
        wireType,
        clientId,
        hostId;

    }
}

