/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine.server.internal;

import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.annotation.UsedViaReflection;
import net.openhft.chronicle.core.threads.EventLoop;
import net.openhft.chronicle.engine.api.tree.Asset;
import net.openhft.chronicle.engine.fs.Clusters;
import net.openhft.chronicle.engine.fs.EngineCluster;
import net.openhft.chronicle.engine.server.internal.CspTcpHander;
import net.openhft.chronicle.engine.server.internal.EngineWireNetworkContext;
import net.openhft.chronicle.engine.tree.HostIdentifier;
import net.openhft.chronicle.network.WireTcpHandler;
import net.openhft.chronicle.network.api.session.SubHandler;
import net.openhft.chronicle.network.cluster.ClusterContext;
import net.openhft.chronicle.network.cluster.ConnectionChangedNotifier;
import net.openhft.chronicle.network.cluster.ConnectionStrategy;
import net.openhft.chronicle.network.cluster.HeartbeatEventHandler;
import net.openhft.chronicle.network.cluster.HostDetails;
import net.openhft.chronicle.network.cluster.TerminatorHandler;
import net.openhft.chronicle.network.connection.WireOutPublisher;
import net.openhft.chronicle.threads.NamedThreadFactory;
import net.openhft.chronicle.wire.Demarshallable;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.WireType;
import net.openhft.chronicle.wire.WriteMarshallable;
import org.jetbrains.annotations.NotNull;

public class UberHandler
extends CspTcpHander<EngineWireNetworkContext>
implements Demarshallable,
WriteMarshallable {
    private final int remoteIdentifier;
    private final int localIdentifier;
    @NotNull
    private AtomicBoolean isClosing = new AtomicBoolean();
    private ConnectionChangedNotifier connectionChangedNotifier;
    private Asset rootAsset;
    @NotNull
    private String clusterName;
    private int writerIndex;

    @UsedViaReflection
    private UberHandler(@NotNull WireIn wire) {
        this.remoteIdentifier = wire.read(() -> "remoteIdentifier").int32();
        this.localIdentifier = wire.read(() -> "localIdentifier").int32();
        WireType wireType = (WireType)wire.read(() -> "wireType").object(WireType.class);
        this.clusterName = wire.read(() -> "clusterName").text();
        this.wireType(wireType);
    }

    private UberHandler(int localIdentifier, int remoteIdentifier, @NotNull WireType wireType, @NotNull String clusterName) {
        this.localIdentifier = localIdentifier;
        this.remoteIdentifier = remoteIdentifier;
        assert (remoteIdentifier != localIdentifier) : "remoteIdentifier=" + remoteIdentifier + ", localIdentifier=" + localIdentifier;
        this.clusterName = clusterName;
        this.wireType(wireType);
    }

    private static WriteMarshallable uberHandler(WriteMarshallable m) {
        return wire -> {
            try (DocumentContext dc = wire.writingDocument(true);){
                wire.write(() -> "handler").typedMarshallable(m);
            }
        };
    }

    public int remoteIdentifier() {
        return this.remoteIdentifier;
    }

    public boolean isClosed() {
        return this.isClosing.get();
    }

    public void writeMarshallable(@NotNull WireOut wire) {
        wire.write(() -> "remoteIdentifier").int32(this.localIdentifier);
        wire.write(() -> "localIdentifier").int32(this.remoteIdentifier);
        WireType value = this.wireType();
        wire.write(() -> "wireType").object((Object)value);
        wire.write(() -> "clusterName").text(this.clusterName);
    }

    protected void onInitialize() {
        EngineWireNetworkContext nc = (EngineWireNetworkContext)this.nc();
        nc.wireType(this.wireType());
        this.isAcceptor(nc.isAcceptor());
        this.rootAsset = nc.rootAsset();
        assert (this.checkIdentifierEqualsHostId());
        assert (this.remoteIdentifier != this.localIdentifier) : "remoteIdentifier=" + this.remoteIdentifier + ", localIdentifier=" + this.localIdentifier;
        WireOutPublisher publisher = nc.wireOutPublisher();
        this.publisher(publisher);
        EventLoop eventLoop = this.rootAsset.findOrCreateView(EventLoop.class);
        if (!eventLoop.isClosed()) {
            eventLoop.start();
            Clusters clusters = this.rootAsset.findView(Clusters.class);
            EngineCluster engineCluster = clusters.get(this.clusterName);
            if (engineCluster == null) {
                Jvm.warn().on(((Object)((Object)this)).getClass(), "cluster=" + this.clusterName, (Throwable)new RuntimeException("cluster  not found, cluster=" + this.clusterName));
                return;
            }
            if (((EngineWireNetworkContext)this.nc()).isAcceptor()) {
                this.publish(this.uberHandler());
            }
            nc.terminationEventHandler(engineCluster.findTerminationEventHandler(this.remoteIdentifier));
            if (!this.checkConnectionStrategy(engineCluster)) {
                this.publish(TerminatorHandler.terminationHandler((int)this.localIdentifier, (int)this.remoteIdentifier, (long)nc.newCid()));
                this.closeSoon();
                return;
            }
            if (!this.isClosing.get()) {
                this.notifyConnectionListeners(engineCluster);
            }
        }
    }

    private boolean checkIdentifierEqualsHostId() {
        HostIdentifier hostIdentifier = this.rootAsset.findOrCreateView(HostIdentifier.class);
        return hostIdentifier == null || this.localIdentifier == hostIdentifier.hostId();
    }

    private void notifyConnectionListeners(@NotNull EngineCluster cluster) {
        this.connectionChangedNotifier = cluster.findClusterNotifier(this.remoteIdentifier);
        if (this.connectionChangedNotifier != null) {
            this.connectionChangedNotifier.onConnectionChanged(true, this.nc());
        }
    }

    private boolean checkConnectionStrategy(@NotNull EngineCluster cluster) {
        ConnectionStrategy strategy = cluster.findConnectionStrategy(this.remoteIdentifier);
        return strategy == null || strategy.notifyConnected((WireTcpHandler)this, this.localIdentifier, this.remoteIdentifier);
    }

    private WriteMarshallable uberHandler() {
        UberHandler handler = new UberHandler(this.localIdentifier, this.remoteIdentifier, this.wireType(), this.clusterName);
        return UberHandler.uberHandler(handler);
    }

    private void closeSoon() {
        this.isClosing.set(true);
        ScheduledExecutorService closer = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new NamedThreadFactory("closer", Boolean.valueOf(true)));
        closer.schedule(() -> {
            closer.shutdown();
            this.close();
        }, 2L, TimeUnit.SECONDS);
    }

    @Override
    public void close() {
        if (!this.isClosing.getAndSet(true) && this.connectionChangedNotifier != null) {
            this.connectionChangedNotifier.onConnectionChanged(false, this.nc());
        }
        ((EngineWireNetworkContext)this.nc()).acquireConnectionListener().onDisconnected(this.localIdentifier, this.remoteIdentifier(), ((EngineWireNetworkContext)this.nc()).isAcceptor());
        super.close();
    }

    protected void onRead(@NotNull DocumentContext dc, @NotNull WireOut outWire) {
        try {
            if (this.isClosing.get()) {
                return;
            }
            this.onMessageReceivedOrWritten();
            Wire inWire = dc.wire();
            if (dc.isMetaData()) {
                if (!this.readMeta((WireIn)inWire)) {
                    return;
                }
                SubHandler handler = this.handler();
                handler.remoteIdentifier(this.remoteIdentifier);
                handler.localIdentifier(this.localIdentifier);
                try {
                    handler.onInitialize(outWire);
                }
                catch (RejectedExecutionException e) {
                    throw new IllegalStateException("EventGroup shutdown", e);
                }
                return;
            }
            SubHandler handler = this.handler();
            if (handler == null) {
                throw new IllegalStateException("handler == null, check that the Csp/Cid has been sent, failed to fully process the following YAML\n");
            }
            if (dc.isData() && !inWire.bytes().isEmpty()) {
                handler.onRead((WireIn)inWire, outWire);
            }
        }
        catch (Throwable e) {
            Jvm.warn().on(((Object)((Object)this)).getClass(), "failed to parse:" + dc.wire().readingPeekYaml(), e);
        }
    }

    protected void onBytesWritten() {
        this.onMessageReceivedOrWritten();
    }

    protected void onWrite(@NotNull WireOut outWire) {
        SubHandler handler = this.handler();
        if (handler != null) {
            handler.onWrite(outWire);
        }
        for (int i = 0; i < this.writers.size(); ++i) {
            if (this.isClosing.get()) {
                return;
            }
            WriteMarshallable w = this.next();
            if (w == null) continue;
            w.writeMarshallable(outWire);
        }
    }

    private WriteMarshallable next() {
        if (this.writerIndex >= this.writers.size()) {
            this.writerIndex = 0;
        }
        return (WriteMarshallable)this.writers.get(this.writerIndex++);
    }

    private void onMessageReceivedOrWritten() {
        HeartbeatEventHandler heartbeatEventHandler = this.heartbeatEventHandler();
        if (heartbeatEventHandler != null) {
            heartbeatEventHandler.onMessageReceived();
        }
    }

    public static class Factory
    implements BiFunction<ClusterContext, HostDetails, WriteMarshallable>,
    Demarshallable {
        @UsedViaReflection
        private Factory(@NotNull WireIn wireIn) {
        }

        public Factory() {
        }

        @Override
        @NotNull
        public WriteMarshallable apply(@NotNull ClusterContext clusterContext, @NotNull HostDetails hostdetails) {
            byte localIdentifier = clusterContext.localIdentifier();
            int remoteIdentifier = hostdetails.hostId();
            WireType wireType = clusterContext.wireType();
            String name = clusterContext.clusterName();
            return UberHandler.uberHandler(new UberHandler(localIdentifier, remoteIdentifier, wireType, name));
        }
    }
}

