/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine.tree;

import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.function.BiPredicate;
import java.util.function.Function;
import net.openhft.chronicle.core.annotation.ForceInline;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.threads.EventLoop;
import net.openhft.chronicle.core.threads.HandlerPriority;
import net.openhft.chronicle.core.util.ThrowingConsumer;
import net.openhft.chronicle.engine.api.collection.ValuesCollection;
import net.openhft.chronicle.engine.api.column.ColumnView;
import net.openhft.chronicle.engine.api.column.MapColumnView;
import net.openhft.chronicle.engine.api.column.QueueColumnView;
import net.openhft.chronicle.engine.api.column.RemoteColumnView;
import net.openhft.chronicle.engine.api.column.RemoteVaadinChart;
import net.openhft.chronicle.engine.api.column.VaadinChart;
import net.openhft.chronicle.engine.api.column.VanillaVaadinChart;
import net.openhft.chronicle.engine.api.map.KeyValueStore;
import net.openhft.chronicle.engine.api.map.MapView;
import net.openhft.chronicle.engine.api.map.SubscriptionKeyValueStore;
import net.openhft.chronicle.engine.api.pubsub.Publisher;
import net.openhft.chronicle.engine.api.pubsub.Reference;
import net.openhft.chronicle.engine.api.pubsub.Replication;
import net.openhft.chronicle.engine.api.pubsub.SubscriptionCollection;
import net.openhft.chronicle.engine.api.pubsub.TopicPublisher;
import net.openhft.chronicle.engine.api.query.IndexQueueView;
import net.openhft.chronicle.engine.api.query.ObjectCacheFactory;
import net.openhft.chronicle.engine.api.query.VanillaIndexQueueView;
import net.openhft.chronicle.engine.api.query.VanillaObjectCacheFactory;
import net.openhft.chronicle.engine.api.set.EntrySetView;
import net.openhft.chronicle.engine.api.set.KeySetView;
import net.openhft.chronicle.engine.api.tree.Asset;
import net.openhft.chronicle.engine.api.tree.AssetNotFoundException;
import net.openhft.chronicle.engine.api.tree.AssetTreeStats;
import net.openhft.chronicle.engine.api.tree.KeyedView;
import net.openhft.chronicle.engine.api.tree.LeafViewFactory;
import net.openhft.chronicle.engine.api.tree.RequestContext;
import net.openhft.chronicle.engine.api.tree.WrappingViewFactory;
import net.openhft.chronicle.engine.collection.VanillaValuesCollection;
import net.openhft.chronicle.engine.map.AuthenticatedKeyValueStore;
import net.openhft.chronicle.engine.map.MapKVSSubscription;
import net.openhft.chronicle.engine.map.MapWrappingColumnView;
import net.openhft.chronicle.engine.map.ObjectKeyValueStore;
import net.openhft.chronicle.engine.map.ObjectSubscription;
import net.openhft.chronicle.engine.map.QueueObjectSubscription;
import net.openhft.chronicle.engine.map.RawKVSSubscription;
import net.openhft.chronicle.engine.map.RemoteEntrySetView;
import net.openhft.chronicle.engine.map.VanillaEntrySetView;
import net.openhft.chronicle.engine.map.VanillaKeyValueStore;
import net.openhft.chronicle.engine.map.VanillaMapView;
import net.openhft.chronicle.engine.map.VanillaStringMarshallableKeyValueStore;
import net.openhft.chronicle.engine.map.VanillaStringStringKeyValueStore;
import net.openhft.chronicle.engine.map.VanillaSubscriptionKeyValueStore;
import net.openhft.chronicle.engine.map.remote.RemoteIndexQueueView;
import net.openhft.chronicle.engine.map.remote.RemoteKVSSubscription;
import net.openhft.chronicle.engine.map.remote.RemoteKeyValueStore;
import net.openhft.chronicle.engine.map.remote.RemoteMapView;
import net.openhft.chronicle.engine.map.remote.RemoteTopologySubscription;
import net.openhft.chronicle.engine.pubsub.MapReference;
import net.openhft.chronicle.engine.pubsub.MapTopicPublisher;
import net.openhft.chronicle.engine.pubsub.QueueReference;
import net.openhft.chronicle.engine.pubsub.QueueTopicPublisher;
import net.openhft.chronicle.engine.pubsub.RemotePublisher;
import net.openhft.chronicle.engine.pubsub.RemoteQueueView;
import net.openhft.chronicle.engine.pubsub.RemoteReference;
import net.openhft.chronicle.engine.pubsub.RemoteSimpleSubscription;
import net.openhft.chronicle.engine.pubsub.RemoteTopicPublisher;
import net.openhft.chronicle.engine.pubsub.SimpleSubscription;
import net.openhft.chronicle.engine.query.QueueConfig;
import net.openhft.chronicle.engine.queue.QueueWrappingColumnView;
import net.openhft.chronicle.engine.session.VanillaSessionProvider;
import net.openhft.chronicle.engine.set.RemoteKeySetView;
import net.openhft.chronicle.engine.set.VanillaKeySetView;
import net.openhft.chronicle.engine.tree.AddedAssetEvent;
import net.openhft.chronicle.engine.tree.ChronicleQueueView;
import net.openhft.chronicle.engine.tree.ExistingAssetEvent;
import net.openhft.chronicle.engine.tree.HostIdentifier;
import net.openhft.chronicle.engine.tree.QueueView;
import net.openhft.chronicle.engine.tree.RemovedAssetEvent;
import net.openhft.chronicle.engine.tree.SubAssetFactory;
import net.openhft.chronicle.engine.tree.TopologySubscription;
import net.openhft.chronicle.engine.tree.VanillaReplication;
import net.openhft.chronicle.engine.tree.VanillaSubAssetFactory;
import net.openhft.chronicle.engine.tree.VanillaTopologySubscription;
import net.openhft.chronicle.network.ClientSessionProvider;
import net.openhft.chronicle.network.ConnectionStrategy;
import net.openhft.chronicle.network.VanillaSessionDetails;
import net.openhft.chronicle.network.api.session.SessionDetails;
import net.openhft.chronicle.network.api.session.SessionProvider;
import net.openhft.chronicle.network.connection.ClientConnectionMonitor;
import net.openhft.chronicle.network.connection.SocketAddressSupplier;
import net.openhft.chronicle.network.connection.TcpChannelHub;
import net.openhft.chronicle.threads.EventGroup;
import net.openhft.chronicle.threads.Threads;
import net.openhft.chronicle.wire.AbstractMarshallable;
import net.openhft.chronicle.wire.Marshallable;
import net.openhft.chronicle.wire.TextWire;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireType;
import net.openhft.chronicle.wire.Wires;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VanillaAsset
implements Asset,
Closeable {
    public static final Comparator<Class> CLASS_COMPARATOR = Comparator.comparing(Class::getName);
    public static final String LAST = "{last}";
    private static final Logger LOG = LoggerFactory.getLogger(VanillaAsset.class);
    private static final BiPredicate<RequestContext, Asset> ALWAYS = (rc, asset) -> true;
    final Map<Class, Object> viewMap = new ConcurrentSkipListMap<Class, Object>(CLASS_COMPARATOR);
    final ConcurrentMap<String, Asset> children = new ConcurrentSkipListMap<String, Asset>();
    private final Asset parent;
    @NotNull
    private final String name;
    private final Map<Class, SortedMap<String, WrappingViewRecord>> wrappingViewFactoryMap = new ConcurrentSkipListMap<Class, SortedMap<String, WrappingViewRecord>>(CLASS_COMPARATOR);
    private final Map<Class, LeafView> leafViewMap = new ConcurrentSkipListMap<Class, LeafView>(CLASS_COMPARATOR);
    @Nullable
    private String fullName = null;
    private Boolean keyedAsset;

    public VanillaAsset(Asset asset, @NotNull String name) {
        TopologySubscription parentSubs;
        this.parent = asset;
        this.name = name;
        if ("".equals(name) ? !$assertionsDisabled && this.parent != null : !$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        if (this.parent != null && (parentSubs = this.parent.findView(TopologySubscription.class)) != null && !(parentSubs instanceof RemoteTopologySubscription)) {
            parentSubs.notifyEvent(AddedAssetEvent.of(this.parent.fullName(), name, this.parent.viewTypes()));
        }
    }

    void configMapCommon() {
        this.addWrappingRule((Class)ValuesCollection.class, "{last} values", (WrappingViewFactory)VanillaValuesCollection::new, (Class<U>)MapView.class);
        this.addView(SubAssetFactory.class, new VanillaSubAssetFactory());
    }

    public void configMapServer() {
        this.configMapCommon();
        this.addWrappingRule((Class)EntrySetView.class, "{last} VanillaEntrySetView", (WrappingViewFactory)VanillaEntrySetView::new, (Class<U>)MapView.class);
        this.addWrappingRule((Class)KeySetView.class, "{last} VanillaKeySetView", (WrappingViewFactory)VanillaKeySetView::new, (Class<U>)MapView.class);
        this.addWrappingRule((Class)Reference.class, "{last}reference", (WrappingViewFactory)MapReference::new, (Class<U>)MapView.class);
        this.addWrappingRule((Class)Replication.class, "{last}replication", (WrappingViewFactory)VanillaReplication::new, (Class<U>)MapView.class);
        this.addWrappingRule((Class)Publisher.class, "{last} MapReference", (WrappingViewFactory)MapReference::new, (Class<U>)MapView.class);
        this.addWrappingRule((Class)TopicPublisher.class, "{last} MapTopicPublisher", (WrappingViewFactory)MapTopicPublisher::new, (Class<U>)MapView.class);
        this.addWrappingRule((Class)MapView.class, "{last} VanillaMapView", (WrappingViewFactory)VanillaMapView::new, (Class<U>)ObjectKeyValueStore.class);
        this.addWrappingRule((Class)MapColumnView.class, "{last}Map ColumnView", (WrappingViewFactory)MapWrappingColumnView::new, (Class<U>)MapView.class);
        this.addLeafRule((Class)ObjectSubscription.class, "{last} vanilla", (LeafViewFactory)MapKVSSubscription::new);
        this.addLeafRule((Class)RawKVSSubscription.class, "{last} vanilla", (LeafViewFactory)MapKVSSubscription::new);
        this.addWrappingRule((Class)ObjectKeyValueStore.class, "{last} VanillaSubscriptionKeyValueStore", (WrappingViewFactory)VanillaSubscriptionKeyValueStore::new, (Class<U>)AuthenticatedKeyValueStore.class);
        this.addLeafRule((Class)AuthenticatedKeyValueStore.class, "{last} VanillaKeyValueStore", (LeafViewFactory)VanillaKeyValueStore::new);
        this.addLeafRule((Class)SubscriptionKeyValueStore.class, "{last} VanillaKeyValueStore", (LeafViewFactory)VanillaKeyValueStore::new);
        this.addLeafRule((Class)KeyValueStore.class, "{last} VanillaKeyValueStore", (LeafViewFactory)VanillaKeyValueStore::new);
        this.addLeafRule((Class)VaadinChart.class, "{last} VaadinChart", (LeafViewFactory)VanillaVaadinChart::new);
    }

    public void configMapRemote() {
        this.configMapCommon();
        this.addWrappingRule((Class)SimpleSubscription.class, "{last}subscriber", (WrappingViewFactory)RemoteSimpleSubscription::new, (Class<U>)Reference.class);
        this.addWrappingRule((Class)EntrySetView.class, "{last} RemoteEntrySetView", (WrappingViewFactory)RemoteEntrySetView::new, (Class<U>)MapView.class);
        this.addWrappingRule((Class)KeySetView.class, "{last} RemoteKeySetView", (WrappingViewFactory)RemoteKeySetView::new, (Class<U>)MapView.class);
        this.addLeafRule((Class)Publisher.class, "{last} RemotePublisher", (LeafViewFactory)RemotePublisher::new);
        this.addLeafRule((Class)Reference.class, "{last}reference", (LeafViewFactory)RemoteReference::new);
        this.addLeafRule((Class)TopicPublisher.class, "{last} RemoteTopicPublisher", (LeafViewFactory)RemoteTopicPublisher::new);
        this.addWrappingRule((Class)MapView.class, "{last} RemoteMapView", (WrappingViewFactory)RemoteMapView::new, (Class<U>)ObjectKeyValueStore.class);
        this.addLeafRule((Class)ObjectKeyValueStore.class, "{last} RemoteKeyValueStore", (LeafViewFactory)RemoteKeyValueStore::new);
        this.addLeafRule((Class)ObjectSubscription.class, "{last} Remote", (LeafViewFactory)RemoteKVSSubscription::new);
        this.addLeafRule((Class)VaadinChart.class, "{last} VanillaKeyValueStore", (LeafViewFactory)RemoteVaadinChart::new);
    }

    public void configColumnViewRemote() {
        this.addLeafRule((Class)ColumnView.class, "{last} Remote", (LeafViewFactory)RemoteColumnView::new);
        this.addLeafRule((Class)MapColumnView.class, "{last} Remote", (LeafViewFactory)RemoteColumnView::new);
        this.addLeafRule((Class)QueueColumnView.class, "{last} Remote", (LeafViewFactory)RemoteColumnView::new);
    }

    void configQueueCommon() {
        this.addWrappingRule((Class)Reference.class, "{last}QueueReference", (WrappingViewFactory)QueueReference::new, (Class<U>)QueueView.class);
    }

    public void configQueueServer() {
        this.configQueueCommon();
        this.addWrappingRule((Class)Publisher.class, "{last} QueueReference", (WrappingViewFactory)QueueReference::new, (Class<U>)QueueView.class);
        this.addWrappingRule((Class)TopicPublisher.class, "{last} QueueTopicPublisher", (WrappingViewFactory)QueueTopicPublisher::new, (Class<U>)QueueView.class);
        this.addLeafRule((Class)ObjectSubscription.class, "{last} QueueObjectSubscription", (LeafViewFactory)QueueObjectSubscription::new);
        this.addWrappingRule((Class)IndexQueueView.class, "{last} VanillaIndexQueueView", (WrappingViewFactory)VanillaIndexQueueView::new, (Class<U>)QueueView.class);
        this.addLeafRule((Class)QueueView.class, "{last} ChronicleQueueView", (LeafViewFactory)ChronicleQueueView::create);
        this.addWrappingRule((Class)QueueColumnView.class, "{last}Queue ColumnView", (WrappingViewFactory)QueueWrappingColumnView::new, (Class<U>)QueueView.class);
    }

    public void configQueueRemote() {
        this.configQueueCommon();
        this.addLeafRule((Class)QueueView.class, "{last} RemoteQueueView", (LeafViewFactory)RemoteQueueView::new);
        this.addLeafRule((Class)IndexQueueView.class, "{last} RemoteIndexQueueView", (LeafViewFactory)RemoteIndexQueueView::new);
    }

    public void standardStack(boolean daemon, boolean binding) {
        this.configMapCommon();
        String fullName = this.fullName();
        HostIdentifier hostIdentifier = this.findView(HostIdentifier.class);
        if (hostIdentifier != null) {
            fullName = "tree-" + hostIdentifier.hostId() + fullName;
        }
        ThreadGroup threadGroup = new ThreadGroup(fullName);
        this.addView(ThreadGroup.class, threadGroup);
        this.addLeafRule((Class)EventLoop.class, "{last} event group", (LeafViewFactory)(rc, asset) -> (EventLoop)Threads.withThreadGroup((ThreadGroup)threadGroup, () -> {
            try {
                EventGroup eg = new EventGroup(daemon);
                eg.start();
                return eg;
            }
            catch (Exception e) {
                throw new AssertionError((Object)e);
            }
        }));
        this.addView(SessionProvider.class, new VanillaSessionProvider());
    }

    @Deprecated
    public void forServer() {
        this.forServer(true, s -> VanillaAsset.master(s, 1), false);
    }

    @Nullable
    static Integer master(@NotNull String s, int defaultMaster) {
        String[] split;
        if (s.startsWith("/proc/connections/cluster/throughput") && (split = s.split("/")).length > 5) {
            try {
                return Integer.valueOf(split[4]);
            }
            catch (NumberFormatException e) {
                return defaultMaster;
            }
        }
        return defaultMaster;
    }

    public void forServer(boolean daemon, @NotNull Function<String, Integer> uriToHostId, boolean binding) {
        this.standardStack(daemon, binding);
        this.configMapServer();
        VanillaAsset queue = (VanillaAsset)this.acquireAsset("/queue");
        queue.configQueueServer();
        VanillaAsset clusterConnections = (VanillaAsset)this.acquireAsset("/proc/connections/cluster/throughput");
        clusterConnections.configQueueServer();
        this.addView(QueueConfig.class, new QueueConfig(uriToHostId, true, null, WireType.BINARY));
        this.addView(ObjectCacheFactory.class, VanillaObjectCacheFactory.INSTANCE);
        this.addLeafRule((Class)TopologySubscription.class, "{last} VanillaTopologySubscription", (LeafViewFactory)VanillaTopologySubscription::new);
    }

    public void forRemoteAccess(@NotNull String[] hostPortDescriptions, @NotNull WireType wire, @NotNull VanillaSessionDetails sessionDetails, @Nullable ClientConnectionMonitor clientConnectionMonitor, @NotNull ConnectionStrategy connectionStrategy) throws AssetNotFoundException {
        this.standardStack(true, false);
        this.configMapRemote();
        this.configColumnViewRemote();
        VanillaAsset queue = (VanillaAsset)this.acquireAsset("queue");
        queue.configQueueRemote();
        this.addLeafRule((Class)TopologySubscription.class, "{last} RemoteTopologySubscription", (LeafViewFactory)RemoteTopologySubscription::new);
        ClientSessionProvider sessionProvider = new ClientSessionProvider((SessionDetails)sessionDetails);
        EventLoop eventLoop = this.findOrCreateView(EventLoop.class);
        eventLoop.start();
        if (this.getView(TcpChannelHub.class) == null) {
            SocketAddressSupplier socketAddressSupplier = new SocketAddressSupplier(hostPortDescriptions, this.name);
            TcpChannelHub view = (TcpChannelHub)Threads.withThreadGroup((ThreadGroup)this.findView(ThreadGroup.class), () -> this.lambda$forRemoteAccess$4((SessionProvider)sessionProvider, eventLoop, wire, socketAddressSupplier, clientConnectionMonitor, connectionStrategy));
            this.addView(TcpChannelHub.class, view);
        }
    }

    public void enableTranslatingValuesToBytesStore() {
        this.addWrappingRule((Class)ObjectKeyValueStore.class, "{Marshalling} string,string mapView", (RequestContext rc, Asset asset) -> rc.keyType() == String.class && rc.valueType() == String.class, (WrappingViewFactory)VanillaStringStringKeyValueStore::new, (Class<U>)AuthenticatedKeyValueStore.class);
        this.addWrappingRule((Class)ObjectKeyValueStore.class, "{Marshalling} string,marshallable mapView", (RequestContext rc, Asset asset) -> rc.keyType() == String.class && Marshallable.class.isAssignableFrom(rc.valueType()), (WrappingViewFactory)VanillaStringMarshallableKeyValueStore::new, (Class<U>)AuthenticatedKeyValueStore.class);
        this.addLeafRule((Class)RawKVSSubscription.class, "{last} vanilla", (LeafViewFactory)MapKVSSubscription::new);
    }

    public <W, U> void addWrappingRule(Class<W> viewType, String description, BiPredicate<RequestContext, Asset> predicate, WrappingViewFactory<W, U> factory, Class<U> underlyingType) {
        SortedMap smap = this.wrappingViewFactoryMap.computeIfAbsent(viewType, k -> new ConcurrentSkipListMap());
        smap.put(description, new WrappingViewRecord<W, U>(predicate, factory, underlyingType));
    }

    public <W, U> void addWrappingRule(Class<W> viewType, String description, WrappingViewFactory<W, U> factory, Class<U> underlyingType) {
        this.addWrappingRule(viewType, description, ALWAYS, factory, underlyingType);
        this.leafViewMap.remove(viewType);
    }

    public <L> void addLeafRule(Class<L> viewType, String description, LeafViewFactory<L> factory) {
        this.leafViewMap.put(viewType, new LeafView(description, factory));
    }

    @Nullable
    public <I, U> I createWrappingView(Class viewType, RequestContext rc, @NotNull Asset asset, @Nullable U underling) throws AssetNotFoundException {
        SortedMap<String, WrappingViewRecord> smap = this.wrappingViewFactoryMap.get(viewType);
        if (smap != null) {
            for (WrappingViewRecord wvRecord : smap.values()) {
                if (!wvRecord.predicate.test(rc, asset)) continue;
                if (underling == null) {
                    underling = asset.acquireView(wvRecord.underlyingType, rc);
                }
                return (I)wvRecord.factory.create(rc, asset, underling);
            }
        }
        if (this.parent == null) {
            return null;
        }
        return ((VanillaAsset)this.parent).createWrappingView(viewType, rc, asset, underling);
    }

    @Nullable
    public <I> I createLeafView(Class viewType, @NotNull RequestContext rc, Asset asset) throws AssetNotFoundException {
        LeafView lv = this.leafViewMap.get(viewType);
        if (lv != null) {
            return lv.factory.create(rc.clone().viewType(viewType), asset);
        }
        if (this.parent == null) {
            return null;
        }
        return ((VanillaAsset)this.parent).createLeafView(viewType, rc, asset);
    }

    @Override
    public boolean isSubAsset() {
        return false;
    }

    @Override
    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    @Override
    public <T extends Throwable> void forEachChild(@NotNull ThrowingConsumer<Asset, T> consumer) throws T {
        for (Asset child : this.children.values()) {
            consumer.accept((Object)child);
        }
    }

    @Override
    @ForceInline
    @Nullable
    public <V> V getView(@NotNull Class<V> viewType) {
        Object view = this.viewMap.get(viewType);
        return (V)view;
    }

    @Override
    @ForceInline
    @NotNull
    public String name() {
        return this.name;
    }

    @Override
    @NotNull
    public String fullName() {
        if (this.fullName == null) {
            this.fullName = Asset.super.fullName();
        }
        return this.fullName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public <V> V acquireView(@NotNull Class<V> viewType, @NotNull RequestContext rc) throws AssetNotFoundException {
        if (!this.fullName().equals(rc.fullName())) {
            Asset asset = this.root().acquireAsset(rc.fullName());
            return asset.acquireView(rc);
        }
        Map<Class, Object> map = this.viewMap;
        synchronized (map) {
            V view = this.getView(viewType);
            if (view != null) {
                return view;
            }
            return (V)Threads.withThreadGroup((ThreadGroup)this.findView(ThreadGroup.class), () -> {
                Object leafView = this.createLeafView(viewType, rc, this);
                if (leafView instanceof MapView && viewType == QueueView.class) {
                    this.addView(MapView.class, (MapView)leafView);
                }
                if (leafView != null) {
                    return this.addView(viewType, leafView);
                }
                Object wrappingView = this.createWrappingView(viewType, rc, this, null);
                if (wrappingView == null) {
                    throw new AssetNotFoundException("Unable to classify " + viewType.getName() + " context: " + rc);
                }
                return this.addView(viewType, wrappingView);
            });
        }
    }

    @Override
    public String dumpRules() {
        TextWire text = new TextWire(Wires.acquireBytes());
        if (this.parent != null) {
            ((VanillaAsset)this.parent).dumpRules((Wire)text);
        }
        this.dumpRules((Wire)text);
        this.dumpChildRules((Wire)text);
        return text.toString();
    }

    private void dumpChildRules(@NotNull Wire text) {
        for (Asset asset : this.children.values()) {
            if (!(asset instanceof VanillaAsset)) continue;
            VanillaAsset vasset = (VanillaAsset)asset;
            if (vasset.leafViewMap.size() + vasset.wrappingViewFactoryMap.size() > 0) {
                vasset.dumpRules(text);
            }
            vasset.dumpChildRules(text);
        }
    }

    private void dumpRules(@NotNull Wire wire) {
        wire.bytes().append8bit("---\n");
        wire.write((CharSequence)"name").text(this.fullName()).write((CharSequence)"leaf").marshallable(w -> {
            for (Map.Entry<Class, LeafView> entry : this.leafViewMap.entrySet()) {
                w.writeEvent(Class.class, (Object)entry.getKey()).leaf(false).text(entry.getValue().name);
            }
        }).write((CharSequence)"wrapping").marshallable(w -> {
            for (Map.Entry<Class, SortedMap<String, WrappingViewRecord>> entry : this.wrappingViewFactoryMap.entrySet()) {
                w.writeEvent(Class.class, (Object)entry.getKey()).marshallable(ww -> {
                    for (Map.Entry recordEntry : ((SortedMap)entry.getValue()).entrySet()) {
                        ww.writeEventName((CharSequence)recordEntry.getKey()).object(Class.class, ((WrappingViewRecord)recordEntry.getValue()).underlyingType);
                    }
                });
            }
        });
    }

    private <V> V addView0(Class<V> viewType, V view) {
        if (view instanceof KeyedView) {
            this.keyedAsset = ((KeyedView)view).keyedView();
        }
        Object o = this.viewMap.putIfAbsent(viewType, view);
        TopologySubscription topologySubscription = this.root().findView(TopologySubscription.class);
        if (topologySubscription != null) {
            String parentName;
            String string = parentName = this.parent == null ? "" : this.parent.fullName();
            if (o == null) {
                topologySubscription.notifyEvent(AddedAssetEvent.of(parentName, this.name, this.viewTypes()));
            } else {
                topologySubscription.notifyEvent(ExistingAssetEvent.of(parentName, this.name, this.viewTypes()));
            }
        }
        return view;
    }

    @Override
    public <V> V addView(Class<V> viewType, V view) {
        if (viewType != ColumnView.class && view instanceof ColumnView) {
            this.addView0(ColumnView.class, (ColumnView)view);
        }
        if (viewType != QueueView.class && view instanceof QueueView) {
            this.addView0(QueueView.class, (QueueView)view);
        }
        return this.addView0(viewType, view);
    }

    public <I> void registerView(Class<I> viewType, I view) {
        this.viewMap.put(viewType, view);
    }

    @Override
    @Nullable
    public SubscriptionCollection subscription(boolean createIfAbsent) throws AssetNotFoundException {
        return createIfAbsent ? (SubscriptionCollection)this.acquireView(ObjectSubscription.class) : (SubscriptionCollection)this.getView(ObjectSubscription.class);
    }

    public void close() {
        this.viewMap.values().stream().filter(v -> v instanceof java.io.Closeable).forEach(Closeable::closeQuietly);
        this.forEachChild(Closeable::close);
    }

    public void notifyClosing() {
        this.viewMap.values().stream().filter(v -> v instanceof Closeable).map(v -> (Closeable)v).forEach(Closeable::notifyClosing);
        this.forEachChild(Closeable::notifyClosing);
    }

    @Override
    @ForceInline
    public Asset parent() {
        return this.parent;
    }

    @Override
    @NotNull
    public Asset acquireAsset(@NotNull String childName) {
        if ("/".contentEquals(childName)) {
            return this.root();
        }
        if (this.keyedAsset != Boolean.TRUE) {
            int pos = childName.indexOf(47);
            if (pos == 0) {
                childName = childName.substring(1);
                pos = childName.indexOf(47);
            }
            if (pos > 0) {
                String name1 = childName.substring(0, pos);
                String name2 = childName.substring(pos + 1);
                return this.getAssetOrANFE(name1).acquireAsset(name2);
            }
        }
        return this.getAssetOrANFE(childName);
    }

    @Override
    public <V> boolean hasFactoryFor(Class<V> viewType) {
        return this.leafViewMap.containsKey(viewType) || this.wrappingViewFactoryMap.containsKey(viewType);
    }

    @Nullable
    private Asset getAssetOrANFE(@NotNull String name) throws AssetNotFoundException {
        Asset asset = (Asset)this.children.get(name);
        if (asset == null && (asset = this.createAsset(name)) == null) {
            throw new AssetNotFoundException(name);
        }
        return asset;
    }

    @Nullable
    protected Asset createAsset(@NotNull String name) {
        if (name.length() == 0) {
            System.out.println("");
        }
        assert (name.length() > 0);
        return this.children.computeIfAbsent(name, this.keyedAsset != Boolean.TRUE ? n -> new VanillaAsset(this, name) : n -> {
            MapView map = this.getView(MapView.class);
            if (map != null) {
                SubAssetFactory saFactory = this.findOrCreateView(SubAssetFactory.class);
                return saFactory.createSubAsset(this, name, map.valueType());
            }
            SubAssetFactory saFactory = this.findOrCreateView(SubAssetFactory.class);
            return saFactory.createSubAsset(this, name, String.class);
        });
    }

    @Override
    public Asset getChild(String name) {
        return (Asset)this.children.get(name);
    }

    @Override
    public void removeChild(String name) {
        Asset removed = (Asset)this.children.remove(name);
        if (removed == null) {
            return;
        }
        TopologySubscription topologySubscription = removed.findView(TopologySubscription.class);
        if (topologySubscription != null) {
            topologySubscription.notifyEvent(RemovedAssetEvent.of(this.fullName(), name, this.viewTypes()));
        }
    }

    @NotNull
    public String toString() {
        return this.fullName();
    }

    @Override
    public void getUsageStats(@NotNull AssetTreeStats ats) {
        ats.addAsset(1L, 512L);
        for (Object o : this.viewMap.values()) {
            KeyValueStore kvs;
            if (!(o instanceof KeyValueStore) || (kvs = (KeyValueStore)o).underlying() != null) continue;
            long count = kvs.longSize();
            ats.addAsset(count, count * 1024L);
            break;
        }
        this.forEachChild(ca -> ca.getUsageStats(ats));
    }

    @Override
    @NotNull
    public Set<Class> viewTypes() {
        return this.viewMap.keySet();
    }

    private /* synthetic */ TcpChannelHub lambda$forRemoteAccess$4(@NotNull SessionProvider sessionProvider, @Nullable EventLoop eventLoop, @NotNull WireType wire, @NotNull SocketAddressSupplier socketAddressSupplier, @Nullable ClientConnectionMonitor clientConnectionMonitor, @NotNull ConnectionStrategy connectionStrategy) throws RuntimeException {
        return new TcpChannelHub(sessionProvider, eventLoop, wire, this.name.isEmpty() ? "/" : this.name, socketAddressSupplier, true, clientConnectionMonitor, HandlerPriority.TIMER, connectionStrategy);
    }

    static class WrappingViewRecord<W, U> {
        final BiPredicate<RequestContext, Asset> predicate;
        final WrappingViewFactory<W, U> factory;
        final Class<U> underlyingType;

        WrappingViewRecord(BiPredicate<RequestContext, Asset> predicate, WrappingViewFactory<W, U> factory, Class<U> underlyingType) {
            this.predicate = predicate;
            this.factory = factory;
            this.underlyingType = underlyingType;
        }

        @NotNull
        public String toString() {
            return "wraps " + this.underlyingType;
        }
    }

    static class LeafView
    extends AbstractMarshallable {
        String name;
        transient LeafViewFactory factory;

        public LeafView(String name, LeafViewFactory factory) {
            this.name = name;
            this.factory = factory;
        }

        public String name() {
            return this.name;
        }
    }
}

