/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine.tree;

import java.util.Optional;
import java.util.function.Consumer;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.pool.ClassAliasPool;
import net.openhft.chronicle.core.threads.EventLoop;
import net.openhft.chronicle.engine.api.column.ColumnViewInternal;
import net.openhft.chronicle.engine.api.column.ColumnViewIterator;
import net.openhft.chronicle.engine.api.tree.Asset;
import net.openhft.chronicle.engine.api.tree.AssetTree;
import net.openhft.chronicle.engine.api.tree.AssetTreeStats;
import net.openhft.chronicle.engine.fs.ConfigurationFS;
import net.openhft.chronicle.engine.map.InsertedEvent;
import net.openhft.chronicle.engine.map.RemovedEvent;
import net.openhft.chronicle.engine.map.UpdatedEvent;
import net.openhft.chronicle.engine.map.remote.KeyFunctionPair;
import net.openhft.chronicle.engine.map.remote.KeyValueFunctionTuple;
import net.openhft.chronicle.engine.map.remote.KeyValuePair;
import net.openhft.chronicle.engine.map.remote.KeyValuesTuple;
import net.openhft.chronicle.engine.map.remote.MapFunction;
import net.openhft.chronicle.engine.map.remote.MapUpdate;
import net.openhft.chronicle.engine.tree.AddedAssetEvent;
import net.openhft.chronicle.engine.tree.ExistingAssetEvent;
import net.openhft.chronicle.engine.tree.HostIdentifier;
import net.openhft.chronicle.engine.tree.RemovedAssetEvent;
import net.openhft.chronicle.engine.tree.VanillaAsset;
import net.openhft.chronicle.network.ConnectionStrategy;
import net.openhft.chronicle.network.VanillaSessionDetails;
import net.openhft.chronicle.network.connection.ClientConnectionMonitor;
import net.openhft.chronicle.network.connection.FatalFailureConnectionStrategy;
import net.openhft.chronicle.threads.Threads;
import net.openhft.chronicle.wire.WireType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VanillaAssetTree
implements AssetTree {
    @NotNull
    final VanillaAsset root;

    public VanillaAssetTree() {
        this("");
    }

    public VanillaAssetTree(@Nullable String name) {
        this.root = new VanillaAsset(null, name == null ? "" : name);
    }

    public VanillaAssetTree(int hostId) {
        this();
        this.root.addView(HostIdentifier.class, new HostIdentifier((byte)hostId));
    }

    @Override
    @NotNull
    public AssetTreeStats getUsageStats() {
        AssetTreeStats ats = new AssetTreeStats();
        this.root.getUsageStats(ats);
        return ats;
    }

    @NotNull
    public VanillaAssetTree forTesting() {
        return this.forTesting(true);
    }

    @NotNull
    public VanillaAssetTree forTesting(boolean daemon) {
        return this.forServer(daemon);
    }

    @NotNull
    public VanillaAssetTree forTesting(boolean daemon, boolean binding) {
        return this.forServer(daemon, binding);
    }

    @NotNull
    public VanillaAssetTree forServer() {
        return this.forServer(true);
    }

    @NotNull
    public VanillaAssetTree forServer(boolean daemon, boolean binding) {
        HostIdentifier view = this.root.getView(HostIdentifier.class);
        byte hostId = view == null ? (byte)1 : view.hostId();
        this.root.forServer(daemon, uri -> VanillaAsset.master(uri, hostId), binding);
        return this;
    }

    @NotNull
    public VanillaAssetTree forServer(boolean daemon) {
        return this.forServer(daemon, false);
    }

    @NotNull
    public VanillaAssetTree forRemoteAccess(String hostPortDescription, @NotNull WireType wire) {
        return this.forRemoteAccess(new String[]{hostPortDescription}, wire);
    }

    @NotNull
    public VanillaAssetTree forRemoteAccess(@NotNull String[] hostPortDescription, @NotNull WireType wire) {
        this.root.forRemoteAccess(hostPortDescription, wire, this.clientSession(), null, (ConnectionStrategy)new FatalFailureConnectionStrategy(3));
        return this;
    }

    @NotNull
    public VanillaAssetTree forRemoteAccess(@NotNull String[] hostPortDescription, @NotNull WireType wire, @Nullable ClientConnectionMonitor clientConnectionMonitor) {
        if (clientConnectionMonitor != null) {
            this.root.viewMap.put(ClientConnectionMonitor.class, clientConnectionMonitor);
        }
        this.root.forRemoteAccess(hostPortDescription, wire, this.clientSession(), clientConnectionMonitor, (ConnectionStrategy)new FatalFailureConnectionStrategy(3));
        return this;
    }

    @NotNull
    public VanillaAssetTree forRemoteAccess(String hostPortDescription) {
        return this.forRemoteAccess(hostPortDescription, WireType.BINARY);
    }

    @NotNull
    private VanillaSessionDetails clientSession() {
        VanillaSessionDetails sessionDetails = new VanillaSessionDetails();
        sessionDetails.userId(System.getProperty("user.name"));
        return sessionDetails;
    }

    @Override
    @NotNull
    public Asset acquireAsset(@NotNull String fullName) {
        if (fullName.startsWith("/")) {
            fullName = fullName.substring(1);
        }
        return fullName.isEmpty() ? this.root : this.root.acquireAsset(fullName);
    }

    @Override
    @Nullable
    public Asset getAsset(@NotNull String fullName) {
        if (fullName.startsWith("/")) {
            fullName = fullName.substring(1);
        }
        return fullName.isEmpty() ? this.root : this.root.getAsset(fullName);
    }

    @Override
    @NotNull
    public VanillaAsset root() {
        return this.root;
    }

    public void close() {
        this.root.notifyClosing();
        Jvm.pause((long)50L);
        EventLoop view = this.root().findView(EventLoop.class);
        Closeable.closeQuietly((Object)view);
        this.root.close();
    }

    @Deprecated
    @NotNull
    public AssetTree withConfig(String etcDir, String baseDir) {
        Threads.withThreadGroup((ThreadGroup)this.root.getView(ThreadGroup.class), () -> {
            new ConfigurationFS("/etc", etcDir, baseDir).install(baseDir, this);
            return null;
        });
        return this;
    }

    @NotNull
    public String toString() {
        return "tree-" + Optional.ofNullable(this.root.getView(HostIdentifier.class)).map(HostIdentifier::hostId).orElseGet(() -> (byte)0);
    }

    @NotNull
    public VanillaAssetTree forRemoteAccess(String serverAddress, @NotNull WireType wireType, Consumer<Throwable> t) {
        return this.forRemoteAccess(serverAddress, wireType);
    }

    static {
        ClassAliasPool.CLASS_ALIASES.addAlias(new Class[]{AddedAssetEvent.class, ExistingAssetEvent.class, RemovedAssetEvent.class, InsertedEvent.class, UpdatedEvent.class, MapFunction.class, MapUpdate.class, RemovedEvent.class, KeyFunctionPair.class, KeyValueFunctionTuple.class, KeyValuesTuple.class, KeyValuePair.class, ColumnViewInternal.SortedFilter.class, ColumnViewIterator.class});
    }
}

