/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash;

import net.openhft.chronicle.bytes.Byteable;
import net.openhft.chronicle.bytes.BytesIn;
import net.openhft.chronicle.bytes.BytesMarshallable;
import net.openhft.chronicle.bytes.BytesOut;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.hash.VanillaGlobalMutableState;
import net.openhft.chronicle.values.Copyable;

@Deprecated
public class VanillaGlobalMutableState$$Native
implements VanillaGlobalMutableState,
Copyable<VanillaGlobalMutableState>,
BytesMarshallable,
Byteable {
    private BytesStore bs;
    private long offset;

    @Override
    public int getAllocatedExtraTierBulks() {
        return this.bs.readInt(this.offset + 0L) & 0xFFFFFF;
    }

    @Override
    public void setAllocatedExtraTierBulks(int _allocatedExtraTierBulks) {
        if (_allocatedExtraTierBulks < 0 || _allocatedExtraTierBulks > 0xFFFFFF) {
            throw new IllegalArgumentException("_allocatedExtraTierBulks should be in [0, 16777215] range, " + _allocatedExtraTierBulks + " is given");
        }
        this.bs.writeInt(this.offset + 0L, this.bs.readInt(this.offset + 0L) & 0xFF000000 | _allocatedExtraTierBulks);
    }

    @Override
    public long getFirstFreeTierIndex() {
        return this.bs.readLong(this.offset + 3L) & 0xFFFFFFFFFFL;
    }

    @Override
    public void setFirstFreeTierIndex(long _firstFreeTierIndex) {
        if (_firstFreeTierIndex < 0L || _firstFreeTierIndex > 0xFFFFFFFFFFL) {
            throw new IllegalArgumentException("_firstFreeTierIndex should be in [0, 1099511627775] range, " + _firstFreeTierIndex + " is given");
        }
        this.bs.writeLong(this.offset + 3L, this.bs.readLong(this.offset + 3L) & 0xFFFFFF0000000000L | _firstFreeTierIndex);
    }

    @Override
    public long getExtraTiersInUse() {
        return this.bs.readLong(this.offset + 8L) & 0xFFFFFFFFFFL;
    }

    @Override
    public void setExtraTiersInUse(long _extraTiersInUse) {
        if (_extraTiersInUse < 0L || _extraTiersInUse > 0xFFFFFFFFFFL) {
            throw new IllegalArgumentException("_extraTiersInUse should be in [0, 1099511627775] range, " + _extraTiersInUse + " is given");
        }
        this.bs.writeLong(this.offset + 8L, this.bs.readLong(this.offset + 8L) & 0xFFFFFF0000000000L | _extraTiersInUse);
    }

    @Override
    public long getSegmentHeadersOffset() {
        return (long)this.bs.readInt(this.offset + 13L) & 0xFFFFFFFFL;
    }

    @Override
    public void setSegmentHeadersOffset(long _segmentHeadersOffset) {
        if (_segmentHeadersOffset < 0L || _segmentHeadersOffset > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("_segmentHeadersOffset should be in [0, 4294967295] range, " + _segmentHeadersOffset + " is given");
        }
        this.bs.writeInt(this.offset + 13L, (int)_segmentHeadersOffset);
    }

    @Override
    public long getDataStoreSize() {
        return this.bs.readLong(this.offset + 17L);
    }

    @Override
    public void setDataStoreSize(long _dataStoreSize) {
        if (_dataStoreSize < 0L) {
            throw new IllegalArgumentException("_dataStoreSize should be in [0, 9223372036854775807] range, " + _dataStoreSize + " is given");
        }
        this.bs.writeLong(this.offset + 17L, _dataStoreSize);
    }

    @Override
    public long addDataStoreSize(long addition) {
        long oldDataStoreSize = this.bs.readLong(this.offset + 17L);
        long newDataStoreSize = oldDataStoreSize + addition;
        if (newDataStoreSize < 0L) {
            throw new IllegalStateException("bs.readLong(offset + 17) should be in [0, 9223372036854775807] range, the value was " + oldDataStoreSize + ", + " + addition + " = " + newDataStoreSize + " out of the range");
        }
        this.bs.writeLong(this.offset + 17L, newDataStoreSize);
        return newDataStoreSize;
    }

    public void copyFrom(VanillaGlobalMutableState from) {
        this.setAllocatedExtraTierBulks(from.getAllocatedExtraTierBulks());
        this.setFirstFreeTierIndex(from.getFirstFreeTierIndex());
        this.setExtraTiersInUse(from.getExtraTiersInUse());
        this.setSegmentHeadersOffset(from.getSegmentHeadersOffset());
        this.setDataStoreSize(from.getDataStoreSize());
    }

    public void writeMarshallable(BytesOut bytes) {
        bytes.writeInt(this.bs.readInt(this.offset + 0L) & 0xFFFFFF);
        bytes.writeLong(this.bs.readLong(this.offset + 3L) & 0xFFFFFFFFFFL);
        bytes.writeLong(this.bs.readLong(this.offset + 8L) & 0xFFFFFFFFFFL);
        bytes.writeLong((long)this.bs.readInt(this.offset + 13L) & 0xFFFFFFFFL);
        bytes.writeLong(this.bs.readLong(this.offset + 17L));
    }

    public void readMarshallable(BytesIn bytes) {
        this.bs.writeInt(this.offset + 0L, this.bs.readInt(this.offset + 0L) & 0xFF000000 | bytes.readInt());
        this.bs.writeLong(this.offset + 3L, this.bs.readLong(this.offset + 3L) & 0xFFFFFF0000000000L | bytes.readLong());
        this.bs.writeLong(this.offset + 8L, this.bs.readLong(this.offset + 8L) & 0xFFFFFF0000000000L | bytes.readLong());
        this.bs.writeInt(this.offset + 13L, (int)bytes.readLong());
        this.bs.writeLong(this.offset + 17L, bytes.readLong());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof VanillaGlobalMutableState)) {
            return false;
        }
        VanillaGlobalMutableState other = (VanillaGlobalMutableState)obj;
        if (this.getAllocatedExtraTierBulks() != other.getAllocatedExtraTierBulks()) {
            return false;
        }
        if (this.getFirstFreeTierIndex() != other.getFirstFreeTierIndex()) {
            return false;
        }
        if (this.getExtraTiersInUse() != other.getExtraTiersInUse()) {
            return false;
        }
        if (this.getSegmentHeadersOffset() != other.getSegmentHeadersOffset()) {
            return false;
        }
        return this.getDataStoreSize() == other.getDataStoreSize();
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode *= 1000003;
        hashCode ^= Integer.hashCode(this.getAllocatedExtraTierBulks());
        hashCode *= 1000003;
        hashCode ^= Long.hashCode(this.getFirstFreeTierIndex());
        hashCode *= 1000003;
        hashCode ^= Long.hashCode(this.getExtraTiersInUse());
        hashCode *= 1000003;
        hashCode ^= Long.hashCode(this.getSegmentHeadersOffset());
        hashCode *= 1000003;
        return hashCode ^= Long.hashCode(this.getDataStoreSize());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("VanillaGlobalMutableState");
        sb.append(", allocatedExtraTierBulks=").append(this.getAllocatedExtraTierBulks());
        sb.append(", firstFreeTierIndex=").append(this.getFirstFreeTierIndex());
        sb.append(", extraTiersInUse=").append(this.getExtraTiersInUse());
        sb.append(", segmentHeadersOffset=").append(this.getSegmentHeadersOffset());
        sb.append(", dataStoreSize=").append(this.getDataStoreSize());
        sb.setCharAt(25, '{');
        sb.append(' ').append('}');
        return sb.toString();
    }

    public void bytesStore(BytesStore bytesStore, long offset, long length) {
        if (length != this.maxSize()) {
            throw new IllegalArgumentException("Constant size is 25, given length is " + length);
        }
        this.bs = bytesStore;
        this.offset = offset;
    }

    public BytesStore bytesStore() {
        return this.bs;
    }

    public long offset() {
        return this.offset;
    }

    public long maxSize() {
        return 25L;
    }
}

