/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.impl;

import java.io.File;
import java.io.IOException;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.hash.impl.ChronicleHashResources;
import net.openhft.chronicle.hash.impl.MemoryResource;
import net.openhft.chronicle.hash.impl.util.CanonicalRandomAccessFiles;

public final class PersistedChronicleHashResources
extends ChronicleHashResources {
    private File file;

    public PersistedChronicleHashResources(File file) {
        this.file = file;
        OS.memory().storeFence();
    }

    @Override
    void releaseMemoryResource(MemoryResource mapping) throws IOException {
        OS.unmap((long)mapping.address, (long)mapping.size);
    }

    @Override
    Throwable releaseExtraSystemResources() {
        if (this.file == null) {
            return null;
        }
        Throwable thrown = null;
        try {
            CanonicalRandomAccessFiles.release(this.file);
            this.file = null;
        }
        catch (Throwable t) {
            thrown = t;
        }
        return thrown;
    }
}

