/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.serialization.impl;

import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.hash.serialization.SizedReader;
import net.openhft.chronicle.hash.serialization.SizedWriter;
import net.openhft.chronicle.hash.serialization.impl.InstanceCreatingMarshaller;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireType;
import net.openhft.chronicle.wire.Wires;
import org.jetbrains.annotations.NotNull;

public abstract class CachingCreatingMarshaller<V>
extends InstanceCreatingMarshaller<V>
implements SizedReader<V>,
SizedWriter<V> {
    static final ThreadLocal<Wire> WIRE_TL = ThreadLocal.withInitial(() -> (Wire)WireType.BINARY_LIGHT.apply((Object)Bytes.allocateElasticOnHeap((int)128)));
    static final ThreadLocal<Object> LAST_TL = new ThreadLocal();

    public CachingCreatingMarshaller(Class<V> vClass) {
        super(vClass);
    }

    @Override
    public long size(@NotNull V toWrite) {
        Wire wire = WIRE_TL.get();
        wire.bytes().clear();
        this.writeToWire(wire, toWrite);
        LAST_TL.set(toWrite);
        return wire.bytes().readRemaining();
    }

    protected abstract void writeToWire(Wire var1, @NotNull V var2);

    @Override
    public void write(Bytes<?> out, long size, @NotNull V toWrite) {
        Wire wire;
        if (LAST_TL.get() == toWrite && (wire = WIRE_TL.get()).bytes().readRemaining() == size) {
            out.write((BytesStore)wire.bytes());
            wire.bytes().clear();
            LAST_TL.remove();
            return;
        }
        wire = Wires.binaryWireForWrite(out, (long)out.writePosition(), (long)size);
        this.writeToWire(wire, toWrite);
    }
}

