/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.MappedBytes;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.queue.impl.single.RollCycleRetriever;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueStore;
import net.openhft.chronicle.threads.Pauser;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireType;
import net.openhft.chronicle.wire.Wires;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

enum QueueFiles {

    private static final Logger LOGGER = LoggerFactory.getLogger(RollCycleRetriever.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    static <T> Optional<T> processQueueFile(Path filePath, WireType wireType, long blockSize, boolean readOnly, BiFunction<Wire, SingleChronicleQueueStore, T> processor) {
        MappedBytes mappedBytes = QueueFiles.mappedBytes(filePath, blockSize, readOnly);
        mappedBytes.reserve();
        try {
            Optional<T> optional;
            Object object;
            SingleChronicleQueueStore queueStore;
            block32: {
                block33: {
                    Wire wire;
                    block29: {
                        Optional optional2;
                        block30: {
                            block31: {
                                wire = (Wire)wireType.apply((Object)mappedBytes);
                                Bytes bytes = wire.bytes();
                                bytes.readLimit(bytes.capacity());
                                if (bytes.readLimit() < 4L) {
                                    Optional optional3 = Optional.empty();
                                    return optional3;
                                }
                                File file = mappedBytes.mappedFile().file();
                                for (int i = 0; i < 500 && file.length() == 0L; ++i) {
                                    LockSupport.parkNanos(TimeUnit.MILLISECONDS.toNanos(1L));
                                }
                                if (file.length() < 4L) {
                                    LOGGER.warn("Queue file exists, but is truncated, cannot determine existing roll cycle");
                                    Optional i = Optional.empty();
                                    return i;
                                }
                                int firstInt = bytes.peekVolatileInt();
                                if (!Wires.isReady((int)firstInt)) {
                                    Optional optional4 = Optional.empty();
                                    return optional4;
                                }
                                bytes.readSkip(4L);
                                queueStore = SingleChronicleQueueBuilder.loadStore(wire);
                                object = null;
                                if (queueStore != null) break block29;
                                optional2 = Optional.empty();
                                if (queueStore == null) break block30;
                                if (object == null) break block31;
                                try {
                                    queueStore.close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)object).addSuppressed(throwable);
                                }
                                break block30;
                            }
                            queueStore.close();
                        }
                        return optional2;
                    }
                    optional = Optional.ofNullable(processor.apply(wire, queueStore));
                    if (queueStore == null) break block32;
                    if (object == null) break block33;
                    try {
                        queueStore.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                    break block32;
                }
                queueStore.close();
            }
            return optional;
            {
                catch (Throwable throwable) {
                    try {
                        try {
                            object = throwable;
                            throw throwable;
                        }
                        catch (Throwable throwable2) {
                            if (queueStore != null) {
                                if (object != null) {
                                    try {
                                        queueStore.close();
                                    }
                                    catch (Throwable throwable3) {
                                        ((Throwable)object).addSuppressed(throwable3);
                                    }
                                } else {
                                    queueStore.close();
                                }
                            }
                            throw throwable2;
                        }
                    }
                    catch (Throwable e) {
                        LOGGER.warn("Unable to load queue store from file {}", (Object)filePath, (Object)e);
                        object = Optional.empty();
                        return object;
                    }
                }
            }
        }
        finally {
            mappedBytes.release();
        }
    }

    static <T> Optional<T> processLastQueueFile(Path queuePath, WireType wireType, long blockSize, boolean readOnly, BiFunction<Wire, SingleChronicleQueueStore, T> processor) {
        if (Files.exists(queuePath, new LinkOption[0]) && QueueFiles.hasQueueFiles(queuePath)) {
            return QueueFiles.processQueueFile(QueueFiles.getLastQueueFile(queuePath), wireType, blockSize, readOnly, processor);
        }
        return Optional.empty();
    }

    static void writeEOFIfNeeded(@NotNull Path newFilePath, @NotNull WireType wireType, long blockSize, long timeoutMS, Pauser pauser) {
        Path queuePath = newFilePath.getParent();
        if (Files.exists(queuePath, new LinkOption[0]) && QueueFiles.hasQueueFiles(queuePath)) {
            QueueFiles.getLastQueueFileButNotTheNew(queuePath, newFilePath).ifPresent(f -> QueueFiles.processQueueFile(f, wireType, blockSize, false, (w, qs) -> {
                int existingValue;
                int recordHeader;
                Bytes bytes = w.bytes();
                long writePosition = qs.writePosition();
                if (writePosition == 0L) {
                    long timeoutAt = System.currentTimeMillis() + timeoutMS;
                    while (qs.writePosition() == 0L && System.currentTimeMillis() < timeoutAt) {
                        pauser.pause();
                    }
                    pauser.reset();
                    if (qs.writePosition() == 0L) {
                        Jvm.warn().on(QueueFiles.class, "Timed out waiting for first message in " + f + ". Recovering EOF marker.");
                        try {
                            boolean foundData = w.readDataHeader();
                            if (!foundData) {
                                long eofPosition = bytes.readPosition();
                                bytes.writePosition(eofPosition);
                                w.writeEndOfWire(timeoutMS, TimeUnit.MILLISECONDS, eofPosition);
                            }
                        }
                        catch (EOFException eOFException) {
                            // empty catch block
                        }
                        return null;
                    }
                }
                if (Wires.isNotComplete((int)(recordHeader = bytes.readVolatileInt(writePosition)))) {
                    return null;
                }
                long recordLength = Wires.lengthOf((int)recordHeader);
                long eofOffset = writePosition + recordLength + 4L;
                long nextHeaderPosition = writePosition + 4L + recordLength;
                int possiblyIncompleteHeader = bytes.readVolatileInt(nextHeaderPosition);
                if (possiblyIncompleteHeader != 0 && Wires.isNotComplete((int)possiblyIncompleteHeader) && !Wires.isEndOfFile((int)possiblyIncompleteHeader)) {
                    long timeoutAt = System.currentTimeMillis() + timeoutMS;
                    while (Wires.isNotComplete((int)bytes.readVolatileInt(nextHeaderPosition)) && System.currentTimeMillis() < timeoutAt) {
                        pauser.pause();
                    }
                    if (Wires.isNotComplete((int)bytes.readVolatileInt(nextHeaderPosition))) {
                        Jvm.warn().on(QueueFiles.class, "Timed out waiting for incomplete message at " + nextHeaderPosition + " in " + f + ". Not writing EOF marker.");
                    } else {
                        eofOffset += (long)(Wires.lengthOf((int)bytes.readVolatileInt(nextHeaderPosition)) + 4);
                    }
                }
                if (0 == (existingValue = bytes.readVolatileInt(eofOffset))) {
                    bytes.writePosition(eofOffset);
                    w.writeEndOfWire(timeoutMS, TimeUnit.MILLISECONDS, eofOffset);
                }
                return null;
            }));
        }
        pauser.reset();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Optional<Path> getLastQueueFileButNotTheNew(Path queuePath, Path newFilePath) {
        try (Stream<Path> children = Files.list(queuePath);){
            Optional<Path> optional = children.filter(p -> p.toString().endsWith(".cq4") && !p.equals(newFilePath)).sorted(Comparator.reverseOrder()).findFirst();
            return optional;
        }
        catch (IOException e) {
            throw new UncheckedIOException(String.format("Failed to list contents of known directory %s", queuePath), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Path getLastQueueFile(Path queuePath) {
        try (Stream<Path> children = Files.list(queuePath);){
            Path path = children.filter(p -> p.toString().endsWith(".cq4")).sorted(Comparator.reverseOrder()).findFirst().orElseThrow(() -> new UncheckedIOException(new IOException(String.format("Expected at least one %s file in directory %s", ".cq4", queuePath))));
            return path;
        }
        catch (IOException e) {
            throw new UncheckedIOException(String.format("Failed to list contents of known directory %s", queuePath), e);
        }
    }

    private static MappedBytes mappedBytes(@NotNull Path queueFile, long blockSize, boolean readOnly) {
        long chunkSize = OS.pageAlign((long)blockSize);
        long overlapSize = OS.pageAlign((long)(blockSize / 4L));
        try {
            return MappedBytes.mappedBytes((File)queueFile.toFile(), (long)chunkSize, (long)overlapSize, (boolean)readOnly);
        }
        catch (FileNotFoundException e) {
            throw new UncheckedIOException(String.format("Failed to open existing file %s", queueFile), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean hasQueueFiles(Path queuePath) {
        try (Stream<Path> children = Files.list(queuePath);){
            boolean bl = children.anyMatch(p -> p.toString().endsWith(".cq4"));
            return bl;
        }
        catch (IOException e) {
            return false;
        }
    }
}

