/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.values;

import java.lang.reflect.InvocationTargetException;
import net.openhft.chronicle.values.ValueModel;

public final class Values {
    private Values() {
    }

    public static boolean isValueInterfaceOrImplClass(Class<?> valueTypeOrImplClass) {
        return ValueModel.isValueInterfaceOrImplClass(valueTypeOrImplClass);
    }

    public static <T> T newHeapInstance(Class<T> valueType) {
        try {
            return Values.heapClassFor(valueType).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static <T> T newNativeReference(Class<T> valueType) {
        try {
            return Values.nativeClassFor(valueType).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static <T> Class<T> heapClassFor(Class<T> valueType) {
        return ValueModel.acquire(valueType).heapClass();
    }

    public static <T> Class<T> nativeClassFor(Class<T> valueType) {
        return ValueModel.acquire(valueType).nativeClass();
    }
}

