/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.lang.io;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import net.openhft.lang.io.FileLifecycleListener;
import net.openhft.lang.io.NativeBytes;
import sun.misc.Cleaner;
import sun.nio.ch.DirectBuffer;

public class VanillaMappedBytes
extends NativeBytes {
    private final File path;
    private final MappedByteBuffer buffer;
    private final FileChannel channel;
    private final FileLifecycleListener fileLifecycleListener;
    private final long index;
    private boolean unmapped;

    public VanillaMappedBytes(File path, MappedByteBuffer buffer) {
        this(path, buffer, -1L, null, FileLifecycleListener.FileLifecycleListeners.IGNORE);
    }

    public VanillaMappedBytes(File path, MappedByteBuffer buffer, FileLifecycleListener fileLifecycleListener) {
        this(path, buffer, -1L, null, fileLifecycleListener);
    }

    public VanillaMappedBytes(File path, MappedByteBuffer buffer, long index) {
        this(path, buffer, index, null, FileLifecycleListener.FileLifecycleListeners.IGNORE);
    }

    public VanillaMappedBytes(File path, MappedByteBuffer buffer, long index, FileLifecycleListener fileLifecycleListener) {
        this(path, buffer, index, null, fileLifecycleListener);
    }

    protected VanillaMappedBytes(File path, MappedByteBuffer buffer, long index, FileChannel channel) {
        this(path, buffer, index, channel, FileLifecycleListener.FileLifecycleListeners.IGNORE);
    }

    protected VanillaMappedBytes(File path, MappedByteBuffer buffer, long index, FileChannel channel, FileLifecycleListener fileLifecycleListener) {
        super(buffer.capacity() == 0 ? NO_PAGE : ((DirectBuffer)((Object)buffer)).address(), buffer.capacity() == 0 ? NO_PAGE : ((DirectBuffer)((Object)buffer)).address() + (long)buffer.capacity());
        this.buffer = buffer;
        this.path = path;
        this.channel = channel;
        this.unmapped = false;
        this.index = index;
        this.fileLifecycleListener = fileLifecycleListener;
    }

    public long index() {
        return this.index;
    }

    public synchronized boolean unmapped() {
        return this.unmapped;
    }

    @Override
    public boolean release() {
        if (!this.unmapped()) {
            return super.release();
        }
        return false;
    }

    @Override
    protected synchronized void cleanup() {
        if (!this.unmapped) {
            Cleaner cl = ((DirectBuffer)((Object)this.buffer)).cleaner();
            if (cl != null) {
                long start = System.nanoTime();
                cl.clean();
                this.fileLifecycleListener.onEvent(FileLifecycleListener.EventType.UNMAP, this.path, System.nanoTime() - start);
            }
            try {
                if (this.channel != null && this.channel.isOpen()) {
                    this.channel.close();
                }
            }
            catch (IOException e) {
                throw new AssertionError((Object)e);
            }
            this.unmapped = true;
        }
        super.cleanup();
    }

    public void force() {
        long start = System.nanoTime();
        this.buffer.force();
        this.fileLifecycleListener.onEvent(FileLifecycleListener.EventType.SYNC, this.path, System.nanoTime() - start);
    }

    @Override
    public ByteBuffer sliceAsByteBuffer(ByteBuffer toReuse) {
        return this.sliceAsByteBuffer(toReuse, this.buffer);
    }
}

