/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.lang.io.serialization.impl;

import net.openhft.lang.io.Bytes;
import net.openhft.lang.io.NativeBytes;
import net.openhft.lang.io.serialization.BytesMarshallable;
import net.openhft.lang.io.serialization.BytesMarshaller;
import net.openhft.lang.model.constraints.NotNull;
import net.openhft.lang.model.constraints.Nullable;

public class BytesMarshallableMarshaller<E extends BytesMarshallable>
implements BytesMarshaller<E> {
    private static final long serialVersionUID = 0L;
    @NotNull
    private final Class<E> classMarshaled;

    public BytesMarshallableMarshaller(@NotNull Class<E> classMarshaled) {
        this.classMarshaled = classMarshaled;
    }

    public final Class<E> marshaledClass() {
        return this.classMarshaled;
    }

    @Override
    public void write(@NotNull Bytes bytes, @NotNull E e) {
        e.writeMarshallable(bytes);
    }

    @Override
    public E read(@NotNull Bytes bytes) {
        return this.read(bytes, (E)null);
    }

    @Override
    @Nullable
    public E read(Bytes bytes, @Nullable E e) {
        if (e == null) {
            try {
                e = this.getInstance();
            }
            catch (Exception e2) {
                throw new IllegalStateException(e2);
            }
        }
        e.readMarshallable(bytes);
        return e;
    }

    @NotNull
    protected E getInstance() throws Exception {
        return (E)((BytesMarshallable)NativeBytes.UNSAFE.allocateInstance(this.classMarshaled));
    }

    public boolean equals(Object obj) {
        return obj != null && obj.getClass() == this.getClass() && ((BytesMarshallableMarshaller)obj).classMarshaled == this.classMarshaled;
    }

    public int hashCode() {
        return this.classMarshaled.hashCode();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{classMarshaled=" + this.classMarshaled + "}";
    }
}

