/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.lang.io.serialization.impl;

import java.util.BitSet;
import java.util.LinkedHashMap;
import java.util.Map;
import net.openhft.lang.io.Bytes;
import net.openhft.lang.io.serialization.BytesMarshaller;
import net.openhft.lang.io.serialization.impl.ImmutableMarshaller;
import net.openhft.lang.io.serialization.impl.StringBuilderPool;
import net.openhft.lang.model.constraints.NotNull;
import net.openhft.lang.model.constraints.Nullable;

public class EnumBytesMarshaller<E extends Enum<E>>
extends ImmutableMarshaller<E>
implements BytesMarshaller<E> {
    private final E[] interner = new Enum[1024];
    private final BitSet internerDup = new BitSet(1024);
    private final Map<String, E> map = new LinkedHashMap<String, E>(64);
    private final E defaultValue;
    private final int mask;
    private static final StringBuilderPool sbp = new StringBuilderPool();

    public EnumBytesMarshaller(@NotNull Class<E> classMarshaled, E defaultValue) {
        this.defaultValue = defaultValue;
        this.mask = this.interner.length - 1;
        for (Enum e : (Enum[])classMarshaled.getEnumConstants()) {
            this.map.put(e.name(), e);
            int idx = this.hashFor(e.name());
            if (this.internerDup.get(idx)) continue;
            if (this.interner[idx] != null) {
                this.interner[idx] = null;
                this.internerDup.set(idx);
                continue;
            }
            this.interner[idx] = e;
        }
    }

    @Override
    public void write(@NotNull Bytes bytes, @Nullable E e) {
        bytes.writeUTF\u0394(e == null ? "" : ((Enum)e).name());
    }

    private int hashFor(@NotNull CharSequence cs) {
        int h = 0;
        int length = cs.length();
        for (int i = 0; i < length; ++i) {
            h = 57 * h + cs.charAt(i);
        }
        h ^= h >>> 20 ^ h >>> 12;
        h ^= h >>> 7 ^ h >>> 4;
        return h & this.mask;
    }

    @Override
    public E read(@NotNull Bytes bytes) {
        StringBuilder sb = sbp.acquireStringBuilder();
        bytes.readUTF\u0394(sb);
        return this.builderToEnum(sb);
    }

    private E builderToEnum(StringBuilder sb) {
        int num = this.hashFor(sb);
        int idx = num & this.mask;
        Object e = this.interner[idx];
        if (e != null) {
            return e;
        }
        if (!this.internerDup.get(idx)) {
            return this.defaultValue;
        }
        e = (Enum)this.map.get(sb.toString());
        return e == null ? this.defaultValue : e;
    }
}

