/*
 * Decompiled with CFR 0.152.
 */
package net.rakugakibox.spring.boot.logback.access;

import ch.qos.logback.access.spi.AccessContext;
import ch.qos.logback.access.spi.IAccessEvent;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.spi.FilterReply;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.rakugakibox.spring.boot.logback.access.AbstractLogbackAccessEvent;
import net.rakugakibox.spring.boot.logback.access.LogbackAccessAppendedEvent;
import net.rakugakibox.spring.boot.logback.access.LogbackAccessConfigurationException;
import net.rakugakibox.spring.boot.logback.access.LogbackAccessDeniedEvent;
import net.rakugakibox.spring.boot.logback.access.LogbackAccessJoranConfigurator;
import net.rakugakibox.spring.boot.logback.access.LogbackAccessProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.core.env.Environment;
import org.springframework.util.ClassUtils;
import org.springframework.util.ResourceUtils;

public class LogbackAccessContext
extends AccessContext {
    private static final Logger log = LoggerFactory.getLogger(LogbackAccessContext.class);
    private static final List<String> DEFAULT_CONFIGS = Collections.unmodifiableList(Arrays.asList("classpath:logback-access-test.xml", "classpath:logback-access.xml", "classpath:logback-access-test-spring.xml", "classpath:logback-access-spring.xml"));
    private static final String FALLBACK_CONFIG = "classpath:" + ClassUtils.addResourcePathToPackagePath(LogbackAccessContext.class, (String)"logback-access-spring.xml");
    private final LogbackAccessProperties logbackAccessProperties;
    private final Environment environment;
    private final ApplicationEventPublisher applicationEventPublisher;

    public LogbackAccessContext(LogbackAccessProperties logbackAccessProperties, Environment environment, ApplicationEventPublisher applicationEventPublisher) {
        this.logbackAccessProperties = logbackAccessProperties;
        this.environment = environment;
        this.applicationEventPublisher = applicationEventPublisher;
        this.setName("default");
    }

    public void configure() throws LogbackAccessConfigurationException {
        if (this.logbackAccessProperties.getConfig() != null) {
            this.configure(this.logbackAccessProperties.getConfig());
            return;
        }
        for (String config : DEFAULT_CONFIGS) {
            if (!this.configureIfPresent(config)) continue;
            return;
        }
        this.configure(FALLBACK_CONFIG);
    }

    private void configure(String config) throws LogbackAccessConfigurationException {
        try {
            this.configureWithCauseThrowing(config);
        }
        catch (Exception exc) {
            throw new LogbackAccessConfigurationException(this, config, exc);
        }
    }

    private boolean configureIfPresent(String config) throws LogbackAccessConfigurationException {
        try {
            this.configureWithCauseThrowing(config);
            return true;
        }
        catch (FileNotFoundException exc) {
            return false;
        }
        catch (Exception exc) {
            throw new LogbackAccessConfigurationException(this, config, exc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configureWithCauseThrowing(String config) throws IOException, JoranException {
        URL url = ResourceUtils.getURL((String)config);
        InputStream stream = url.openStream();
        try {
            LogbackAccessJoranConfigurator configurator = new LogbackAccessJoranConfigurator(this.environment);
            configurator.setContext((Context)this);
            configurator.doConfigure(stream);
            log.info("Configured the Logback-access: context=[{}], config=[{}]", (Object)this, (Object)config);
        }
        finally {
            if (Collections.singletonList(stream).get(0) != null) {
                stream.close();
            }
        }
    }

    public void emit(AbstractLogbackAccessEvent event) {
        event.setUseServerPortInsteadOfLocalPort(this.logbackAccessProperties.isUseServerPortInsteadOfLocalPort());
        if (this.getFilterChainDecision((IAccessEvent)event) != FilterReply.DENY) {
            this.callAppenders((IAccessEvent)event);
            this.applicationEventPublisher.publishEvent((ApplicationEvent)new LogbackAccessAppendedEvent((Object)this, (IAccessEvent)event));
        } else {
            this.applicationEventPublisher.publishEvent((ApplicationEvent)new LogbackAccessDeniedEvent((Object)this, (IAccessEvent)event));
        }
    }
}

