/*
 * Decompiled with CFR 0.152.
 */
package net.razorvine.serpent;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import javax.xml.bind.DatatypeConverter;
import net.razorvine.serpent.ComplexNumber;
import net.razorvine.serpent.IClassSerializer;

public class Serializer {
    public boolean indent = false;
    public boolean setliterals = true;
    public boolean packageInClassName = false;
    private static Map<Class<?>, IClassSerializer> classToDictRegistry = new HashMap();
    private static final HashSet<Class<?>> boxedTypes = new HashSet();

    public Serializer() {
    }

    public Serializer(boolean indent, boolean setliterals, boolean packageInClassName) {
        this.indent = indent;
        this.setliterals = setliterals;
        this.packageInClassName = packageInClassName;
    }

    public static void registerClass(Class<?> clazz, IClassSerializer converter) {
        classToDictRegistry.put(clazz, converter);
    }

    public byte[] serialize(Object obj) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        String header = "# serpent utf-8 ";
        header = this.setliterals ? header + "python3.2\n" : header + "python2.6\n";
        pw.print(header);
        this.serialize(obj, pw, 0);
        pw.flush();
        String ser = sw.toString();
        pw.close();
        try {
            sw.close();
            return ser.getBytes("utf-8");
        }
        catch (IOException x) {
            throw new IllegalArgumentException("error creating output bytes: " + x);
        }
    }

    protected void serialize(Object obj, PrintWriter p, int level) {
        Class<?> componentType;
        Class<?> type = obj == null ? null : obj.getClass();
        Class<?> clazz = componentType = type == null ? null : type.getComponentType();
        if (componentType != null) {
            if (componentType == Byte.TYPE) {
                this.serialize_bytes((byte[])obj, p, level);
                return;
            }
            this.serialize_primitive_array(obj, p, level);
            return;
        }
        if (obj == null) {
            p.print("None");
        } else if (obj instanceof String) {
            this.serialize_string((String)obj, p, level);
        } else if (type.isPrimitive() || this.isBoxed(type)) {
            this.serialize_primitive(obj, p, level);
        } else if (obj instanceof Enum) {
            this.serialize_string(obj.toString(), p, level);
        } else if (obj instanceof BigDecimal) {
            this.serialize_bigdecimal((BigDecimal)obj, p, level);
        } else if (obj instanceof Number) {
            this.serialize_primitive(obj, p, level);
        } else if (obj instanceof Date) {
            this.serialize_date((Date)obj, p, level);
        } else if (obj instanceof Calendar) {
            this.serialize_calendar((Calendar)obj, p, level);
        } else if (obj instanceof UUID) {
            this.serialize_uuid((UUID)obj, p, level);
        } else if (obj instanceof Set) {
            this.serialize_set((Set)obj, p, level);
        } else if (obj instanceof Map) {
            this.serialize_dict((Map)obj, p, level);
        } else if (obj instanceof Collection) {
            this.serialize_collection((Collection)obj, p, level);
        } else if (obj instanceof ComplexNumber) {
            this.serialize_complex((ComplexNumber)obj, p, level);
        } else if (obj instanceof Exception) {
            this.serialize_exception((Exception)obj, p, level);
        } else if (obj instanceof Serializable) {
            this.serialize_class(obj, p, level);
        } else {
            throw new IllegalArgumentException("cannot serialize object of type " + type);
        }
    }

    protected void serialize_collection(Collection<?> collection, PrintWriter p, int level) {
        p.print("[");
        this.serialize_sequence_elements(collection, false, p, level + 1);
        if (this.indent && collection.size() > 0) {
            for (int i = 0; i < level; ++i) {
                p.print("  ");
            }
        }
        p.print("]");
    }

    protected void serialize_sequence_elements(Collection<?> elts, boolean trailingComma, PrintWriter p, int level) {
        if (elts.size() == 0) {
            return;
        }
        int count = 0;
        if (this.indent) {
            p.print("\n");
            String innerindent = "";
            for (int i = 0; i < level; ++i) {
                innerindent = innerindent + "  ";
            }
            for (Object e : elts) {
                p.print(innerindent);
                this.serialize(e, p, level);
                if (++count >= elts.size()) continue;
                p.print(",\n");
            }
            if (trailingComma) {
                p.print(",");
            }
            p.print("\n");
        } else {
            for (Object e : elts) {
                this.serialize(e, p, level);
                if (++count >= elts.size()) continue;
                p.print(",");
            }
            if (trailingComma) {
                p.print(",");
            }
        }
    }

    protected void serialize_set(Set<?> set, PrintWriter p, int level) {
        if (!this.setliterals) {
            this.serialize_tuple(set, p, level);
            return;
        }
        if (set.size() > 0) {
            p.print("{");
            Set<?> output = set;
            if (this.indent) {
                Set<?> outputset = set;
                try {
                    outputset = new TreeSet(set);
                }
                catch (ClassCastException x) {
                    // empty catch block
                }
                output = outputset;
            }
            this.serialize_sequence_elements(output, false, p, level + 1);
            if (this.indent) {
                for (int i = 0; i < level; ++i) {
                    p.print("  ");
                }
            }
            p.print("}");
        } else {
            this.serialize_tuple(Collections.EMPTY_LIST, p, level + 1);
        }
    }

    protected void serialize_primitive_array(Object array, PrintWriter p, int level) {
        int length = Array.getLength(array);
        ArrayList<Object> items = new ArrayList<Object>(length);
        for (int i = 0; i < length; ++i) {
            items.add(Array.get(array, i));
        }
        this.serialize_tuple(items, p, level);
    }

    protected void serialize_tuple(Collection<?> items, PrintWriter p, int level) {
        p.print("(");
        this.serialize_sequence_elements(items, items.size() == 1, p, level + 1);
        if (this.indent && items.size() > 0) {
            for (int i = 0; i < level; ++i) {
                p.print("  ");
            }
        }
        p.print(")");
    }

    protected void serialize_bytes(byte[] obj, PrintWriter p, int level) {
        String str = DatatypeConverter.printBase64Binary((byte[])obj);
        HashMap<String, String> dict = new HashMap<String, String>();
        dict.put("data", str);
        dict.put("encoding", "base64");
        this.serialize_dict(dict, p, level);
    }

    protected void serialize_dict(Map<?, ?> dict, PrintWriter p, int level) {
        if (dict.size() == 0) {
            p.print("{}");
            return;
        }
        int counter = 0;
        if (this.indent) {
            String innerindent = "  ";
            for (int i = 0; i < level; ++i) {
                innerindent = innerindent + "  ";
            }
            p.print("{\n");
            Map<?, ?> outputdict = dict;
            try {
                outputdict = new TreeMap(dict);
            }
            catch (ClassCastException x) {
                // empty catch block
            }
            for (Map.Entry<?, ?> e : outputdict.entrySet()) {
                p.print(innerindent);
                this.serialize(e.getKey(), p, level + 1);
                p.print(": ");
                this.serialize(e.getValue(), p, level + 1);
                if (++counter >= dict.size()) continue;
                p.print(",\n");
            }
            p.print("\n");
            for (int i = 0; i < level; ++i) {
                p.print("  ");
            }
            p.print("}");
        } else {
            p.print("{");
            for (Map.Entry<?, ?> e : dict.entrySet()) {
                this.serialize(e.getKey(), p, level + 1);
                p.print(":");
                this.serialize(e.getValue(), p, level + 1);
                if (++counter >= dict.size()) continue;
                p.print(",");
            }
            p.print("}");
        }
    }

    protected void serialize_calendar(Calendar cal, PrintWriter p, int level) {
        this.serialize_string(DatatypeConverter.printDateTime((Calendar)cal), p, level);
    }

    protected void serialize_date(Date date, PrintWriter p, int level) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        df.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.serialize_string(df.format(date), p, level);
    }

    protected void serialize_complex(ComplexNumber cplx, PrintWriter p, int level) {
        p.print("(");
        this.serialize_primitive(cplx.real, p, level);
        if (cplx.imaginary >= 0.0) {
            p.print("+");
        }
        this.serialize_primitive(cplx.imaginary, p, level);
        p.print("j)");
    }

    protected void serialize_uuid(UUID obj, PrintWriter p, int level) {
        this.serialize_string(obj.toString(), p, level);
    }

    protected void serialize_bigdecimal(BigDecimal decimal, PrintWriter p, int level) {
        this.serialize_string(decimal.toEngineeringString(), p, level);
    }

    protected boolean isBoxed(Class<?> type) {
        return boxedTypes.contains(type);
    }

    protected void serialize_class(Object obj, PrintWriter p, int level) {
        Map<String, Object> map;
        IClassSerializer converter = classToDictRegistry.get(obj.getClass());
        if (null != converter) {
            map = converter.convert(obj);
        } else {
            map = new HashMap<String, Object>();
            try {
                for (Method m : obj.getClass().getMethods()) {
                    int modifiers = m.getModifiers();
                    if ((modifiers & 1) == 0 || (modifiers & 8) != 0) continue;
                    String methodname = m.getName();
                    int prefixlen = 0;
                    if (methodname.equals("getClass")) continue;
                    if (methodname.startsWith("get")) {
                        prefixlen = 3;
                    } else {
                        if (!methodname.startsWith("is")) continue;
                        prefixlen = 2;
                    }
                    Object value = m.invoke(obj, new Object[0]);
                    String name = methodname.substring(prefixlen);
                    if (name.length() == 1) {
                        name = name.toLowerCase();
                    } else if (!Character.isUpperCase(name.charAt(1))) {
                        name = Character.toLowerCase(name.charAt(0)) + name.substring(1);
                    }
                    map.put(name, value);
                }
                if (this.packageInClassName) {
                    map.put("__class__", obj.getClass().getName());
                } else {
                    map.put("__class__", obj.getClass().getSimpleName());
                }
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException("couldn't introspect javabean: " + e);
            }
            catch (InvocationTargetException e) {
                throw new IllegalArgumentException("couldn't introspect javabean: " + e);
            }
        }
        this.serialize_dict(map, p, level);
    }

    protected void serialize_primitive(Object obj, PrintWriter p, int level) {
        if (obj instanceof Boolean || obj.getClass() == Boolean.TYPE) {
            p.print(obj.equals(Boolean.TRUE) ? "True" : "False");
        } else if (obj instanceof Float || obj.getClass() == Float.TYPE) {
            Float f = (Float)obj;
            this.serialize_primitive(f.doubleValue(), p, level);
        } else if (obj instanceof Double || obj.getClass() == Double.TYPE) {
            Double d = (Double)obj;
            if (d.isInfinite()) {
                if (d > 0.0) {
                    p.print("1e30000");
                } else {
                    p.print("-1e30000");
                }
            } else if (d.isNaN()) {
                p.print("{'__class__':'float','value':'nan'}");
            } else {
                p.print(d);
            }
        } else {
            p.print(obj);
        }
    }

    protected void serialize_string(String str, PrintWriter p, int level) {
        str = str.replace("\\", "\\\\");
        str = str.replace("\b", "\\b");
        str = str.replace("\f", "\\f");
        str = str.replace("\n", "\\n");
        str = str.replace("\r", "\\r");
        if (!(str = str.replace("\t", "\\t")).contains("'")) {
            str = "'" + str + "'";
        } else if (!str.contains("\"")) {
            str = '\"' + str + '\"';
        } else {
            str = str.replace("'", "\\'");
            str = "'" + str + "'";
        }
        p.print(str);
    }

    protected void serialize_exception(Exception ex, PrintWriter p, int level) {
        Map<String, Object> dict;
        IClassSerializer converter = classToDictRegistry.get(ex.getClass());
        if (null != converter) {
            dict = converter.convert(ex);
        } else {
            dict = new HashMap<String, Object>();
            if (this.packageInClassName) {
                dict.put("__class__", ex.getClass().getName());
            } else {
                dict.put("__class__", ex.getClass().getSimpleName());
            }
            dict.put("__exception__", true);
            dict.put("args", new String[]{ex.getMessage()});
            dict.put("attributes", Collections.EMPTY_MAP);
        }
        this.serialize_dict(dict, p, level);
    }

    static {
        boxedTypes.add(Boolean.class);
        boxedTypes.add(Character.class);
        boxedTypes.add(Byte.class);
        boxedTypes.add(Short.class);
        boxedTypes.add(Integer.class);
        boxedTypes.add(Long.class);
        boxedTypes.add(Float.class);
        boxedTypes.add(Double.class);
    }
}

