/*
 * Decompiled with CFR 0.152.
 */
package net.razorvine.serpent.ast;

import net.razorvine.serpent.ast.INode;
import net.razorvine.serpent.ast.INodeVisitor;

public class ComplexNumberNode
implements INode {
    public double real;
    public double imaginary;

    public ComplexNumberNode() {
    }

    public ComplexNumberNode(double real, double imaginary) {
        this.real = real;
        this.imaginary = imaginary;
    }

    @Override
    public void accept(INodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public String toString() {
        String strReal = "" + this.real;
        String strImag = "" + this.imaginary;
        if (this.imaginary >= 0.0) {
            return String.format("(%s+%sj)", strReal, strImag);
        }
        return String.format("(%s%sj)", strReal, strImag);
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof ComplexNumberNode)) {
            return false;
        }
        ComplexNumberNode other = (ComplexNumberNode)obj;
        return this.real == other.real && this.imaginary == other.imaginary;
    }
}

