/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.model.FailureCause;
import net.thucydides.core.util.EnvironmentVariables;

public class RootCauseAnalyzer {
    private final Throwable thrownException;
    private final EnvironmentVariables environmentVariables;
    private static final List<String> MASKED_PACKAGES = ImmutableList.of((Object)"sun.", (Object)"com.sun", (Object)"java.", (Object)"org.junit", (Object)"org.gradle", (Object)"org.fest", (Object)"org.hamcrest", (Object)"org.openqa.selenium", (Object)"org.spockframework", (Object)"org.apache.maven.surefire", (Object)"com.intellij", (Object)"net.sf.cglib", (Object[])new String[]{"org.codehaus.groovy", "org.jbehave", "net.thucydides.core", "net.thucydides.jbehave", "net.thucydides.junit"});

    public RootCauseAnalyzer(Throwable thrownException) {
        this(thrownException, (EnvironmentVariables)Injectors.getInjector().getProvider(EnvironmentVariables.class).get());
    }

    public RootCauseAnalyzer(Throwable thrownException, EnvironmentVariables environmentVariables) {
        this.thrownException = thrownException;
        this.environmentVariables = environmentVariables;
    }

    public FailureCause getRootCause() {
        Throwable originalException = this.thrownException.getCause() != null ? this.thrownException.getCause() : this.thrownException;
        return new FailureCause(originalException, this.sanitized(originalException.getStackTrace()));
    }

    public String getClassname() {
        return this.getRootCause().getErrorType();
    }

    public String getMessage() {
        return this.getRootCause().getMessage();
    }

    private StackTraceElement[] sanitized(StackTraceElement[] stackTrace) {
        return this.useSimplifedStackTraces() ? this.simplifiedStackTrace(stackTrace) : stackTrace;
    }

    private boolean useSimplifedStackTraces() {
        return ThucydidesSystemProperty.SIMPLIFIED_STACK_TRACES.booleanFrom(this.environmentVariables, true);
    }

    private StackTraceElement[] simplifiedStackTrace(StackTraceElement[] stackTrace) {
        ArrayList cleanStackTrace = Lists.newArrayList();
        for (StackTraceElement element : stackTrace) {
            if (!this.shouldDisplayInStackTrace(element)) continue;
            cleanStackTrace.add(element);
        }
        return cleanStackTrace.toArray(new StackTraceElement[0]);
    }

    private boolean shouldDisplayInStackTrace(StackTraceElement element) {
        if (element.getClassName().contains("$$")) {
            return false;
        }
        for (String maskedPackage : MASKED_PACKAGES) {
            if (!element.getClassName().startsWith(maskedPackage)) continue;
            return false;
        }
        return true;
    }
}

