/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.pages;

import com.google.common.base.Optional;
import java.net.MalformedURLException;
import java.net.URL;
import net.thucydides.core.annotations.DefaultUrl;
import net.thucydides.core.annotations.NamedUrl;
import net.thucydides.core.annotations.NamedUrls;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.webdriver.Configuration;
import org.apache.commons.lang3.StringUtils;

public class PageUrls {
    private static final String CLASSPATH_URL_PREFIX = "classpath:";
    private static final int CLASSPATH_URL_PREFIX_LENGTH = "classpath:".length();
    private Object pageObject;
    private String pageLevelDefaultBaseUrl;
    private final Configuration configuration;

    public PageUrls(Object pageObject, Configuration configuration) {
        this.pageObject = pageObject;
        this.configuration = configuration;
    }

    public PageUrls(Object pageObject) {
        this(pageObject, (Configuration)Injectors.getInjector().getInstance(Configuration.class));
    }

    public String getStartingUrl() {
        Optional<String> declaredDefaultUrl = this.getDeclaredDefaultUrl();
        String url = declaredDefaultUrl.isPresent() ? this.addBaseUrlTo((String)declaredDefaultUrl.get()) : this.getBaseUrl();
        return this.verified(url);
    }

    private Optional<String> getDeclaredDefaultUrl() {
        DefaultUrl urlAnnotation = this.pageObject.getClass().getAnnotation(DefaultUrl.class);
        if (urlAnnotation != null) {
            return Optional.fromNullable((Object)urlAnnotation.value());
        }
        return Optional.absent();
    }

    public String verified(String requestedUrl) {
        if (PageUrls.isAClasspathResource(requestedUrl)) {
            return PageUrls.obtainResourcePathFromClasspath(requestedUrl).toString();
        }
        try {
            URL url = new URL(requestedUrl);
            return url.toString();
        }
        catch (MalformedURLException e) {
            throw new AssertionError((Object)("Invalid URL: " + requestedUrl));
        }
    }

    public static String getUrlFrom(String annotatedBaseUrl) {
        if (annotatedBaseUrl == null) {
            return null;
        }
        if (PageUrls.isAClasspathResource(annotatedBaseUrl)) {
            URL baseUrl = PageUrls.obtainResourcePathFromClasspath(annotatedBaseUrl);
            return baseUrl.toString();
        }
        return annotatedBaseUrl;
    }

    private static boolean isAClasspathResource(String annotatedBaseUrl) {
        return annotatedBaseUrl != null && annotatedBaseUrl.startsWith(CLASSPATH_URL_PREFIX);
    }

    private static URL obtainResourcePathFromClasspath(String classpathUrl) {
        String resourcePath = classpathUrl.substring(CLASSPATH_URL_PREFIX_LENGTH);
        URL resourceUrl = Thread.currentThread().getContextClassLoader().getResource(resourcePath);
        if (resourceUrl == null) {
            throw new IllegalStateException("No matching web page could be found on the classpath for " + classpathUrl);
        }
        return resourceUrl;
    }

    private String getBaseUrl() {
        String baseUrl = StringUtils.isNotEmpty((CharSequence)this.getSystemBaseUrl()) ? this.getSystemBaseUrl() : this.pageLevelDefaultBaseUrl;
        return PageUrls.getUrlFrom(baseUrl);
    }

    public String getStartingUrl(String ... parameterValues) {
        String startingUrlTemplate = this.getStartingUrl();
        return this.urlWithParametersSubstituted(startingUrlTemplate, parameterValues);
    }

    public String getNamedUrl(String name) {
        NamedUrls urlAnnotation = this.pageObject.getClass().getAnnotation(NamedUrls.class);
        if (urlAnnotation != null) {
            NamedUrl[] namedUrlList;
            for (NamedUrl namedUrl : namedUrlList = urlAnnotation.value()) {
                if (!namedUrl.name().equals(name)) continue;
                return this.prefixedWithDefaultUrl(namedUrl.url());
            }
        }
        throw new IllegalArgumentException("No URL named " + name + " was found in this class");
    }

    private String prefixedWithDefaultUrl(String url) {
        Optional<String> declaredDefaultUrl = this.getDeclaredDefaultUrl();
        if (declaredDefaultUrl.isPresent() && this.isARelativeUrl(url)) {
            return StringUtils.stripEnd((String)((String)declaredDefaultUrl.get()), (String)"/") + "/" + StringUtils.stripStart((String)url, (String)"/");
        }
        return url;
    }

    public String getNamedUrl(String name, String[] parameterValues) {
        String startingUrlTemplate = this.getNamedUrl(name);
        return this.urlWithParametersSubstituted(startingUrlTemplate, parameterValues);
    }

    private String urlWithParametersSubstituted(String template, String[] parameterValues) {
        String url = template;
        for (int i = 0; i < parameterValues.length; ++i) {
            String variable = String.format("{%d}", i + 1);
            url = url.replace(variable, parameterValues[i]);
        }
        return this.addBaseUrlTo(url);
    }

    private String addBaseUrlTo(String url) {
        if (PageUrls.isAClasspathResource(url) && this.baseUrlIsDefined()) {
            return this.getBaseUrl();
        }
        if (this.isARelativeUrl(url)) {
            return this.updatedRelativeUrl(url);
        }
        return this.updatedFullUrl(url);
    }

    private boolean baseUrlIsDefined() {
        return StringUtils.isNotEmpty((CharSequence)this.getBaseUrl());
    }

    private String updatedFullUrl(String url) {
        if (PageUrls.isAClasspathResource(url)) {
            return url;
        }
        String updatedUrl = url;
        if (StringUtils.isNotEmpty((CharSequence)this.getBaseUrl())) {
            try {
                updatedUrl = this.removeDoubleSlashesFrom(this.getBaseUrl() + this.pathFrom(url));
            }
            catch (MalformedURLException e) {
                throw new AssertionError((Object)("Invalid URL: " + url));
            }
        }
        return updatedUrl;
    }

    private String removeDoubleSlashesFrom(String url) {
        return url.replaceAll("([^:])//", "$1/");
    }

    private String pathFrom(String url) throws MalformedURLException {
        URL defaultUrl = new URL(url);
        return url.substring(url.indexOf(defaultUrl.getAuthority()) + defaultUrl.getAuthority().length());
    }

    private String updatedRelativeUrl(String url) {
        String updatedUrl = StringUtils.isNotEmpty((CharSequence)this.getBaseUrl()) ? this.getBaseUrl() + url : url;
        return updatedUrl;
    }

    private boolean isARelativeUrl(String url) {
        return url.startsWith("/");
    }

    public void overrideDefaultBaseUrl(String defaultBaseUrl) {
        this.pageLevelDefaultBaseUrl = defaultBaseUrl;
    }

    public String getSystemBaseUrl() {
        return this.configuration.getBaseUrl();
    }
}

