/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports.html;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.issues.IssueTracking;
import net.thucydides.core.model.NumericalFormatter;
import net.thucydides.core.reports.ReportOptions;
import net.thucydides.core.reports.TestOutcomes;
import net.thucydides.core.reports.html.Formatter;
import net.thucydides.core.reports.html.HtmlReporter;
import net.thucydides.core.reports.html.ReportNameProvider;
import net.thucydides.core.requirements.RequirementsService;
import net.thucydides.core.requirements.reports.RequirementsOutcomes;
import net.thucydides.core.util.Inflector;
import net.thucydides.core.util.VersionProvider;

public class HtmlRequirementsReporter
extends HtmlReporter {
    private static final String DEFAULT_REQUIREMENTS_REPORT = "freemarker/requirements.ftl";
    private static final String REPORT_NAME = "capabilities.html";
    private final IssueTracking issueTracking;
    private final RequirementsService requirementsService;
    private final String relativeLink;

    public HtmlRequirementsReporter() {
        this("", (IssueTracking)Injectors.getInjector().getInstance(IssueTracking.class), (RequirementsService)Injectors.getInjector().getInstance(RequirementsService.class));
    }

    public HtmlRequirementsReporter(String relativeLink) {
        this(relativeLink, (IssueTracking)Injectors.getInjector().getInstance(IssueTracking.class), (RequirementsService)Injectors.getInjector().getInstance(RequirementsService.class));
    }

    public HtmlRequirementsReporter(String relativeLink, IssueTracking issueTracking, RequirementsService requirementsService) {
        this.relativeLink = relativeLink;
        this.issueTracking = issueTracking;
        this.requirementsService = requirementsService;
    }

    public File generateReportFor(RequirementsOutcomes requirementsOutcomes) throws IOException {
        return this.generateReportFor(requirementsOutcomes, requirementsOutcomes.getTestOutcomes(), REPORT_NAME);
    }

    public File generateReportFor(RequirementsOutcomes requirementsOutcomes, TestOutcomes testOutcomes, String filename) throws IOException {
        Preconditions.checkNotNull((Object)this.getOutputDirectory());
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("requirements", requirementsOutcomes);
        context.put("requirementTypes", this.requirementsService.getRequirementTypes());
        context.put("testOutcomes", requirementsOutcomes.getTestOutcomes());
        context.put("allTestOutcomes", testOutcomes);
        context.put("timestamp", this.timestampFrom(testOutcomes));
        context.put("reportName", new ReportNameProvider());
        context.put("absoluteReportName", new ReportNameProvider());
        context.put("reportOptions", new ReportOptions(this.getEnvironmentVariables()));
        context.put("relativeLink", this.relativeLink);
        VersionProvider versionProvider = new VersionProvider(this.getEnvironmentVariables());
        context.put("serenityVersionNumber", versionProvider.getVersion());
        context.put("buildNumber", versionProvider.getBuildNumberText());
        this.addFormattersToContext(context);
        String htmlContents = this.mergeTemplate(DEFAULT_REQUIREMENTS_REPORT).usingContext(context);
        this.copyResourcesToOutputDirectory();
        return this.writeReportToOutputDirectory(filename, htmlContents);
    }

    private void addFormattersToContext(Map<String, Object> context) {
        Formatter formatter = new Formatter(this.issueTracking);
        context.put("formatter", formatter);
        context.put("formatted", new NumericalFormatter());
        context.put("inflection", Inflector.getInstance());
    }
}

