/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.webdriver.javascript;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;
import java.util.List;
import net.thucydides.core.pages.jquery.JQueryEnabledPage;
import net.thucydides.core.webdriver.WebDriverFacade;
import net.thucydides.core.webdriver.javascript.JavascriptSupport;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;

public class JavascriptExecutorFacade {
    private WebDriver driver;
    private ObjectMapper mapper;
    private InjectableValues inject;

    public JavascriptExecutorFacade(WebDriver driver) {
        this.driver = driver;
    }

    public JavascriptExecutorFacade() {
    }

    public JavascriptExecutorFacade withObjectMapper(ObjectMapper mapper) {
        this.mapper = mapper;
        return this;
    }

    public JavascriptExecutorFacade withInjectableValues(InjectableValues inject) {
        this.inject = inject;
        return this;
    }

    public Object executeScript(String script) {
        if (JavascriptSupport.javascriptIsSupportedIn(this.driver)) {
            JavascriptExecutor js = this.getJavascriptEnabledDriver();
            return js.executeScript(script, new Object[0]);
        }
        return null;
    }

    public Object executeScript(String script, Object ... params) {
        if (JavascriptSupport.javascriptIsSupportedIn(this.driver)) {
            JavascriptExecutor js = this.getJavascriptEnabledDriver();
            return js.executeScript(script, params);
        }
        return null;
    }

    private String executeAndGetJsonAsString(String script, Object ... params) {
        JQueryEnabledPage jQueryEnabledPage = JQueryEnabledPage.withDriver(this.getRealDriver());
        jQueryEnabledPage.injectJavaScriptUtils();
        return (String)this.executeScript("return JSON.stringify(JSON.decycle(function(arguments){" + script + "}(arguments)));", params);
    }

    private <T> T deserializeJsonAs(Class<T> classOfT, String objString) {
        ObjectMapper mapper = this.getMapper();
        ObjectReader reader = mapper.reader(classOfT);
        if (this.inject != null) {
            reader = reader.with(this.inject);
        }
        try {
            return (T)reader.readValue(objString);
        }
        catch (JsonParseException e) {
            throw new WebDriverException((Throwable)e);
        }
        catch (JsonMappingException e) {
            throw new WebDriverException((Throwable)e);
        }
        catch (IOException e) {
            throw new WebDriverException((Throwable)e);
        }
    }

    private <T> List<T> deserializeJsonAsListOf(Class<T> classOfT, String objString) {
        ObjectMapper mapper = this.getMapper();
        ObjectReader reader = mapper.reader((JavaType)TypeFactory.defaultInstance().constructCollectionType(List.class, classOfT));
        if (this.inject != null) {
            reader = reader.with(this.inject);
        }
        try {
            return (List)reader.readValue(objString);
        }
        catch (JsonParseException e) {
            throw new WebDriverException((Throwable)e);
        }
        catch (JsonMappingException e) {
            throw new WebDriverException((Throwable)e);
        }
        catch (IOException e) {
            throw new WebDriverException((Throwable)e);
        }
    }

    private ObjectMapper getMapper() {
        if (this.mapper == null) {
            this.mapper = new ObjectMapper();
        }
        return this.mapper;
    }

    public <T> T deserializeScriptResultAs(Class<T> classOfT, String script, Object ... params) {
        String objString = this.executeAndGetJsonAsString(script, params);
        if (objString == null) {
            return null;
        }
        return this.deserializeJsonAs(classOfT, objString);
    }

    public <T> List<T> deserializeScriptResultAsListOf(Class<T> classOfT, String script, Object ... params) {
        String objString = this.executeAndGetJsonAsString(script, params);
        if (objString == null) {
            return null;
        }
        return this.deserializeJsonAsListOf(classOfT, objString);
    }

    private WebDriver getRealDriver() {
        if (WebDriverFacade.class.isAssignableFrom(this.driver.getClass())) {
            WebDriverFacade driverFacade = (WebDriverFacade)this.driver;
            return driverFacade.getProxiedDriver();
        }
        return this.driver;
    }

    private JavascriptExecutor getJavascriptEnabledDriver() {
        return (JavascriptExecutor)this.getRealDriver();
    }
}

