/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.core.webdriver.driverproviders;

import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Map;
import net.serenitybdd.core.environment.EnvironmentSpecificConfiguration;
import net.serenitybdd.core.webdriver.driverproviders.BrowserStackDriverBuilder;
import net.serenitybdd.core.webdriver.driverproviders.DefaultRemoteDriver;
import net.serenitybdd.core.webdriver.driverproviders.DriverCapabilities;
import net.serenitybdd.core.webdriver.driverproviders.DriverProvider;
import net.serenitybdd.core.webdriver.driverproviders.RemoteDriverBuilder;
import net.serenitybdd.core.webdriver.driverproviders.RemoteWebdriverStub;
import net.serenitybdd.core.webdriver.driverproviders.SaucelabsDriverBuilder;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.fixtureservices.FixtureProviderService;
import net.thucydides.core.reports.remoteTesting.ASaucelabsConfiguration;
import net.thucydides.core.steps.StepEventBus;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.webdriver.CapabilityEnhancer;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.Augmenter;

public class RemoteDriverProvider
implements DriverProvider {
    private final FixtureProviderService fixtureProviderService;

    public RemoteDriverProvider(FixtureProviderService fixtureProviderService) {
        this.fixtureProviderService = fixtureProviderService;
    }

    private Map<RemoteDriverType, RemoteDriverBuilder> driverBuildersFor(EnvironmentVariables environmentVariables) {
        HashMap<RemoteDriverType, RemoteDriverBuilder> driverBuilders = new HashMap<RemoteDriverType, RemoteDriverBuilder>();
        CapabilityEnhancer enhancer = new CapabilityEnhancer(environmentVariables, this.fixtureProviderService);
        DriverCapabilities remoteDriverCapabilities = new DriverCapabilities(environmentVariables, enhancer);
        driverBuilders.put(RemoteDriverType.SAUCELABS, new SaucelabsDriverBuilder(environmentVariables, remoteDriverCapabilities));
        driverBuilders.put(RemoteDriverType.BROWSERSTACK, new BrowserStackDriverBuilder(environmentVariables, remoteDriverCapabilities));
        driverBuilders.put(RemoteDriverType.DEFAULT, new DefaultRemoteDriver(environmentVariables, remoteDriverCapabilities));
        return driverBuilders;
    }

    @Override
    public WebDriver newInstance(String options, EnvironmentVariables environmentVariables) throws MalformedURLException {
        if (StepEventBus.getEventBus().webdriverCallsAreSuspended()) {
            return RemoteWebdriverStub.from(environmentVariables);
        }
        WebDriver driver = this.driverBuildersFor(environmentVariables).get((Object)this.remoteDriverType(environmentVariables)).buildWithOptions(options);
        return new Augmenter().augment(driver);
    }

    private RemoteDriverType remoteDriverType(EnvironmentVariables environmentVariables) {
        if (ASaucelabsConfiguration.isDefinedIn((EnvironmentVariables)environmentVariables)) {
            return RemoteDriverType.SAUCELABS;
        }
        if (this.browserStackUrlIsDefined(environmentVariables)) {
            return RemoteDriverType.BROWSERSTACK;
        }
        return RemoteDriverType.DEFAULT;
    }

    private boolean browserStackUrlIsDefined(EnvironmentVariables environmentVariables) {
        return EnvironmentSpecificConfiguration.from((EnvironmentVariables)environmentVariables).getOptionalProperty(ThucydidesSystemProperty.BROWSERSTACK_URL).isPresent();
    }

    static enum RemoteDriverType {
        SAUCELABS,
        BROWSERSTACK,
        DEFAULT;

    }
}

