/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.bootstrap;

import java.util.Optional;
import net.thucydides.core.bootstrap.ThucydidesContext;
import net.thucydides.core.model.Story;
import net.thucydides.core.steps.StepEventBus;
import net.thucydides.core.steps.StepListener;

public final class ThucydidesAgent {
    private final ThucydidesContext context;

    public ThucydidesAgent(Optional<String> driver, StepListener ... additionalListeners) {
        this.context = ThucydidesContext.newContext(driver, additionalListeners);
    }

    public void enrich(Object testCase) {
        this.context.initialize(testCase);
    }

    public void testSuiteStarted(String name) {
        this.notifyEventBus().clear();
        this.notifyEventBus().testSuiteStarted(Story.called((String)name));
    }

    public void testStarted(String name) {
        this.notifyEventBus().testStarted(name);
    }

    public void testFinished() {
        this.notifyEventBus().testFinished();
    }

    public void testSuiteFinished() {
        this.notifyEventBus().testSuiteFinished();
        this.context.dropListeners();
        this.context.generateReports();
    }

    private StepEventBus notifyEventBus() {
        return StepEventBus.getParallelEventBus();
    }
}

