/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.webdriver.capabilities;

import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.stream.Collectors;
import net.thucydides.core.webdriver.capabilities.InvalidCapabilityException;
import net.thucydides.core.webdriver.capabilities.ListOfValues;
import net.thucydides.core.webdriver.capabilities.NestedMap;
import net.thucydides.core.webdriver.capabilities.SetBrowserVersionAndPlatform;
import net.thucydides.core.webdriver.capabilities.SetCommonBrowserOptions;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.chromium.ChromiumOptions;
import org.openqa.selenium.edge.EdgeOptions;
import org.openqa.selenium.logging.LoggingPreferences;
import org.openqa.selenium.remote.AbstractDriverOptions;
import org.openqa.selenium.remote.DesiredCapabilities;

public class ChromiumOptionsBuilder {
    public static ChromiumOptions<?> fromDesiredCapabilities(DesiredCapabilities capabilities, ChromiumOptions<?> chromiumOptions, String capabilitySectionName) {
        chromiumOptions.merge(chromiumOptions);
        chromiumOptions = (ChromiumOptions)chromiumOptions.merge((Capabilities)capabilities);
        SetBrowserVersionAndPlatform.from(capabilities).in((AbstractDriverOptions)chromiumOptions);
        if (capabilities.getCapability(capabilitySectionName) != null) {
            Map<String, Object> options = NestedMap.called(capabilitySectionName).from(capabilities.asMap());
            SetCommonBrowserOptions.from(options).in((AbstractDriverOptions)chromiumOptions);
            HashMap<String, Object> extraOptions = new HashMap<String, Object>();
            List chromeSpecificOptions = options.keySet().stream().filter(field -> !SetCommonBrowserOptions.propertyNames().contains(field)).collect(Collectors.toList());
            Iterator iterator = chromeSpecificOptions.iterator();
            block24: while (iterator.hasNext()) {
                String optionName;
                switch (optionName = (String)iterator.next()) {
                    case "args": {
                        List<String> args = ListOfValues.from(options).forProperty("args");
                        if (args.isEmpty()) continue block24;
                        chromiumOptions.addArguments(args);
                        continue block24;
                    }
                    case "extensions": {
                        if (!(options.get("extensions") instanceof List)) {
                            throw new InvalidCapabilityException("Invalid W3C capability: extensions should be a map but was " + String.valueOf(options.get("extensions")));
                        }
                        if (((List)options.get("extensions")).isEmpty()) continue block24;
                        ChromiumOptionsBuilder.addExtensions((List)options.get("extensions"), chromiumOptions);
                        continue block24;
                    }
                    case "binary": {
                        chromiumOptions.setBinary(options.get("binary").toString());
                        continue block24;
                    }
                    case "androidUseRunningApp": {
                        chromiumOptions.setUseRunningAndroidApp(Boolean.parseBoolean(options.get("androidUseRunningApp").toString()));
                        continue block24;
                    }
                    case "androidActivity": {
                        chromiumOptions.setAndroidActivity(options.get("androidActivity").toString());
                        continue block24;
                    }
                    case "androidDeviceSerial": {
                        chromiumOptions.setAndroidDeviceSerialNumber(options.get("androidDeviceSerial").toString());
                        continue block24;
                    }
                    case "androidPackage": {
                        chromiumOptions.setAndroidPackage(options.get("androidPackage").toString());
                        continue block24;
                    }
                    case "androidProcess": {
                        chromiumOptions.setAndroidProcess(options.get("androidProcess").toString());
                        continue block24;
                    }
                    case "prefs": {
                        chromiumOptions.setExperimentalOption("prefs", NestedMap.called("prefs").from(options));
                        continue block24;
                    }
                    case "excludeSwitches": {
                        chromiumOptions.setExperimentalOption("excludeSwitches", ListOfValues.from(options).forProperty("excludeSwitches"));
                        continue block24;
                    }
                }
                extraOptions.put(optionName, options.get(optionName));
            }
            Map<String, Object> browserSpecificOptions = NestedMap.called(capabilitySectionName).from(chromiumOptions.asMap());
            extraOptions.putAll(browserSpecificOptions);
            Map<String, Object> distinctExtraOptions = extraOptions.entrySet().stream().distinct().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            chromiumOptions.setCapability(capabilitySectionName, distinctExtraOptions);
        }
        if (capabilities.getCapability("goog:loggingPrefs") != null) {
            ChromiumOptionsBuilder.setChromiumLoggingPreferences(capabilities, chromiumOptions);
        } else if (capabilities.getCapability("ms:loggingPrefs") != null) {
            ChromiumOptionsBuilder.setChromiumLoggingPreferences(capabilities, chromiumOptions);
        }
        return chromiumOptions;
    }

    private static void addExtensions(List<?> extensions, ChromiumOptions<?> options) {
        List extensionFiles = extensions.stream().map(Object::toString).map(File::new).collect(Collectors.toList());
        options.addExtensions(extensionFiles);
    }

    private static void setChromiumLoggingPreferences(DesiredCapabilities capabilities, ChromiumOptions<?> options) {
        if (options instanceof ChromeOptions) {
            ChromiumOptionsBuilder.setLoggingPreferences(capabilities, "goog:loggingPrefs", options);
        } else if (options instanceof EdgeOptions) {
            ChromiumOptionsBuilder.setLoggingPreferences(capabilities, "ms:loggingPrefs", options);
        }
    }

    private static void setLoggingPreferences(DesiredCapabilities capabilities, String capabilityName, ChromiumOptions<?> options) {
        LoggingPreferences logPrefs = new LoggingPreferences();
        Object loggingPreferenceValue = capabilities.getCapability(capabilityName);
        if (!(loggingPreferenceValue instanceof Map)) {
            throw new InvalidCapabilityException("Invalid W3C capability: " + capabilityName + " should be a map but was " + String.valueOf(loggingPreferenceValue));
        }
        Map<String, Object> loggingPreferenceValues = NestedMap.called(capabilityName).from(capabilities.asMap());
        loggingPreferenceValues.forEach((key, value) -> logPrefs.enable(key, Level.parse(value.toString())));
        options.setCapability(capabilityName, (Object)logPrefs);
    }
}

