/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.webdriver.jquery;

import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebElement;

public class ByJQuerySelector
extends By {
    private static final char DOUBLE_QUOTE = '\"';
    private static final String SINGLE_QUOTE = "'";
    private final String jQuerySelector;

    public ByJQuerySelector(String selector) {
        this.jQuerySelector = selector;
    }

    public List<WebElement> findElements(SearchContext context) {
        String jquery = "return $(" + this.quoted(this.jQuerySelector) + ").get();";
        return (List)((JavascriptExecutor)context).executeScript(jquery, new Object[0]);
    }

    public WebElement findElement(SearchContext context) {
        String jquery = "return $(" + this.quoted(this.jQuerySelector) + ").get(0);";
        WebElement element = (WebElement)((JavascriptExecutor)context).executeScript(jquery, new Object[0]);
        if (element == null) {
            throw new NoSuchElementException("No element found matching JQuery selector " + this.jQuerySelector);
        }
        return element;
    }

    private String quoted(String jQuerySelector) {
        if (jQuerySelector.contains(SINGLE_QUOTE)) {
            return "\"" + jQuerySelector + "\"";
        }
        return SINGLE_QUOTE + jQuerySelector + SINGLE_QUOTE;
    }

    public String toString() {
        return "By.jQuerySelector: " + this.jQuerySelector;
    }
}

