/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.core.webdriver.driverproviders;

import java.util.Optional;
import net.serenitybdd.model.environment.EnvironmentSpecificConfiguration;
import net.thucydides.model.ThucydidesSystemProperty;
import net.thucydides.model.util.EnvironmentVariables;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.Proxy;

public class ConfiguredProxy {
    public static Optional<Proxy> definedIn(EnvironmentVariables environmentVariables) {
        String httpProxy = EnvironmentSpecificConfiguration.from((EnvironmentVariables)environmentVariables).getOptionalProperty(ThucydidesSystemProperty.SERENITY_PROXY_HTTP).orElse(null);
        String sslProxy = EnvironmentSpecificConfiguration.from((EnvironmentVariables)environmentVariables).getOptionalProperty(ThucydidesSystemProperty.SERENITY_PROXY_SSL).orElse(null);
        String ftpProxy = EnvironmentSpecificConfiguration.from((EnvironmentVariables)environmentVariables).getOptionalProperty(ThucydidesSystemProperty.SERENITY_PROXY_FTP).orElse(null);
        String noProxy = EnvironmentSpecificConfiguration.from((EnvironmentVariables)environmentVariables).getOptionalProperty(ThucydidesSystemProperty.SERENITY_PROXY_NOPROXY).orElse(null);
        String proxyType = EnvironmentSpecificConfiguration.from((EnvironmentVariables)environmentVariables).getOptionalProperty(ThucydidesSystemProperty.SERENITY_PROXY_TYPE).orElse(null);
        String proxyAutoconfigUrl = EnvironmentSpecificConfiguration.from((EnvironmentVariables)environmentVariables).getOptionalProperty(ThucydidesSystemProperty.SERENITY_PROXY_AUTOCONFIG).orElse(null);
        String socksProxy = EnvironmentSpecificConfiguration.from((EnvironmentVariables)environmentVariables).getOptionalProperty(ThucydidesSystemProperty.SERENITY_PROXY_SOCKS_PROXY).orElse(null);
        String socksProxyUsername = EnvironmentSpecificConfiguration.from((EnvironmentVariables)environmentVariables).getOptionalProperty(ThucydidesSystemProperty.SERENITY_PROXY_SOCKS_USERNAME).orElse(null);
        String socksProxyPassword = EnvironmentSpecificConfiguration.from((EnvironmentVariables)environmentVariables).getOptionalProperty(ThucydidesSystemProperty.SERENITY_PROXY_SOCKS_PASSWORD).orElse(null);
        String socksProxyVersionValue = EnvironmentSpecificConfiguration.from((EnvironmentVariables)environmentVariables).getOptionalProperty(ThucydidesSystemProperty.SERENITY_PROXY_SOCKS_VERSION).orElse(null);
        Integer socksProxyVersion = StringUtils.isNumeric((CharSequence)socksProxyVersionValue) ? Integer.valueOf(Integer.parseInt(socksProxyVersionValue)) : null;
        boolean autodetect = EnvironmentSpecificConfiguration.from((EnvironmentVariables)environmentVariables).getBooleanProperty(ThucydidesSystemProperty.SERENITY_PROXY_AUTODETECT);
        if (httpProxy != null && !httpProxy.isEmpty()) {
            Proxy proxy = new Proxy();
            proxy.setHttpProxy(httpProxy);
            if (sslProxy != null) {
                proxy.setSslProxy(sslProxy);
            }
            if (ftpProxy != null) {
                proxy.setFtpProxy(ftpProxy);
            }
            proxy.setAutodetect(autodetect);
            if (ftpProxy != null) {
                proxy.setFtpProxy(ftpProxy);
            }
            if (noProxy != null) {
                proxy.setNoProxy(noProxy);
            }
            if (proxyAutoconfigUrl != null) {
                proxy.setProxyAutoconfigUrl(proxyAutoconfigUrl);
            }
            if (proxyType != null) {
                proxy.setProxyType(Proxy.ProxyType.valueOf((String)proxyType));
            }
            if (socksProxy != null) {
                proxy.setSocksProxy(socksProxy);
            }
            if (socksProxyUsername != null) {
                proxy.setSocksUsername(socksProxyUsername);
            }
            if (socksProxyPassword != null) {
                proxy.setSocksPassword(socksProxyPassword);
            }
            if (socksProxyVersion != null && socksProxyVersion != 0) {
                proxy.setSocksVersion(socksProxyVersion);
            }
            return Optional.of(proxy);
        }
        return Optional.empty();
    }
}

