/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.webdriver.javascript;

import net.thucydides.core.webdriver.WebDriverFacade;
import net.thucydides.core.webdriver.stubs.WebDriverStub;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;

public class JavascriptSupport {
    public static boolean javascriptIsSupportedIn(Class<? extends WebDriver> driverClass) {
        return JavascriptSupport.isNotAMockedDriver(driverClass) && JavascriptSupport.supportsJavascript(driverClass);
    }

    public static boolean javascriptIsSupportedIn(WebDriver driver) {
        if (driver == null) {
            return false;
        }
        if (driver instanceof WebDriverStub) {
            return false;
        }
        Class<? extends WebDriver> driverClass = JavascriptSupport.getRealDriverClass(driver);
        return JavascriptSupport.javascriptIsSupportedIn(driverClass);
    }

    private static Class<? extends WebDriver> getRealDriverClass(WebDriver driver) {
        if (WebDriverFacade.class.isAssignableFrom(driver.getClass())) {
            WebDriverFacade driverFacade = (WebDriverFacade)driver;
            return driverFacade.getDriverClass();
        }
        return driver.getClass();
    }

    private static boolean supportsJavascript(Class<? extends WebDriver> driverClass) {
        return JavascriptExecutor.class.isAssignableFrom(driverClass);
    }

    private static boolean isNotAMockedDriver(Class<? extends WebDriver> driverClass) {
        return driverClass != null && !driverClass.getName().contains("Mock");
    }
}

