/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.core.parallel;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import net.serenitybdd.core.Serenity;
import net.serenitybdd.core.parallel.Agent;
import net.thucydides.core.steps.BaseStepListener;
import net.thucydides.core.steps.StepEventBus;

public class Agency {
    private static final Agency INSTANCE = new Agency();
    private final Map<Agent, BaseStepListener> listeners = new ConcurrentHashMap<Agent, BaseStepListener>();

    protected Agency() {
    }

    public static Agency getInstance() {
        return INSTANCE;
    }

    public void registerAgent(Agent agent) {
        this.listeners.put(agent, StepEventBus.getParallelEventBus().getBaseStepListener().spawn(agent.getName()));
    }

    public Optional<BaseStepListener> baseListenerFor(Agent agent) {
        return Optional.ofNullable(this.listeners.get(agent));
    }

    public void dropAgent(Agent agent) {
        this.listeners.remove(agent);
    }

    public Optional<BaseStepListener> currentAgentSpecificListener() {
        if (Serenity.sessionVariableCalled("$AGENT") != null) {
            return this.baseListenerFor((Agent)Serenity.sessionVariableCalled("$AGENT"));
        }
        return Optional.empty();
    }
}

