/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.steps.construction;

import java.lang.reflect.Constructor;
import java.util.Set;
import java.util.stream.Stream;
import net.serenitybdd.annotations.Fields;
import net.thucydides.core.pages.Pages;
import net.thucydides.core.steps.ScenarioSteps;
import net.thucydides.core.steps.construction.ConstructionStrategy;

public class StepLibraryConstructionStrategy {
    private final Class<?> stepLibraryClass;
    private final Constructor<?>[] declaredConstructors;

    private StepLibraryConstructionStrategy(Class<?> stepLibraryClass) {
        this.stepLibraryClass = stepLibraryClass;
        this.declaredConstructors = stepLibraryClass.getDeclaredConstructors();
    }

    public static StepLibraryConstructionStrategy forClass(Class<?> scenarioStepsClass) {
        return new StepLibraryConstructionStrategy(scenarioStepsClass);
    }

    public ConstructionStrategy getStrategy() {
        if (this.isWebdriverStepClass()) {
            return ConstructionStrategy.STEP_LIBRARY_WITH_WEBDRIVER;
        }
        if (this.hasAConstructorWithParameters()) {
            return ConstructionStrategy.CONSTRUCTOR_WITH_PARAMETERS;
        }
        if (this.hasAPagesField()) {
            return ConstructionStrategy.STEP_LIBRARY_WITH_PAGES;
        }
        if (this.hasAnInnerClassConstructor()) {
            return ConstructionStrategy.INNER_CLASS_CONSTRUCTOR;
        }
        return ConstructionStrategy.DEFAULT_CONSTRUCTOR;
    }

    public boolean hasDefaultConstructor() {
        return this.hasAConstructorWithoutParameters();
    }

    private <T> boolean isWebdriverStepClass() {
        return this.isAScenarioStepClass() || this.hasAPagesConstructor();
    }

    private <T> boolean hasAPagesConstructor() {
        return Stream.of(this.declaredConstructors).anyMatch(constructor -> constructor.getParameterTypes().length == 1 && constructor.getParameterTypes()[0] == Pages.class);
    }

    private <T> boolean hasAConstructorWithParameters() {
        return Stream.of(this.declaredConstructors).anyMatch(constructor -> constructor.getParameterTypes().length > 0 && !this.isInnerClassConstructor((Constructor<?>)constructor));
    }

    private <T> boolean hasAnInnerClassConstructor() {
        return Stream.of(this.declaredConstructors).anyMatch(constructor -> this.isInnerClassConstructor((Constructor<?>)constructor));
    }

    private boolean isInnerClassConstructor(Constructor<?> constructor) {
        return constructor.getParameters().length == 1 && constructor.getParameters()[0].getType() == this.stepLibraryClass.getEnclosingClass();
    }

    private <T> boolean hasAConstructorWithoutParameters() {
        return Stream.of(this.declaredConstructors).anyMatch(constructor -> constructor.getParameterTypes().length == 0);
    }

    private <T> boolean hasAPagesField() {
        Set fields = Fields.of(this.stepLibraryClass).allFields();
        return fields.stream().anyMatch(field -> field.getType() == Pages.class);
    }

    private <T> boolean isAScenarioStepClass() {
        return ScenarioSteps.class.isAssignableFrom(this.stepLibraryClass);
    }
}

