/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.plugin;

import com.google.common.collect.Lists;
import io.cucumber.core.plugin.ConfigureDriverFromTags;
import io.cucumber.core.plugin.FeatureFileLoader;
import io.cucumber.core.plugin.FeaturePathFormatter;
import io.cucumber.core.plugin.FeatureTracker;
import io.cucumber.core.plugin.LineFilters;
import io.cucumber.core.plugin.ScenarioContextParallel;
import io.cucumber.core.plugin.ScenarioTagProcessor;
import io.cucumber.core.plugin.SerenityReporter;
import io.cucumber.core.plugin.TaggedScenario;
import io.cucumber.core.plugin.TestSourcesModel;
import io.cucumber.messages.types.Background;
import io.cucumber.messages.types.Examples;
import io.cucumber.messages.types.Feature;
import io.cucumber.messages.types.FeatureChild;
import io.cucumber.messages.types.Scenario;
import io.cucumber.messages.types.Step;
import io.cucumber.messages.types.TableCell;
import io.cucumber.messages.types.TableRow;
import io.cucumber.messages.types.Tag;
import io.cucumber.plugin.ConcurrentEventListener;
import io.cucumber.plugin.Plugin;
import io.cucumber.plugin.event.DataTableArgument;
import io.cucumber.plugin.event.EventHandler;
import io.cucumber.plugin.event.EventPublisher;
import io.cucumber.plugin.event.HookTestStep;
import io.cucumber.plugin.event.PickleStepTestStep;
import io.cucumber.plugin.event.Result;
import io.cucumber.plugin.event.Status;
import io.cucumber.plugin.event.StepArgument;
import io.cucumber.plugin.event.TestCase;
import io.cucumber.plugin.event.TestCaseFinished;
import io.cucumber.plugin.event.TestCaseStarted;
import io.cucumber.plugin.event.TestRunFinished;
import io.cucumber.plugin.event.TestRunStarted;
import io.cucumber.plugin.event.TestSourceRead;
import io.cucumber.plugin.event.TestStep;
import io.cucumber.plugin.event.TestStepFinished;
import io.cucumber.plugin.event.TestStepStarted;
import io.cucumber.plugin.event.WriteEvent;
import io.cucumber.tagexpressions.Expression;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.stream.Collectors;
import net.serenitybdd.core.Serenity;
import net.serenitybdd.core.SerenityListeners;
import net.serenitybdd.core.SerenityReports;
import net.serenitybdd.core.di.SerenityInfrastructure;
import net.serenitybdd.core.webdriver.configuration.RestartBrowserForEach;
import net.serenitybdd.cucumber.CucumberWithSerenity;
import net.serenitybdd.cucumber.formatting.ScenarioOutlineDescription;
import net.serenitybdd.cucumber.util.PathUtils;
import net.serenitybdd.cucumber.util.StepDefinitionAnnotationReader;
import net.thucydides.core.model.DataTable;
import net.thucydides.core.model.Rule;
import net.thucydides.core.model.Story;
import net.thucydides.core.model.TakeScreenshots;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.model.TestResult;
import net.thucydides.core.model.TestTag;
import net.thucydides.core.model.screenshots.StepDefinitionAnnotations;
import net.thucydides.core.reports.ReportService;
import net.thucydides.core.requirements.FeatureFilePath;
import net.thucydides.core.steps.BaseStepListener;
import net.thucydides.core.steps.ExecutedStepDescription;
import net.thucydides.core.steps.StepEventBus;
import net.thucydides.core.steps.TestSourceType;
import net.thucydides.core.steps.events.AddDescriptionToCurrentTestEvent;
import net.thucydides.core.steps.events.AddIssuesToCurrentStoryEvent;
import net.thucydides.core.steps.events.AddIssuesToCurrentTestEvent;
import net.thucydides.core.steps.events.AddNewExamplesFromEvent;
import net.thucydides.core.steps.events.AddTagsToCurrentTestEvent;
import net.thucydides.core.steps.events.ClearStepFailuresEvent;
import net.thucydides.core.steps.events.ExampleFinishedEvent;
import net.thucydides.core.steps.events.ExampleStartedEvent;
import net.thucydides.core.steps.events.OverrideResultToEvent;
import net.thucydides.core.steps.events.RecordStepResultEvent;
import net.thucydides.core.steps.events.SetBackgroundDescriptionEvent;
import net.thucydides.core.steps.events.SetBackgroundTitleEvent;
import net.thucydides.core.steps.events.SetRuleEvent;
import net.thucydides.core.steps.events.SetTestIgnoredEvent;
import net.thucydides.core.steps.events.SetTestManualEvent;
import net.thucydides.core.steps.events.SetTestPendingEvent;
import net.thucydides.core.steps.events.SetTestSkippedEvent;
import net.thucydides.core.steps.events.SetTestSourceEvent;
import net.thucydides.core.steps.events.StepEventBusEvent;
import net.thucydides.core.steps.events.StepStartedEvent;
import net.thucydides.core.steps.events.TestFailedEvent;
import net.thucydides.core.steps.events.TestFinishedEvent;
import net.thucydides.core.steps.events.TestStartedEvent;
import net.thucydides.core.steps.events.UpdateCurrentStepTitleEvent;
import net.thucydides.core.steps.events.UpdateExampleLineNumberEvent;
import net.thucydides.core.steps.events.UseExamplesFromEvent;
import net.thucydides.core.steps.events.UseScenarioOutlineEvent;
import net.thucydides.core.steps.session.TestSession;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.util.Inflector;
import net.thucydides.core.webdriver.Configuration;
import net.thucydides.core.webdriver.SerenityWebdriverManager;
import net.thucydides.core.webdriver.ThucydidesWebDriverSupport;
import net.thucydides.core.webdriver.WebDriverFacade;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.WebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerenityReporterParallel
implements Plugin,
ConcurrentEventListener {
    private static final String OPEN_PARAM_CHAR = "\uff5f";
    private static final String CLOSE_PARAM_CHAR = "\uff60";
    private static final String SCENARIO_OUTLINE_NOT_KNOWN_YET = "";
    private Configuration systemConfiguration;
    private static final String FEATURES_ROOT_PATH = "/features/";
    private static final String FEATURES_CLASSPATH_ROOT_PATH = ":features/";
    private FeatureFileLoader featureLoader = new FeatureFileLoader();
    private LineFilters lineFilters;
    private static final Logger LOGGER = LoggerFactory.getLogger(SerenityReporter.class);
    private final Set<URI> contextURISet = new CopyOnWriteArraySet<URI>();
    private final Map<URI, ScenarioContextParallel> localContexts = Collections.synchronizedMap(new HashMap());
    private FeaturePathFormatter featurePathFormatter = new FeaturePathFormatter();
    private EventHandler<TestSourceRead> testSourceReadHandler = this::handleTestSourceRead;
    private EventHandler<TestCaseStarted> caseStartedHandler = this::handleTestCaseStarted;
    private EventHandler<TestCaseFinished> caseFinishedHandler = this::handleTestCaseFinished;
    private EventHandler<TestStepStarted> stepStartedHandler = this::handleTestStepStarted;
    private EventHandler<TestStepFinished> stepFinishedHandler = this::handleTestStepFinished;
    private EventHandler<TestRunStarted> runStartedHandler = this::handleTestRunStarted;
    private EventHandler<TestRunFinished> runFinishedHandler = this::handleTestRunFinished;
    private EventHandler<WriteEvent> writeEventHandler = this::handleWrite;
    private static Map<UUID, TestResult> MANUAL_TEST_RESULTS_CACHE = new HashMap<UUID, TestResult>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ScenarioContextParallel getContext(URI featureURI) {
        Map<URI, ScenarioContextParallel> map = this.localContexts;
        synchronized (map) {
            return this.localContexts.computeIfAbsent(featureURI, uri -> new ScenarioContextParallel(featureURI));
        }
    }

    public SerenityReporterParallel() {
        this.systemConfiguration = SerenityInfrastructure.getConfiguration();
    }

    public SerenityReporterParallel(Configuration systemConfiguration) {
        this.systemConfiguration = systemConfiguration;
    }

    private StepEventBus getStepEventBus(URI featurePath) {
        URI prefixedPath = this.featurePathFormatter.featurePathWithPrefixIfNecessary(featurePath);
        return StepEventBus.eventBusFor((Object)prefixedPath);
    }

    private void setStepEventBus(URI featurePath) {
        URI prefixedPath = this.featurePathFormatter.featurePathWithPrefixIfNecessary(featurePath);
        StepEventBus.setCurrentBusToEventBusFor((Object)prefixedPath);
    }

    private void initialiseListenersFor(URI featurePath) {
        StepEventBus stepEventBus = this.getStepEventBus(featurePath);
        if (stepEventBus.isBaseStepListenerRegistered()) {
            return;
        }
        SerenityListeners listeners = new SerenityListeners(stepEventBus, this.systemConfiguration);
        this.getContext(featurePath).setStepEventBus(stepEventBus);
        this.getContext(featurePath).addBaseStepListener(listeners.getBaseStepListener());
    }

    private void handleTestRunStarted(TestRunStarted event) {
        LOGGER.debug("SRP:handleTestRunStarted {} ", (Object)Thread.currentThread());
    }

    public void setEventPublisher(EventPublisher publisher) {
        publisher.registerHandlerFor(TestSourceRead.class, this.testSourceReadHandler);
        publisher.registerHandlerFor(TestRunStarted.class, this.runStartedHandler);
        publisher.registerHandlerFor(TestRunFinished.class, this.runFinishedHandler);
        publisher.registerHandlerFor(TestCaseStarted.class, this.caseStartedHandler);
        publisher.registerHandlerFor(TestCaseFinished.class, this.caseFinishedHandler);
        publisher.registerHandlerFor(TestStepStarted.class, this.stepStartedHandler);
        publisher.registerHandlerFor(TestStepFinished.class, this.stepFinishedHandler);
        publisher.registerHandlerFor(WriteEvent.class, this.writeEventHandler);
    }

    private void handleTestSourceRead(TestSourceRead event) {
        LOGGER.debug("SRP:handleTestSourceRead {}", (Object)Thread.currentThread());
        this.featureLoader.addTestSourceReadEvent(event);
        URI featurePath = event.getUri();
        this.featureFrom(featurePath).ifPresent(feature -> {
            this.getContext(featurePath).setFeatureTags(feature.getTags());
            this.resetEventBusFor(featurePath);
            this.initialiseListenersFor(featurePath);
            this.configureDriver((Feature)feature, featurePath);
            Story userStory = this.userStoryFrom((Feature)feature, this.relativeUriFrom(event.getUri()));
            this.getContext(featurePath).stepEventBus().testSuiteStarted(userStory);
        });
    }

    private void resetEventBusFor(URI featurePath) {
        StepEventBus.clearEventBusFor((Object)featurePath);
    }

    private String relativeUriFrom(URI fullPathUri) {
        String pathURIAsString;
        boolean useDecodedURI = this.systemConfiguration.getEnvironmentVariables().getPropertyAsBoolean("use.decoded.url", false);
        if (useDecodedURI) {
            try {
                pathURIAsString = URLDecoder.decode(fullPathUri.toString(), StandardCharsets.UTF_8.name());
            }
            catch (UnsupportedEncodingException e) {
                pathURIAsString = fullPathUri.toString();
            }
        } else {
            pathURIAsString = fullPathUri.toString();
        }
        if (pathURIAsString.contains(FEATURES_ROOT_PATH)) {
            return StringUtils.substringAfterLast((String)pathURIAsString, (String)FEATURES_ROOT_PATH);
        }
        return pathURIAsString;
    }

    private Optional<Feature> featureFrom(URI featureFileUri) {
        LOGGER.debug("Running feature from " + featureFileUri.toString());
        if (!featureFileUri.toString().contains(FEATURES_ROOT_PATH) && !featureFileUri.toString().contains(FEATURES_CLASSPATH_ROOT_PATH)) {
            LOGGER.warn("Feature from " + featureFileUri + " is not under the 'features' directory. Requirements report will not be correctly generated!");
        }
        String defaultFeatureId = PathUtils.getAsFile(featureFileUri).getName().replace(".feature", SCENARIO_OUTLINE_NOT_KNOWN_YET);
        String defaultFeatureName = Inflector.getInstance().humanize(defaultFeatureId, new String[0]);
        this.parseGherkinIn(featureFileUri);
        if (StringUtils.isEmpty((CharSequence)this.featureLoader.getFeatureName(featureFileUri))) {
            return Optional.empty();
        }
        Feature feature = this.featureLoader.getFeature(featureFileUri);
        if (feature.getName().isEmpty()) {
            feature = this.featureLoader.featureWithDefaultName(feature, defaultFeatureName);
        }
        return Optional.of(feature);
    }

    private void parseGherkinIn(URI featureFileUri) {
        try {
            this.featureLoader.getFeature(featureFileUri);
        }
        catch (Throwable ignoreParsingErrors) {
            LOGGER.warn("Could not parse the Gherkin in feature file " + featureFileUri + ": file ignored");
        }
    }

    private Story userStoryFrom(Feature feature, String featureFileUri) {
        String relativePath = new FeatureFilePath(this.systemConfiguration.getEnvironmentVariables()).relativePathFor(featureFileUri);
        String id = relativePath.replace(".feature", SCENARIO_OUTLINE_NOT_KNOWN_YET);
        Story userStory = Story.withIdAndPath((String)id, (String)feature.getName(), (String)featureFileUri).asFeature();
        if (!StringUtils.isEmpty((CharSequence)feature.getDescription())) {
            userStory = userStory.withNarrative(feature.getDescription());
        }
        return userStory;
    }

    private void handleTestCaseStarted(TestCaseStarted event) {
        try {
            io.cucumber.messages.types.Rule rule;
            TestCase testCase = event.getTestCase();
            LOGGER.debug("SRP:handleTestCaseStarted {} {} {} at line {}", new Object[]{testCase.getUri(), Thread.currentThread(), testCase.getId(), testCase.getLocation().getLine()});
            TestSession.startSession((String)testCase.getId().toString(), (StepEventBus)this.getStepEventBus(event.getTestCase().getUri()));
            URI featurePath = testCase.getUri();
            this.contextURISet.add(featurePath);
            if (FeatureTracker.isNewFeature(event)) {
                if (RestartBrowserForEach.configuredIn((EnvironmentVariables)this.systemConfiguration.getEnvironmentVariables()).restartBrowserForANew(RestartBrowserForEach.FEATURE)) {
                    ThucydidesWebDriverSupport.closeCurrentDrivers();
                }
                FeatureTracker.startNewFeature(event);
            }
            ConfigureDriverFromTags.forTags(event.getTestCase().getTags());
            String scenarioName = event.getTestCase().getName();
            TestSourcesModel.AstNode astNode = this.featureLoader.getAstNode(featurePath, event.getTestCase().getLocation().getLine());
            Optional<Feature> currentFeature = this.featureFrom(featurePath);
            String scenarioId = SCENARIO_OUTLINE_NOT_KNOWN_YET;
            ScenarioContextParallel context = this.getContext(featurePath);
            if (astNode != null && currentFeature.isPresent()) {
                boolean newScenario;
                Scenario currentScenarioDefinition = TestSourcesModel.getScenarioDefinition((TestSourcesModel.AstNode)astNode);
                scenarioId = this.scenarioIdFrom(currentFeature.get().getName(), TestSourcesModel.convertToId((String)currentScenarioDefinition.getName()));
                context.setCurrentScenarioDefinitionFrom(scenarioId, astNode);
                boolean bl = newScenario = !scenarioId.equals(context.getCurrentScenario(scenarioId));
                if (newScenario) {
                    this.configureDriver(currentFeature.get(), event.getTestCase().getUri());
                    if (currentScenarioDefinition.getExamples().size() > 0) {
                        context.startNewExample(scenarioId);
                        LOGGER.debug("SRP:startNewExample {} {} {} at line {} ", new Object[]{event.getTestCase().getUri(), Thread.currentThread(), event.getTestCase().getId(), event.getTestCase().getLocation().getLine()});
                        this.handleExamples(scenarioId, featurePath, currentFeature.get(), context.currentScenarioOutline(scenarioId).getTags(), context.currentScenarioOutline(scenarioId).getName(), context.currentScenarioOutline(scenarioId).getExamples());
                    }
                    this.startOfScenarioLifeCycle(scenarioId, featurePath, event.getTestCase(), currentFeature.get(), scenarioName, context.getCurrentScenarioDefinition(scenarioId), event.getTestCase().getLocation().getLine());
                    context.setCurrentScenario(scenarioId, scenarioId);
                } else if (context.isAScenarioOutline(scenarioId)) {
                    this.startProcessingExampleLine(scenarioId, featurePath, event.getTestCase(), Long.valueOf(event.getTestCase().getLocation().getLine()), scenarioName);
                }
                TestSourcesModel.getBackgroundForTestCase((TestSourcesModel.AstNode)astNode).ifPresent(background -> this.handleBackground(featurePath, event.getTestCase(), (Background)background));
                if (astNode.node instanceof Scenario) {
                    List tags = ((Scenario)astNode.node).getTags();
                    TestResult annotatedTestResult = ScenarioTagProcessor.processScenarioTags(tags, event.getTestCase().getUri());
                    if (TaggedScenario.isManual(tags)) {
                        MANUAL_TEST_RESULTS_CACHE.put(testCase.getId(), annotatedTestResult);
                    }
                }
            }
            if ((rule = this.getRuleForTestCase(astNode)) != null) {
                context.addStepEventBusEvent((StepEventBusEvent)new SetRuleEvent(Rule.from((io.cucumber.messages.types.Rule)rule)));
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw t;
        }
    }

    private io.cucumber.messages.types.Rule getRuleForTestCase(TestSourcesModel.AstNode astNode) {
        Feature feature = this.getFeatureForTestCase(astNode);
        Scenario existingScenario = TestSourcesModel.getScenarioDefinition((TestSourcesModel.AstNode)astNode);
        List childrenList = feature.getChildren();
        for (FeatureChild featureChild : childrenList) {
            if (!this.scenarioIsIncludedInARule(existingScenario, featureChild)) continue;
            return (io.cucumber.messages.types.Rule)featureChild.getRule().get();
        }
        return null;
    }

    private boolean scenarioIsIncludedInARule(Scenario existingScenario, FeatureChild featureChild) {
        return featureChild.getRule() != null && featureChild.getRule().isPresent() && ((io.cucumber.messages.types.Rule)featureChild.getRule().get()).getChildren().stream().filter(rc -> rc.getScenario().isPresent()).map(rc -> (Scenario)rc.getScenario().get()).collect(Collectors.toList()).contains(existingScenario);
    }

    private Feature getFeatureForTestCase(TestSourcesModel.AstNode astNode) {
        while (astNode.parent != null) {
            astNode = astNode.parent;
        }
        return (Feature)astNode.node;
    }

    private void handleTestCaseFinished(TestCaseFinished event) {
        Status eventStatus;
        LOGGER.debug("SRP:handleTestCaseFinished  " + event.getTestCase().getUri() + " " + Thread.currentThread() + " " + event.getTestCase().getId() + " at line " + event.getTestCase().getLocation().getLine());
        URI featurePath = event.getTestCase().getUri();
        Optional<Feature> currentFeature = this.featureFrom(featurePath);
        TestSourcesModel.AstNode astNode = this.featureLoader.getAstNode(featurePath, event.getTestCase().getLocation().getLine());
        Scenario currentScenarioDefinition = TestSourcesModel.getScenarioDefinition((TestSourcesModel.AstNode)astNode);
        String scenarioId = this.scenarioIdFrom(currentFeature.get().getName(), TestSourcesModel.convertToId((String)currentScenarioDefinition.getName()));
        if (this.getContext(featurePath).examplesAreRunning(scenarioId)) {
            this.handleResult(scenarioId, featurePath, event.getTestCase(), event.getResult());
            this.finishProcessingExampleLine(scenarioId, featurePath, event.getTestCase());
        }
        if (Status.FAILED.equals((Object)(eventStatus = this.eventStatusFor(event))) && this.noAnnotatedResultIdDefinedFor(event)) {
            this.getContext(featurePath).addStepEventBusEvent((StepEventBusEvent)new TestFailedEvent(scenarioId, event.getResult().getError()));
        } else {
            this.getContext(featurePath).addStepEventBusEvent((StepEventBusEvent)new TestFinishedEvent(scenarioId, this.getContext(featurePath).examplesAreRunning(scenarioId)));
        }
        this.getContext(featurePath).storeAllStepEventBusEventsForLine(event.getTestCase().getLocation().getLine(), event.getTestCase());
        this.getContext(featurePath).clearStepQueue(event.getTestCase());
        this.getContext(featurePath).stepEventBus().clear();
    }

    private Status eventStatusFor(TestCaseFinished event) {
        if (MANUAL_TEST_RESULTS_CACHE.containsKey(event.getTestCase().getId())) {
            switch (MANUAL_TEST_RESULTS_CACHE.get(event.getTestCase().getId())) {
                case SUCCESS: {
                    return Status.PASSED;
                }
                case ABORTED: 
                case FAILURE: 
                case COMPROMISED: 
                case ERROR: {
                    return Status.FAILED;
                }
                case PENDING: {
                    return Status.PENDING;
                }
                case SKIPPED: 
                case IGNORED: {
                    return Status.SKIPPED;
                }
            }
            return Status.UNDEFINED;
        }
        return event.getResult().getStatus();
    }

    private boolean noAnnotatedResultIdDefinedFor(TestCaseFinished event) {
        BaseStepListener baseStepListener = this.getStepEventBus(event.getTestCase().getUri()).getBaseStepListener();
        return baseStepListener.getTestOutcomes().isEmpty() || this.latestOf(baseStepListener.getTestOutcomes()).getAnnotatedResult() == null;
    }

    private TestOutcome latestOf(List<TestOutcome> testOutcomes) {
        return testOutcomes.get(testOutcomes.size() - 1);
    }

    private void handleTestStepStarted(TestStepStarted event) {
        URI featurePath = event.getTestCase().getUri();
        TestSourcesModel.AstNode mainAstNode = this.featureLoader.getAstNode(featurePath, event.getTestCase().getLocation().getLine());
        Scenario currentScenarioDefinition = TestSourcesModel.getScenarioDefinition((TestSourcesModel.AstNode)mainAstNode);
        Optional<Feature> currentFeature = this.featureFrom(featurePath);
        String scenarioId = this.scenarioIdFrom(currentFeature.get().getName(), TestSourcesModel.convertToId((String)currentScenarioDefinition.getName()));
        LOGGER.debug("SRP:handleTestStepStarted  " + event.getTestCase().getUri() + " " + Thread.currentThread() + " " + event.getTestCase().getId() + " at line " + event.getTestCase().getLocation().getLine());
        StepDefinitionAnnotations.setScreenshotPreferencesTo((TakeScreenshots)StepDefinitionAnnotationReader.withScreenshotLevel(this.systemConfiguration.getScreenshotLevel().orElse(TakeScreenshots.UNDEFINED)).forStepDefinition(event.getTestStep().getCodeLocation()).getScreenshotPreferences());
        if (!(event.getTestStep() instanceof HookTestStep) && event.getTestStep() instanceof PickleStepTestStep) {
            PickleStepTestStep pickleTestStep = (PickleStepTestStep)event.getTestStep();
            TestSourcesModel.AstNode astNode = this.featureLoader.getAstNode(event.getTestCase().getUri(), pickleTestStep.getStepLine());
            if (astNode != null) {
                Step step = (Step)astNode.node;
                if (!this.getContext(featurePath).isAddingScenarioOutlineSteps(scenarioId)) {
                    this.getContext(featurePath).queueStep(event.getTestCase(), step);
                    this.getContext(featurePath).queueTestStep(event.getTestCase(), event.getTestStep());
                }
                if (this.getContext(featurePath).isAScenarioOutline(scenarioId)) {
                    int lineNumber = event.getTestCase().getLocation().getLine();
                    this.getContext(featurePath).addStepEventBusEvent((StepEventBusEvent)new UpdateExampleLineNumberEvent(lineNumber));
                }
                Step currentStep = this.getContext(featurePath).getCurrentStep(event.getTestCase());
                String stepTitle = SerenityReporterParallel.stepTitleFrom(currentStep, (TestStep)pickleTestStep);
                this.getContext(featurePath).addStepEventBusEvent((StepEventBusEvent)new StepStartedEvent(ExecutedStepDescription.withTitle((String)stepTitle)));
                this.getContext(featurePath).addStepEventBusEvent((StepEventBusEvent)new UpdateCurrentStepTitleEvent(this.normalized(stepTitle)));
            }
        }
    }

    public void handleWrite(WriteEvent event) {
        LOGGER.debug("SRP:handleWrite  " + event.getTestCase().getUri());
        URI featurePath = event.getTestCase().getUri();
        this.getContext(featurePath).stepEventBus().stepStarted(ExecutedStepDescription.withTitle((String)event.getText()));
        this.getContext(featurePath).stepEventBus().stepFinished();
    }

    private void handleTestStepFinished(TestStepFinished event) {
        LOGGER.debug("SRP:handleTestStepFinished  " + event.getTestCase().getUri() + " " + Thread.currentThread() + " " + event.getTestCase().getId() + " at line " + event.getTestCase().getLocation().getLine());
        if (!(event.getTestStep() instanceof HookTestStep)) {
            URI featurePath = event.getTestCase().getUri();
            TestSourcesModel.AstNode astNode = this.featureLoader.getAstNode(featurePath, event.getTestCase().getLocation().getLine());
            Optional<Feature> currentFeature = this.featureFrom(featurePath);
            String scenarioId = SCENARIO_OUTLINE_NOT_KNOWN_YET;
            if (astNode != null && currentFeature.isPresent()) {
                Scenario currentScenarioDefinition = TestSourcesModel.getScenarioDefinition((TestSourcesModel.AstNode)astNode);
                scenarioId = this.scenarioIdFrom(currentFeature.get().getName(), TestSourcesModel.convertToId((String)currentScenarioDefinition.getName()));
                this.handleResult(scenarioId, event.getTestCase().getUri(), event.getTestCase(), event.getResult());
            }
            StepDefinitionAnnotations.clear();
        }
    }

    private void handleTestRunFinished(TestRunFinished event) {
        LOGGER.debug("SRP:handleTestRunFinished " + Thread.currentThread() + " " + this.contextURISet);
        try {
            this.contextURISet.forEach(featurePath -> this.getContext((URI)featurePath).playAllTestEvents());
        }
        catch (Throwable th) {
            th.printStackTrace();
        }
        this.generateReports();
        this.assureTestSuiteFinished();
    }

    private ReportService getReportService() {
        return SerenityReports.getReportService((Configuration)this.systemConfiguration);
    }

    private void configureDriver(Feature feature, URI featurePath) {
        this.getStepEventBus(featurePath).setUniqueSession(this.systemConfiguration.shouldUseAUniqueBrowser());
        List<String> tags = this.getTagNamesFrom(feature.getTags());
        String requestedDriver = this.getDriverFrom(tags);
        String requestedDriverOptions = this.getDriverOptionsFrom(tags);
        if (StringUtils.isNotEmpty((CharSequence)requestedDriver)) {
            ThucydidesWebDriverSupport.useDefaultDriver((String)requestedDriver);
            ThucydidesWebDriverSupport.useDriverOptions((String)requestedDriverOptions);
        }
    }

    private List<String> getTagNamesFrom(List<Tag> tags) {
        ArrayList<String> tagNames = new ArrayList<String>();
        for (Tag tag : tags) {
            tagNames.add(tag.getName());
        }
        return tagNames;
    }

    private String getDriverFrom(List<String> tags) {
        String requestedDriver = null;
        for (String tag : tags) {
            if (!tag.startsWith("@driver:")) continue;
            requestedDriver = tag.substring(8);
        }
        return requestedDriver;
    }

    private String getDriverOptionsFrom(List<String> tags) {
        String requestedDriver = null;
        for (String tag : tags) {
            if (!tag.startsWith("@driver-options:")) continue;
            requestedDriver = tag.substring(16);
        }
        return requestedDriver;
    }

    private void handleExamples(String mainScenarioId, URI featurePath, Feature currentFeature, List<Tag> scenarioOutlineTags, String id, List<Examples> examplesList) {
        this.lineFilters = LineFilters.forCurrentContext();
        String featureName = currentFeature.getName();
        List currentFeatureTags = currentFeature.getTags();
        this.getContext(featurePath).doneAddingScenarioOutlineSteps(mainScenarioId);
        this.initializeExamples(mainScenarioId, featurePath);
        for (Examples examples : examplesList) {
            if (!this.examplesAreNotExcludedByTags(examples, scenarioOutlineTags, currentFeatureTags) || !this.lineFilters.examplesAreNotExcluded(examples, featurePath)) continue;
            List<TableRow> examplesTableRows = examples.getTableBody().stream().filter(tableRow -> this.lineFilters.tableRowIsNotExcludedBy((TableRow)tableRow, featurePath)).collect(Collectors.toList());
            List<String> headers = this.getHeadersFrom((TableRow)examples.getTableHeader().get());
            List<Map<String, String>> rows = this.getValuesFrom(examplesTableRows, headers);
            HashMap<Integer, Long> lineNumbersOfEachRow = new HashMap<Integer, Long>();
            for (int i = 0; i < examplesTableRows.size(); ++i) {
                TableRow tableRow2 = examplesTableRows.get(i);
                lineNumbersOfEachRow.put(i, tableRow2.getLocation().getLine());
                this.addRow(mainScenarioId, featurePath, headers, tableRow2);
                if (examples.getTags() == null) continue;
                this.exampleTags(featurePath).put(examplesTableRows.get(i).getLocation().getLine(), examples.getTags());
            }
            String scenarioId = this.scenarioIdFrom(featureName, id);
            LOGGER.debug("SRP:handleExamples " + Thread.currentThread() + " scenarioId " + scenarioId + " mainscenarioId " + mainScenarioId);
            boolean newScenario = !this.getContext(featurePath).hasScenarioId(scenarioId);
            LOGGER.debug("SRP:newScenario " + newScenario);
            String exampleTableName = this.trim(examples.getName());
            String exampleTableDescription = this.trim(examples.getDescription());
            if (newScenario) {
                this.getContext(featurePath).setTable(mainScenarioId, this.dataTableFrom(SCENARIO_OUTLINE_NOT_KNOWN_YET, headers, rows, exampleTableName, exampleTableDescription, lineNumbersOfEachRow));
            } else {
                this.getContext(featurePath).addTableRows(mainScenarioId, headers, rows, exampleTableName, exampleTableDescription, lineNumbersOfEachRow);
            }
            this.getContext(featurePath).addTableTags(mainScenarioId, this.tagsIn(examples));
            this.getContext(featurePath).addCurrentScenarioId(scenarioId);
        }
    }

    private List<TestTag> tagsIn(Examples examples) {
        return examples.getTags().stream().map(tag -> TestTag.withValue((String)tag.getName().substring(1))).collect(Collectors.toList());
    }

    private boolean examplesAreNotExcludedByTags(Examples examples, List<Tag> scenarioOutlineTags, List<Tag> currentFeatureTags) {
        if (this.testRunHasFilterTags()) {
            return this.examplesMatchFilter(examples, scenarioOutlineTags, currentFeatureTags);
        }
        return true;
    }

    private boolean examplesMatchFilter(Examples examples, List<Tag> scenarioOutlineTags, List<Tag> currentFeatureTags) {
        List<Tag> allExampleTags = this.getExampleAllTags(examples, scenarioOutlineTags, currentFeatureTags);
        List allTagsForAnExampleScenario = allExampleTags.stream().map(Tag::getName).collect(Collectors.toList());
        Expression tagValuesFromCucumberOptions = this.getCucumberRuntimeTags().get(0);
        return tagValuesFromCucumberOptions.evaluate(allTagsForAnExampleScenario);
    }

    private boolean testRunHasFilterTags() {
        List<Expression> tagFilters = this.getCucumberRuntimeTags();
        return tagFilters != null && tagFilters.size() > 0;
    }

    private List<Expression> getCucumberRuntimeTags() {
        if (CucumberWithSerenity.currentRuntimeOptions() == null) {
            return new ArrayList<Expression>();
        }
        return CucumberWithSerenity.currentRuntimeOptions().getTagExpressions();
    }

    private List<Tag> getExampleAllTags(Examples examples, List<Tag> scenarioOutlineTags, List<Tag> currentFeatureTags) {
        List exampleTags = examples.getTags();
        ArrayList<Tag> allTags = new ArrayList<Tag>();
        if (exampleTags != null) {
            allTags.addAll(exampleTags);
        }
        if (scenarioOutlineTags != null) {
            allTags.addAll(scenarioOutlineTags);
        }
        if (currentFeatureTags != null) {
            allTags.addAll(currentFeatureTags);
        }
        return allTags;
    }

    private List<String> getHeadersFrom(TableRow headerRow) {
        return headerRow.getCells().stream().map(TableCell::getValue).collect(Collectors.toList());
    }

    private List<Map<String, String>> getValuesFrom(List<TableRow> examplesTableRows, List<String> headers) {
        ArrayList<Map<String, String>> rows = new ArrayList<Map<String, String>>();
        for (int row = 0; row < examplesTableRows.size(); ++row) {
            HashMap<String, String> rowValues = new HashMap<String, String>();
            int column = 0;
            List cells = examplesTableRows.get(row).getCells().stream().map(TableCell::getValue).collect(Collectors.toList());
            for (String cellValue : cells) {
                String columnName = headers.get(column++);
                rowValues.put(columnName, cellValue);
            }
            rows.add(rowValues);
        }
        return rows;
    }

    private void addRow(String scenarioId, URI featurePath, List<String> headers, TableRow currentTableRow) {
        LinkedHashMap row = new LinkedHashMap();
        for (int j = 0; j < headers.size(); ++j) {
            List cells = currentTableRow.getCells().stream().map(TableCell::getValue).collect(Collectors.toList());
            row.put(headers.get(j), cells.get(j));
        }
        this.exampleRows(scenarioId, featurePath).put(currentTableRow.getLocation().getLine(), row);
    }

    private String scenarioIdFrom(String featureId, String scenarioIdOrExampleId) {
        return featureId != null && scenarioIdOrExampleId != null ? String.format("%s;%s", featureId, scenarioIdOrExampleId) : SCENARIO_OUTLINE_NOT_KNOWN_YET;
    }

    private void initializeExamples(String scenarioId, URI featurePath) {
        this.getContext(featurePath).setExamplesRunning(scenarioId, true);
    }

    private Map<Long, Map<String, String>> exampleRows(String scenarioId, URI featurePath) {
        if (this.getContext(featurePath).getExampleRows(scenarioId) == null) {
            this.getContext(featurePath).setExampleRows(scenarioId, Collections.synchronizedMap(new HashMap()));
        }
        return this.getContext(featurePath).getExampleRows(scenarioId);
    }

    private Map<Long, List<Tag>> exampleTags(URI featurePath) {
        if (this.getContext(featurePath).getExampleTags() == null) {
            this.getContext(featurePath).setExampleTags(Collections.synchronizedMap(new HashMap()));
        }
        return this.getContext(featurePath).getExampleTags();
    }

    private DataTable dataTableFrom(String scenarioOutline, List<String> headers, List<Map<String, String>> rows, String name, String description, Map<Integer, Long> lineNumbersOfEachRow) {
        return DataTable.withHeaders(headers).andScenarioOutline(scenarioOutline).andMappedRows(rows, lineNumbersOfEachRow).andTitle(name).andDescription(description).build();
    }

    private DataTable addTableRowsTo(DataTable table, List<String> headers, List<Map<String, String>> rows, String name, String description) {
        table.startNewDataSet(name, description);
        for (Map<String, String> row : rows) {
            table.appendRow(this.rowValuesFrom(headers, row));
        }
        return table;
    }

    private List<String> rowValuesFrom(List<String> headers, Map<String, String> row) {
        return headers.stream().map(header -> (String)row.get(header)).collect(Collectors.toList());
    }

    private void startOfScenarioLifeCycle(String mainScenarioId, URI featurePath, TestCase testCase, Feature feature, String scenarioName, Scenario scenario, Integer currentLine) {
        ScenarioContextParallel context = this.getContext(featurePath);
        boolean newScenario = !this.scenarioIdFrom(TestSourcesModel.convertToId((String)feature.getName()), TestSourcesModel.convertToId((String)scenario.getName())).equals(context.getCurrentScenario(mainScenarioId));
        String currentScenarioId = this.scenarioIdFrom(TestSourcesModel.convertToId((String)feature.getName()), TestSourcesModel.convertToId((String)scenario.getName()));
        context.setCurrentScenario(mainScenarioId, currentScenarioId);
        if (context.examplesAreRunning(mainScenarioId)) {
            if (newScenario) {
                this.startScenario(mainScenarioId, featurePath, testCase, feature, scenario, scenario.getName());
                context.addHighPriorityStepEventBusEvent(mainScenarioId, (StepEventBusEvent)new UseExamplesFromEvent(context.getTable(mainScenarioId)));
                context.addHighPriorityStepEventBusEvent(mainScenarioId, (StepEventBusEvent)new UseScenarioOutlineEvent(ScenarioOutlineDescription.from(scenario).getDescription()));
            } else {
                context.addStepEventBusEvent((StepEventBusEvent)new AddNewExamplesFromEvent(context.getTable(mainScenarioId)));
            }
            this.startProcessingExampleLine(mainScenarioId, featurePath, testCase, (long)currentLine, scenarioName);
        } else {
            this.startScenario(mainScenarioId, featurePath, testCase, feature, scenario, scenarioName);
        }
    }

    private void startScenario(String scenarioId, URI featurePath, TestCase testCase, Feature currentFeature, Scenario scenarioDefinition, String scenarioName) {
        ScenarioContextParallel context = this.getContext(featurePath);
        context.addHighPriorityStepEventBusEvent(scenarioId, (StepEventBusEvent)new SetTestSourceEvent(TestSourceType.TEST_SOURCE_CUCUMBER.getValue()));
        LOGGER.debug("SRP:startScenario " + featurePath + " " + Thread.currentThread() + " " + testCase.getId() + " at line " + testCase.getLocation().getLine());
        this.reinitializeRemoteWebDriver();
        context.addHighPriorityStepEventBusEvent(scenarioId, (StepEventBusEvent)new TestStartedEvent(scenarioId, scenarioName, this.scenarioIdFrom(TestSourcesModel.convertToId((String)currentFeature.getName()), TestSourcesModel.convertToId((String)scenarioName))));
        context.addStepEventBusEvent((StepEventBusEvent)new AddDescriptionToCurrentTestEvent(scenarioDefinition.getDescription()));
        context.addStepEventBusEvent((StepEventBusEvent)new AddTagsToCurrentTestEvent(this.convertCucumberTags(currentFeature.getTags())));
        context.addStepEventBusEvent((StepEventBusEvent)new AddTagsToCurrentTestEvent(this.tagsInEnclosingRule(currentFeature, scenarioDefinition)));
        if (this.isScenario(scenarioDefinition)) {
            context.addStepEventBusEvent((StepEventBusEvent)new AddTagsToCurrentTestEvent(this.convertCucumberTags(scenarioDefinition.getTags())));
        } else if (this.isScenarioOutline(scenarioDefinition)) {
            context.addStepEventBusEvent((StepEventBusEvent)new AddTagsToCurrentTestEvent(this.convertCucumberTags(scenarioDefinition.getTags())));
        }
        this.registerFeatureJiraIssues(featurePath, testCase, currentFeature.getTags());
        List<Tag> tags = this.getTagsOfScenarioDefinition(scenarioDefinition);
        this.registerScenarioJiraIssues(featurePath, testCase, tags);
        List<Tag> scenarioTags = this.tagsForScenario(featurePath, scenarioDefinition);
        context.setScenarioTags(scenarioId, scenarioTags);
        this.updateResultFromTags(scenarioId, featurePath, testCase, scenarioTags);
    }

    private List<TestTag> tagsInEnclosingRule(Feature feature, Scenario scenario) {
        List nestedRules = feature.getChildren().stream().filter(fc -> fc.getRule().isPresent()).map(fc -> (io.cucumber.messages.types.Rule)fc.getRule().get()).filter(Objects::nonNull).collect(Collectors.toList());
        return nestedRules.stream().filter(rule -> this.containsScenario((io.cucumber.messages.types.Rule)rule, scenario)).flatMap(rule -> this.convertCucumberTags(rule.getTags()).stream()).collect(Collectors.toList());
    }

    private boolean containsScenario(io.cucumber.messages.types.Rule rule, Scenario scenario) {
        return rule.getChildren().stream().anyMatch(child -> child.getScenario().isPresent() && child.getScenario().get() == scenario);
    }

    private List<Tag> tagsForScenario(URI featurePath, Scenario scenarioDefinition) {
        ArrayList<Tag> scenarioTags = new ArrayList<Tag>(this.getContext(featurePath).getFeatureTags());
        scenarioTags.addAll(this.getTagsOfScenarioDefinition(scenarioDefinition));
        return scenarioTags;
    }

    private boolean isScenario(Scenario scenarioDefinition) {
        return scenarioDefinition.getExamples().isEmpty();
    }

    private boolean isScenarioOutline(Scenario scenarioDefinition) {
        return scenarioDefinition.getExamples().size() > 0;
    }

    private List<Tag> getTagsOfScenarioDefinition(Scenario scenarioDefinition) {
        List tags = new ArrayList();
        if (this.isScenario(scenarioDefinition)) {
            tags = scenarioDefinition.getTags();
        } else if (this.isScenarioOutline(scenarioDefinition)) {
            tags = scenarioDefinition.getTags();
        }
        return tags;
    }

    private void registerFeatureJiraIssues(URI featurePath, TestCase testCase, List<Tag> tags) {
        List<String> issues = this.extractJiraIssueTags(tags);
        if (!issues.isEmpty()) {
            this.getContext(featurePath).addStepEventBusEvent((StepEventBusEvent)new AddIssuesToCurrentStoryEvent(issues));
        }
    }

    private void registerScenarioJiraIssues(URI featurePath, TestCase testCase, List<Tag> tags) {
        List<String> issues = this.extractJiraIssueTags(tags);
        if (!issues.isEmpty()) {
            this.getContext(featurePath).addStepEventBusEvent((StepEventBusEvent)new AddIssuesToCurrentTestEvent(issues));
        }
    }

    private List<TestTag> convertCucumberTags(List<Tag> cucumberTags) {
        cucumberTags = this.completeManualTagsIn(cucumberTags);
        return cucumberTags.stream().map(tag -> TestTag.withValue((String)tag.getName().substring(1))).collect(Collectors.toList());
    }

    private List<Tag> completeManualTagsIn(List<Tag> cucumberTags) {
        if (this.unqualifiedManualTag(cucumberTags).isPresent() && this.doesNotContainResultTag(cucumberTags)) {
            ArrayList updatedTags = Lists.newArrayList(cucumberTags);
            Tag newManualTag = new Tag(this.unqualifiedManualTag(cucumberTags).get().getLocation(), "@manual:pending", UUID.randomUUID().toString());
            updatedTags.add(newManualTag);
            return updatedTags;
        }
        return cucumberTags;
    }

    private boolean doesNotContainResultTag(List<Tag> tags) {
        return !tags.stream().noneMatch(tag -> tag.getName().startsWith("@manual:"));
    }

    private Optional<Tag> unqualifiedManualTag(List<Tag> tags) {
        return tags.stream().filter(tag -> tag.getName().equalsIgnoreCase("@manual")).findFirst();
    }

    private List<String> extractJiraIssueTags(List<Tag> cucumberTags) {
        ArrayList<String> issues = new ArrayList<String>();
        for (Tag tag : cucumberTags) {
            if (tag.getName().startsWith("@issue:")) {
                String tagIssueValue = tag.getName().substring("@issue:".length());
                issues.add(tagIssueValue);
            }
            if (!tag.getName().startsWith("@issues:")) continue;
            String tagIssuesValues = tag.getName().substring("@issues:".length());
            issues.addAll(Arrays.asList(tagIssuesValues.split(",")));
        }
        return issues;
    }

    private void startProcessingExampleLine(String scenarioId, URI featurePath, TestCase testCase, Long lineNumber, String scenarioName) {
        Map<String, String> data = this.exampleRows(scenarioId, featurePath).get(lineNumber);
        this.getContext(featurePath).addStepEventBusEvent((StepEventBusEvent)new ClearStepFailuresEvent());
        this.reinitializeRemoteWebDriver();
        this.getContext(featurePath).addStepEventBusEvent((StepEventBusEvent)new ExampleStartedEvent(data, scenarioName));
        if (this.exampleTags(featurePath).containsKey(lineNumber)) {
            List<Tag> currentExampleTags = this.exampleTags(featurePath).get(lineNumber);
            this.getContext(featurePath).addStepEventBusEvent((StepEventBusEvent)new AddTagsToCurrentTestEvent(this.convertCucumberTags(currentExampleTags)));
        }
    }

    private void reinitializeRemoteWebDriver() {
        WebDriver webDriver = SerenityWebdriverManager.inThisTestThread().getCurrentDriver();
        if (webDriver != null && webDriver instanceof WebDriverFacade) {
            ((WebDriverFacade)webDriver).reinitializeRemoteWebDriver();
        }
    }

    private void finishProcessingExampleLine(String scenarioId, URI featurePath, TestCase testCase) {
        this.getContext(featurePath).addStepEventBusEvent((StepEventBusEvent)new ExampleFinishedEvent());
        this.getContext(featurePath).decrementExampleCount(scenarioId);
        if (this.getContext(featurePath).getExampleCount(scenarioId) == 0) {
            this.getContext(featurePath).setExamplesRunning(scenarioId, false);
            this.setTableScenarioOutline(scenarioId, featurePath);
        } else {
            this.getContext(featurePath).setExamplesRunning(scenarioId, true);
        }
    }

    private void setTableScenarioOutline(String scenarioId, URI featurePath) {
        List steps = this.getContext(featurePath).getCurrentScenarioDefinition(scenarioId).getSteps();
        StringBuffer scenarioOutlineBuffer = new StringBuffer();
        for (Step step : steps) {
            scenarioOutlineBuffer.append(step.getKeyword()).append(step.getText()).append("\n\r");
        }
        String scenarioOutline = scenarioOutlineBuffer.toString();
        if (this.getContext(featurePath).getTable(scenarioId) != null) {
            this.getContext(featurePath).getTable(scenarioId).setScenarioOutline(scenarioOutline);
        }
    }

    private void handleBackground(URI featurePath, TestCase testCase, Background background) {
        String backgroundDescription;
        this.getContext(featurePath).setWaitingToProcessBackgroundSteps(true);
        String backgroundName = background.getName();
        if (backgroundName != null) {
            this.getContext(featurePath).addStepEventBusEvent((StepEventBusEvent)new SetBackgroundTitleEvent(backgroundName));
        }
        if ((backgroundDescription = background.getDescription()) == null) {
            backgroundDescription = SCENARIO_OUTLINE_NOT_KNOWN_YET;
        }
        this.getContext(featurePath).addStepEventBusEvent((StepEventBusEvent)new SetBackgroundDescriptionEvent(backgroundDescription));
    }

    private void assureTestSuiteFinished() {
        this.contextURISet.forEach(featurePath -> {
            this.getContext((URI)featurePath).clearStepQueue();
            this.getContext((URI)featurePath).clearTestStepQueue();
            this.getContext((URI)featurePath).clearTable();
            this.getContext((URI)featurePath).addCurrentScenarioId(null);
        });
        this.contextURISet.forEach(this::cleanupTestResourcesForURI);
        this.contextURISet.clear();
        Serenity.done();
    }

    private void cleanupTestResourcesForURI(URI uri) {
        this.getStepEventBus(uri).testSuiteFinished();
        this.getStepEventBus(uri).dropAllListeners();
        this.getStepEventBus(uri).clear();
        StepEventBus.clearEventBusFor((Object)uri);
    }

    private void handleResult(String scenarioId, URI featurePath, TestCase testCase, Result result) {
        Step currentStep = this.getContext(featurePath).nextStep(testCase);
        TestStep currentTestStep = this.getContext(featurePath).nextTestStep(testCase);
        this.recordStepResult(featurePath, testCase, result, currentStep, currentTestStep);
        if (this.getContext(featurePath).noStepsAreQueued(testCase)) {
            this.recordFinalResult(scenarioId, featurePath, testCase);
        }
    }

    private void recordStepResult(URI featurePath, TestCase testCase, Result result, Step currentStep, TestStep currentTestStep) {
        List screenshotList = this.getContext(featurePath).stepEventBus().takeScreenshots();
        this.getContext(featurePath).addStepEventBusEvent((StepEventBusEvent)new RecordStepResultEvent(result, currentStep, currentTestStep, screenshotList));
    }

    private void recordFinalResult(String scenarioId, URI featurePath, TestCase testCase) {
        ScenarioContextParallel context = this.getContext(featurePath);
        if (context.isWaitingToProcessBackgroundSteps()) {
            context.setWaitingToProcessBackgroundSteps(false);
        } else {
            this.updateResultFromTags(scenarioId, featurePath, testCase, context.getScenarioTags(scenarioId));
        }
    }

    private void updateResultFromTags(String scenarioId, URI featurePath, TestCase testCase, List<Tag> scenarioTags) {
        if (TaggedScenario.isManual(scenarioTags)) {
            this.updateManualResultsFrom(scenarioId, featurePath, testCase, scenarioTags);
        } else if (TaggedScenario.isPending(scenarioTags)) {
            this.getContext(featurePath).addStepEventBusEvent((StepEventBusEvent)new SetTestPendingEvent());
        } else if (TaggedScenario.isSkippedOrWIP(scenarioTags)) {
            this.getContext(featurePath).addStepEventBusEvent((StepEventBusEvent)new SetTestSkippedEvent());
            this.updateCurrentScenarioResultTo(featurePath, TestResult.SKIPPED);
        } else if (TaggedScenario.isIgnored(scenarioTags)) {
            this.getContext(featurePath).addStepEventBusEvent((StepEventBusEvent)new SetTestIgnoredEvent());
            this.updateCurrentScenarioResultTo(featurePath, TestResult.IGNORED);
        }
    }

    private void updateManualResultsFrom(String scenarioId, URI featurePath, TestCase testCase, List<Tag> scenarioTags) {
        this.getContext(featurePath).addStepEventBusEvent((StepEventBusEvent)new SetTestManualEvent(this.getContext(featurePath), scenarioTags, scenarioId));
    }

    private void updateCurrentScenarioResultTo(URI featurePath, TestResult testResult) {
        this.getContext(featurePath).addStepEventBusEvent((StepEventBusEvent)new OverrideResultToEvent(testResult));
    }

    public static String stepTitleFrom(Step currentStep, TestStep testStep) {
        if (currentStep != null && testStep instanceof PickleStepTestStep) {
            return currentStep.getKeyword() + ((PickleStepTestStep)testStep).getStep().getText() + SerenityReporterParallel.embeddedTableDataIn((PickleStepTestStep)testStep);
        }
        return SCENARIO_OUTLINE_NOT_KNOWN_YET;
    }

    private static String embeddedTableDataIn(PickleStepTestStep currentStep) {
        StepArgument stepArgument;
        if (currentStep.getStep().getArgument() != null && (stepArgument = currentStep.getStep().getArgument()) instanceof DataTableArgument) {
            ArrayList<Map<String, Object>> rowList = new ArrayList<Map<String, Object>>();
            for (List row : ((DataTableArgument)stepArgument).cells()) {
                HashMap<String, List> rowMap = new HashMap<String, List>();
                rowMap.put("cells", row);
                rowList.add(rowMap);
            }
            return SerenityReporterParallel.convertToTextTable(rowList);
        }
        return SCENARIO_OUTLINE_NOT_KNOWN_YET;
    }

    private static String convertToTextTable(List<Map<String, Object>> rows) {
        StringBuilder textTable = new StringBuilder();
        textTable.append(System.lineSeparator());
        for (Map<String, Object> row : rows) {
            textTable.append("|");
            for (String cell : (List)row.get("cells")) {
                textTable.append(" ");
                textTable.append(cell);
                textTable.append(" |");
            }
            if (row == rows.get(rows.size() - 1)) continue;
            textTable.append(System.lineSeparator());
        }
        return textTable.toString();
    }

    private void generateReports() {
        List<TestOutcome> allTestOutcomes = this.getAllTestOutcomes();
        LOGGER.debug("SRP:AllTestOutcomes " + allTestOutcomes.size());
        this.getReportService().generateReportsFor(allTestOutcomes);
    }

    public List<TestOutcome> getAllTestOutcomes() {
        ArrayList allBaseStepListeners = new ArrayList();
        this.localContexts.forEach((uri, context) -> {
            LOGGER.debug("SRP:AllTestOutcomes for uri " + uri);
            context.collectAllBaseStepListeners(allBaseStepListeners);
        });
        return allBaseStepListeners.stream().map(BaseStepListener::getTestOutcomes).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private String normalized(String value) {
        return value.replaceAll(OPEN_PARAM_CHAR, "{").replaceAll(CLOSE_PARAM_CHAR, "}");
    }

    private String trim(String stringToBeTrimmed) {
        return stringToBeTrimmed == null ? null : stringToBeTrimmed.trim();
    }
}

