/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.cucumber.util;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class Splitter {
    private String separator;
    private boolean omitEmptyStrings = false;
    private boolean trimResults = false;
    private String trimmable = null;

    public Splitter(String separator) {
        this.separator = separator;
    }

    public static Splitter on(String separator) {
        return new Splitter(separator);
    }

    public Splitter omitEmptyStrings() {
        this.omitEmptyStrings = true;
        return this;
    }

    public Splitter trimResults() {
        this.trimResults = true;
        return this;
    }

    public Splitter trimResults(String trimmable) {
        this.trimResults = true;
        this.trimmable = trimmable;
        return this;
    }

    public List<String> splitToList(String value) {
        String[] separatedElements = StringUtils.split((String)value, (String)this.separator);
        List<String> result = Arrays.asList(separatedElements);
        if (this.omitEmptyStrings) {
            result = result.stream().filter(element -> !element.trim().equals("")).collect(Collectors.toList());
        }
        if (this.trimResults) {
            result = result.stream().map(v -> StringUtils.strip((String)v, (String)this.trimmable)).collect(Collectors.toList());
        }
        return result;
    }

    public static Splitter on(char separator) {
        return Splitter.on(Character.toString(separator));
    }
}

