/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.junit;

import cucumber.api.Plugin;
import cucumber.api.StepDefinitionReporter;
import cucumber.api.event.Event;
import cucumber.api.event.EventPublisher;
import cucumber.api.event.TestRunFinished;
import cucumber.api.event.TestRunStarted;
import cucumber.runner.EventBus;
import cucumber.runner.ThreadLocalRunnerSupplier;
import cucumber.runner.TimeService;
import cucumber.runner.TimeServiceEventBus;
import cucumber.runtime.BackendModuleBackendSupplier;
import cucumber.runtime.BackendSupplier;
import cucumber.runtime.ClassFinder;
import cucumber.runtime.Env;
import cucumber.runtime.FeaturePathFeatureSupplier;
import cucumber.runtime.FeatureSupplier;
import cucumber.runtime.Runtime;
import cucumber.runtime.filter.Filters;
import cucumber.runtime.formatter.PluginFactory;
import cucumber.runtime.formatter.Plugins;
import cucumber.runtime.formatter.SerenityReporter;
import cucumber.runtime.io.MultiLoader;
import cucumber.runtime.io.ResourceLoader;
import cucumber.runtime.io.ResourceLoaderClassFinder;
import cucumber.runtime.model.CucumberFeature;
import cucumber.runtime.model.FeatureLoader;
import io.cucumber.core.options.CucumberOptionsAnnotationParser;
import io.cucumber.core.options.EnvironmentOptionsParser;
import io.cucumber.core.options.FeatureOptions;
import io.cucumber.core.options.FilterOptions;
import io.cucumber.core.options.PluginOptions;
import io.cucumber.core.options.RunnerOptions;
import io.cucumber.core.options.RuntimeOptions;
import io.cucumber.junit.Assertions;
import io.cucumber.junit.FeatureRunner;
import io.cucumber.junit.FeatureRunnerExtractors;
import io.cucumber.junit.JUnitCucumberOptionsProvider;
import io.cucumber.junit.JUnitOptions;
import io.cucumber.junit.JUnitOptionsParser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.serenitybdd.cucumber.suiteslicing.CucumberSuiteSlicer;
import net.serenitybdd.cucumber.suiteslicing.ScenarioFilter;
import net.serenitybdd.cucumber.suiteslicing.TestStatistics;
import net.serenitybdd.cucumber.suiteslicing.WeightedCucumberScenarios;
import net.serenitybdd.cucumber.util.PathUtils;
import net.serenitybdd.cucumber.util.Splitter;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.webdriver.Configuration;
import org.junit.runner.Description;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.manipulation.NoTestsRemainException;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.ParentRunner;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.RunnerScheduler;
import org.junit.runners.model.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CucumberSerenityRunner
extends ParentRunner<FeatureRunner> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CucumberSerenityRunner.class);
    private final List<FeatureRunner> children = new ArrayList<FeatureRunner>();
    private final EventBus bus;
    private final ThreadLocalRunnerSupplier runnerSupplier;
    private static ThreadLocal<RuntimeOptions> RUNTIME_OPTIONS = new ThreadLocal();
    private final List<CucumberFeature> features;
    private final Plugins plugins;
    private boolean multiThreadingAssumed = false;
    private static RuntimeOptions DEFAULT_RUNTIME_OPTIONS;

    public CucumberSerenityRunner(Class clazz) throws InitializationError {
        super(clazz);
        ClassLoader classLoader = clazz.getClassLoader();
        MultiLoader resourceLoader = new MultiLoader(classLoader);
        Assertions.assertNoCucumberAnnotatedMethods((Class)clazz);
        RuntimeOptions annotationOptions = new CucumberOptionsAnnotationParser((ResourceLoader)resourceLoader).withOptionsProvider((CucumberOptionsAnnotationParser.OptionsProvider)new JUnitCucumberOptionsProvider()).parse(clazz).build();
        RuntimeOptions runtimeOptions = new EnvironmentOptionsParser((ResourceLoader)resourceLoader).parse(Env.INSTANCE).build(annotationOptions);
        runtimeOptions.addUndefinedStepsPrinterIfSummaryNotDefined();
        JUnitOptions junitAnnotationOptions = new JUnitOptionsParser().parse(clazz).build();
        JUnitOptions junitOptions = new JUnitOptionsParser().parse(runtimeOptions.getJunitOptions()).setStrict(runtimeOptions.isStrict()).build(junitAnnotationOptions);
        CucumberSerenityRunner.setRuntimeOptions(runtimeOptions);
        FeatureLoader featureLoader = new FeatureLoader((ResourceLoader)resourceLoader);
        FeaturePathFeatureSupplier featureSupplier = new FeaturePathFeatureSupplier(featureLoader, (FeatureOptions)runtimeOptions);
        this.features = featureSupplier.get();
        ResourceLoaderClassFinder classFinder = new ResourceLoaderClassFinder((ResourceLoader)resourceLoader, classLoader);
        this.plugins = new Plugins(classLoader, new PluginFactory(), (PluginOptions)runtimeOptions);
        this.bus = new TimeServiceEventBus(TimeService.SYSTEM);
        Configuration systemConfiguration = (Configuration)Injectors.getInjector().getInstance(Configuration.class);
        SerenityReporter reporter = new SerenityReporter(systemConfiguration, (ResourceLoader)resourceLoader);
        CucumberSerenityRunner.addSerenityReporterPlugin(this.plugins, reporter);
        BackendModuleBackendSupplier backendSupplier = new BackendModuleBackendSupplier((ResourceLoader)resourceLoader, (ClassFinder)classFinder, (RunnerOptions)runtimeOptions);
        this.runnerSupplier = new ThreadLocalRunnerSupplier((RunnerOptions)runtimeOptions, this.bus, (BackendSupplier)backendSupplier);
        Filters filters = new Filters((FilterOptions)runtimeOptions);
        for (CucumberFeature cucumberFeature : this.features) {
            FeatureRunner featureRunner = new FeatureRunner(cucumberFeature, filters, this.runnerSupplier, junitOptions);
            if (featureRunner.isEmpty()) continue;
            this.children.add(featureRunner);
        }
    }

    public static void setRuntimeOptions(RuntimeOptions runtimeOptions) {
        RUNTIME_OPTIONS.set(runtimeOptions);
        DEFAULT_RUNTIME_OPTIONS = runtimeOptions;
    }

    public static RuntimeOptions currentRuntimeOptions() {
        return RUNTIME_OPTIONS.get() != null ? RUNTIME_OPTIONS.get() : DEFAULT_RUNTIME_OPTIONS;
    }

    private static Collection<String> environmentSpecifiedTags(List<?> existingTags) {
        EnvironmentVariables environmentVariables = (EnvironmentVariables)Injectors.getInjector().getInstance(EnvironmentVariables.class);
        String tagsExpression = ThucydidesSystemProperty.TAGS.from(environmentVariables, "");
        List existingTagsValues = existingTags.stream().map(Object::toString).collect(Collectors.toList());
        return Splitter.on(",").trimResults().omitEmptyStrings().splitToList(tagsExpression).stream().map(CucumberSerenityRunner::toCucumberTag).filter(t -> !existingTagsValues.contains(t)).collect(Collectors.toList());
    }

    private static String toCucumberTag(String from) {
        String tag = from.replaceAll(":", "=");
        if (tag.startsWith("~@") || tag.startsWith("@")) {
            return tag;
        }
        if (tag.startsWith("~")) {
            return "~@" + tag.substring(1);
        }
        return "@" + tag;
    }

    public static Runtime createSerenityEnabledRuntime(ResourceLoader resourceLoader, ClassLoader classLoader, RuntimeOptions runtimeOptions, Configuration systemConfiguration) {
        ResourceLoaderClassFinder classFinder = new ResourceLoaderClassFinder(resourceLoader, classLoader);
        CucumberSerenityRunner.setRuntimeOptions(runtimeOptions);
        FeatureLoader featureLoader = new FeatureLoader(resourceLoader);
        FeaturePathFeatureSupplier featureSupplier = new FeaturePathFeatureSupplier(featureLoader, (FeatureOptions)runtimeOptions);
        List features = featureSupplier.get();
        TimeServiceEventBus bus = new TimeServiceEventBus(TimeService.SYSTEM);
        SerenityReporter serenityReporter = new SerenityReporter(systemConfiguration, resourceLoader);
        Runtime runtime = Runtime.builder().withResourceLoader(resourceLoader).withClassFinder((ClassFinder)classFinder).withClassLoader(classLoader).withRuntimeOptions(runtimeOptions).withAdditionalPlugins(new Plugin[]{serenityReporter}).withEventBus((EventBus)bus).withFeatureSupplier((FeatureSupplier)featureSupplier).build();
        return runtime;
    }

    private static void addSerenityReporterPlugin(Plugins plugins, SerenityReporter plugin) {
        for (Plugin currentPlugin : plugins.getPlugins()) {
            if (!(currentPlugin instanceof SerenityReporter)) continue;
            return;
        }
        plugins.addPlugin((Plugin)plugin);
    }

    protected Description describeChild(FeatureRunner child) {
        return child.getDescription();
    }

    protected void runChild(FeatureRunner child, RunNotifier notifier) {
        child.run(notifier);
    }

    protected Statement childrenInvoker(RunNotifier notifier) {
        Statement runFeatures = super.childrenInvoker(notifier);
        return new RunCucumber(runFeatures);
    }

    public void setScheduler(RunnerScheduler scheduler) {
        super.setScheduler(scheduler);
        this.multiThreadingAssumed = true;
    }

    public List<FeatureRunner> getChildren() {
        try {
            EnvironmentVariables environmentVariables = (EnvironmentVariables)Injectors.getInjector().getInstance(EnvironmentVariables.class);
            RuntimeOptions runtimeOptions = CucumberSerenityRunner.currentRuntimeOptions();
            List tagFilters = runtimeOptions.getTagFilters();
            List featurePaths = runtimeOptions.getFeaturePaths();
            int batchNumber = environmentVariables.getPropertyAsInteger((Enum)ThucydidesSystemProperty.SERENITY_BATCH_NUMBER, Integer.valueOf(1));
            int batchCount = environmentVariables.getPropertyAsInteger((Enum)ThucydidesSystemProperty.SERENITY_BATCH_COUNT, Integer.valueOf(1));
            int forkNumber = environmentVariables.getPropertyAsInteger((Enum)ThucydidesSystemProperty.SERENITY_FORK_NUMBER, Integer.valueOf(1));
            int forkCount = environmentVariables.getPropertyAsInteger((Enum)ThucydidesSystemProperty.SERENITY_FORK_COUNT, Integer.valueOf(1));
            if (batchCount == 1 && forkCount == 1) {
                return this.children;
            }
            LOGGER.info("Running slice {} of {} using fork {} of {} from feature paths {}", new Object[]{batchNumber, batchCount, forkNumber, forkCount, featurePaths});
            WeightedCucumberScenarios weightedCucumberScenarios = new CucumberSuiteSlicer(featurePaths, TestStatistics.from(environmentVariables, featurePaths)).scenarios(batchNumber, batchCount, forkNumber, forkCount, tagFilters);
            List<FeatureRunner> unfilteredChildren = this.children;
            AtomicInteger filteredInScenarioCount = new AtomicInteger();
            List<FeatureRunner> filteredChildren = unfilteredChildren.stream().filter(this.forIncludedFeatures(weightedCucumberScenarios)).map(this.toPossibleFeatureRunner(weightedCucumberScenarios, filteredInScenarioCount)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
            if (filteredInScenarioCount.get() != weightedCucumberScenarios.totalScenarioCount()) {
                LOGGER.warn("There is a mismatch between the number of scenarios included in this test run ({}) and the expected number of scenarios loaded ({}). This suggests that the scenario filtering is not working correctly or feature file(s) of an unexpected structure are being run", (Object)filteredInScenarioCount.get(), (Object)weightedCucumberScenarios.scenarios.size());
            }
            LOGGER.info("Running {} of {} features", (Object)filteredChildren.size(), (Object)unfilteredChildren.size());
            return filteredChildren;
        }
        catch (Exception e) {
            LOGGER.error("Test failed to start", (Throwable)e);
            throw e;
        }
    }

    private Function<FeatureRunner, Optional<FeatureRunner>> toPossibleFeatureRunner(WeightedCucumberScenarios weightedCucumberScenarios, AtomicInteger filteredInScenarioCount) {
        return featureRunner -> {
            int initialScenarioCount = featureRunner.getDescription().getChildren().size();
            String featureName = FeatureRunnerExtractors.extractFeatureName(featureRunner);
            try {
                ScenarioFilter filter = weightedCucumberScenarios.createFilterContainingScenariosIn(featureName);
                String featurePath = FeatureRunnerExtractors.featurePathFor(featureRunner);
                featureRunner.filter((Filter)filter);
                if (!filter.scenariosIncluded().isEmpty()) {
                    LOGGER.info("{} scenario(s) included for '{}' in {}", new Object[]{filter.scenariosIncluded().size(), featureName, featurePath});
                    filter.scenariosIncluded().forEach(scenario -> {
                        LOGGER.info("Included scenario '{}'", scenario);
                        filteredInScenarioCount.getAndIncrement();
                    });
                }
                if (!filter.scenariosExcluded().isEmpty()) {
                    LOGGER.debug("{} scenario(s) excluded for '{}' in {}", new Object[]{filter.scenariosExcluded().size(), featureName, featurePath});
                    filter.scenariosExcluded().forEach(scenario -> LOGGER.debug("Excluded scenario '{}'", scenario));
                }
                return Optional.of(featureRunner);
            }
            catch (NoTestsRemainException e) {
                LOGGER.info("Filtered out all {} scenarios for feature '{}'", (Object)initialScenarioCount, (Object)featureName);
                return Optional.empty();
            }
        };
    }

    private Predicate<FeatureRunner> forIncludedFeatures(WeightedCucumberScenarios weightedCucumberScenarios) {
        return featureRunner -> {
            String featureName = FeatureRunnerExtractors.extractFeatureName(featureRunner);
            String featurePath = PathUtils.getAsFile(FeatureRunnerExtractors.featurePathFor(featureRunner)).getName();
            boolean matches = weightedCucumberScenarios.scenarios.stream().anyMatch(scenario -> featurePath.equals(scenario.featurePath));
            LOGGER.debug("{} in filtering '{}' in {}", new Object[]{matches ? "Including" : "Not including", featureName, featurePath});
            return matches;
        };
    }

    class RunCucumber
    extends Statement {
        private final Statement runFeatures;

        RunCucumber(Statement runFeatures) {
            this.runFeatures = runFeatures;
        }

        public void evaluate() throws Throwable {
            if (CucumberSerenityRunner.this.multiThreadingAssumed) {
                CucumberSerenityRunner.this.plugins.setSerialEventBusOnEventListenerPlugins((EventPublisher)CucumberSerenityRunner.this.bus);
            } else {
                CucumberSerenityRunner.this.plugins.setEventBusOnEventListenerPlugins((EventPublisher)CucumberSerenityRunner.this.bus);
            }
            CucumberSerenityRunner.this.bus.send((Event)new TestRunStarted(CucumberSerenityRunner.this.bus.getTime(), CucumberSerenityRunner.this.bus.getTimeMillis().longValue()));
            for (CucumberFeature feature : CucumberSerenityRunner.this.features) {
                feature.sendTestSourceRead(CucumberSerenityRunner.this.bus);
            }
            StepDefinitionReporter stepDefinitionReporter = CucumberSerenityRunner.this.plugins.stepDefinitionReporter();
            CucumberSerenityRunner.this.runnerSupplier.get().reportStepDefinitions(stepDefinitionReporter);
            this.runFeatures.evaluate();
            CucumberSerenityRunner.this.bus.send((Event)new TestRunFinished(CucumberSerenityRunner.this.bus.getTime(), CucumberSerenityRunner.this.bus.getTimeMillis().longValue()));
        }
    }
}

