/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.cucumber.formatting;

import gherkin.ast.DataTable;
import gherkin.ast.ScenarioDefinition;
import gherkin.ast.Step;
import gherkin.ast.TableCell;
import gherkin.ast.TableRow;
import java.util.stream.Collectors;

public class ScenarioOutlineDescription {
    private final ScenarioDefinition scenario;

    public ScenarioOutlineDescription(ScenarioDefinition scenario) {
        this.scenario = scenario;
    }

    public static ScenarioOutlineDescription from(ScenarioDefinition scenario) {
        return new ScenarioOutlineDescription(scenario);
    }

    public String getDescription() {
        return this.scenario.getSteps().stream().map(step -> this.stepToString((Step)step)).collect(Collectors.joining(System.lineSeparator()));
    }

    private String stepToString(Step step) {
        String phrase = step.getKeyword() + step.getText();
        if (step.getArgument() != null && step.getArgument().getClass().isAssignableFrom(DataTable.class)) {
            DataTable table = (DataTable)step.getArgument();
            String tableAsString = "";
            for (TableRow row : table.getRows()) {
                tableAsString = tableAsString + "|";
                tableAsString = tableAsString + row.getCells().stream().map(TableCell::getValue).collect(Collectors.joining(" | "));
                tableAsString = tableAsString + "|" + System.lineSeparator();
            }
            phrase = phrase + System.lineSeparator() + tableAsString.trim();
        }
        return phrase;
    }
}

