/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.cucumber.suiteslicing;

import io.cucumber.core.feature.FeatureParser;
import io.cucumber.core.feature.Options;
import io.cucumber.core.gherkin.Feature;
import io.cucumber.core.gherkin.messages.internal.gherkin.GherkinDocumentBuilder;
import io.cucumber.core.gherkin.messages.internal.gherkin.Parser;
import io.cucumber.core.gherkin.messages.internal.gherkin.TokenMatcher;
import io.cucumber.core.runtime.FeaturePathFeatureSupplier;
import io.cucumber.messages.IdGenerator;
import io.cucumber.messages.Messages;
import java.math.BigDecimal;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.serenitybdd.cucumber.suiteslicing.CucumberScenarioLoader;
import net.serenitybdd.cucumber.suiteslicing.TestScenarioResult;
import net.serenitybdd.cucumber.suiteslicing.TestStatistics;
import net.thucydides.core.util.Inflector;

public class ScenarioLineCountStatistics
implements TestStatistics {
    private final Supplier<ClassLoader> classLoader = CucumberScenarioLoader.class::getClassLoader;
    private final FeatureParser parser = new FeatureParser(UUID::randomUUID);
    private final List<TestScenarioResult> results;

    private ScenarioLineCountStatistics(List<URI> featurePaths) {
        Options featureOptions = () -> featurePaths;
        TokenMatcher matcher = new TokenMatcher();
        FeaturePathFeatureSupplier supplier = new FeaturePathFeatureSupplier(this.classLoader, featureOptions, this.parser);
        ArrayList<Messages.GherkinDocument.Feature> features = new ArrayList<Messages.GherkinDocument.Feature>();
        List gherkinFeatures = supplier.get();
        for (Feature gherkinFeature : gherkinFeatures) {
            Parser gherkinParser = new Parser((Parser.Builder)new GherkinDocumentBuilder((IdGenerator)new IdGenerator.UUID()));
            Messages.GherkinDocument.Builder builder = (Messages.GherkinDocument.Builder)gherkinParser.parse(gherkinFeature.getSource(), (Parser.ITokenMatcher)matcher);
            features.add(builder.build().getFeature());
        }
        this.results = features.stream().map(this.featureToScenarios()).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public static ScenarioLineCountStatistics fromFeaturePath(URI featurePaths) {
        return ScenarioLineCountStatistics.fromFeaturePaths(Arrays.asList(featurePaths));
    }

    public static ScenarioLineCountStatistics fromFeaturePaths(List<URI> featurePaths) {
        return new ScenarioLineCountStatistics(featurePaths);
    }

    private Function<Messages.GherkinDocument.Feature, List<TestScenarioResult>> featureToScenarios() {
        return cucumberFeature -> {
            try {
                return cucumberFeature == null ? Collections.emptyList() : cucumberFeature.getChildrenList().stream().filter(child -> child.hasScenario()).map(Messages.GherkinDocument.Feature.FeatureChild::getScenario).map(this.scenarioToResult((Messages.GherkinDocument.Feature)cucumberFeature)).collect(Collectors.toList());
            }
            catch (Exception e) {
                throw new IllegalStateException(String.format("Could not extract scenarios from %s", cucumberFeature.getName()), e);
            }
        };
    }

    private Function<Messages.GherkinDocument.Feature.Scenario, TestScenarioResult> scenarioToResult(Messages.GherkinDocument.Feature feature) {
        return scenarioDefinition -> {
            try {
                return new TestScenarioResult(feature.getName(), scenarioDefinition.getName(), this.scenarioStepCountFor(this.backgroundStepCountFor(feature), (Messages.GherkinDocument.Feature.Scenario)scenarioDefinition));
            }
            catch (Exception e) {
                throw new IllegalStateException(String.format("Could not determine step count for scenario '%s'", scenarioDefinition.getDescription()), e);
            }
        };
    }

    private BigDecimal scenarioStepCountFor(int backgroundStepCount, Messages.GherkinDocument.Feature.Scenario scenarioDefinition) {
        int stepCount;
        if (scenarioDefinition.getExamplesCount() > 0) {
            Integer exampleCount = scenarioDefinition.getExamplesList().stream().map(examples -> examples.getTableBodyList().size()).mapToInt(Integer::intValue).sum();
            stepCount = exampleCount * (backgroundStepCount + scenarioDefinition.getStepsCount());
        } else {
            stepCount = backgroundStepCount + scenarioDefinition.getStepsCount();
        }
        return BigDecimal.valueOf(stepCount);
    }

    private int backgroundStepCountFor(Messages.GherkinDocument.Feature feature) {
        Messages.GherkinDocument.Feature.FeatureChild scenarioDefinition = (Messages.GherkinDocument.Feature.FeatureChild)feature.getChildrenList().get(0);
        if (scenarioDefinition.hasBackground()) {
            return scenarioDefinition.getBackground().getStepsCount();
        }
        return 0;
    }

    @Override
    public BigDecimal scenarioWeightFor(String feature, String scenario) {
        return this.results.stream().filter(record -> record.feature.equals(feature) && record.scenario.equals(scenario)).map(TestScenarioResult::duration).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("no result found for scenario '%s' in feature '%s'", scenario, feature)));
    }

    @Override
    public List<TestScenarioResult> records() {
        return this.results;
    }

    public String toString() {
        return Inflector.getInstance().kebabCase(this.getClass().getSimpleName(), new char[0]);
    }
}

