/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.cucumber.suiteslicing;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.List;
import net.serenitybdd.cucumber.suiteslicing.TestScenarioResult;
import net.serenitybdd.cucumber.util.BigDecimalAverageCollector;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class TestScenarioResults {
    public final String scenarioKey;
    public final List<BigDecimal> durations;
    private final String feature;
    private final String scenario;

    public static TestScenarioResults create(TestScenarioResult testScenarioDuration) {
        return new TestScenarioResults(testScenarioDuration);
    }

    public void addDuration(BigDecimal duration) {
        this.durations.add(duration);
    }

    private TestScenarioResults(TestScenarioResult testScenarioResult) {
        this.durations = Lists.newArrayList((Object[])new BigDecimal[]{testScenarioResult.duration});
        this.scenarioKey = testScenarioResult.scenarioKey;
        this.feature = testScenarioResult.feature;
        this.scenario = testScenarioResult.scenario;
    }

    public TestScenarioResult average() {
        return new TestScenarioResult(this.feature, this.scenario, this.durations.stream().collect(BigDecimalAverageCollector.create()));
    }

    public boolean equals(Object o) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)o, (String[])new String[0]);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

