/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.cucumber.formatting;

import io.cucumber.messages.Messages;
import java.util.stream.Collectors;

public class ScenarioOutlineDescription {
    private final Messages.GherkinDocument.Feature.Scenario scenario;

    public ScenarioOutlineDescription(Messages.GherkinDocument.Feature.Scenario scenario) {
        this.scenario = scenario;
    }

    public static ScenarioOutlineDescription from(Messages.GherkinDocument.Feature.Scenario scenario) {
        return new ScenarioOutlineDescription(scenario);
    }

    public String getDescription() {
        return this.scenario.getStepsList().stream().map(step -> this.stepToString((Messages.GherkinDocument.Feature.Step)step)).collect(Collectors.joining(System.lineSeparator()));
    }

    private String stepToString(Messages.GherkinDocument.Feature.Step step) {
        String phrase = step.getKeyword() + step.getText();
        if (step.hasDataTable()) {
            Messages.GherkinDocument.Feature.Step.DataTable table = step.getDataTable();
            String tableAsString = "";
            for (Messages.GherkinDocument.Feature.TableRow row : table.getRowsList()) {
                tableAsString = tableAsString + "|";
                tableAsString = tableAsString + row.getCellsList().stream().map(Messages.GherkinDocument.Feature.TableRow.TableCell::getValue).collect(Collectors.joining(" | "));
                tableAsString = tableAsString + "|" + System.lineSeparator();
            }
            phrase = phrase + System.lineSeparator() + tableAsString.trim();
        }
        return phrase;
    }
}

