/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.junit.runners;

import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.serenitybdd.core.environment.EnvironmentSpecificConfiguration;
import net.serenitybdd.core.environment.WebDriverConfiguredEnvironment;
import net.serenitybdd.junit.runners.DataDrivenAnnotations;
import net.serenitybdd.junit.runners.ParameterizedRunnerScheduler;
import net.serenitybdd.junit.runners.ParameterizedTestsOutcomeAggregator;
import net.serenitybdd.junit.runners.QualifierFinder;
import net.serenitybdd.junit.runners.SerenityRunner;
import net.serenitybdd.junit.runners.TestClassRunnerForInstanciatedTestCase;
import net.serenitybdd.junit.runners.TestClassRunnerForParameters;
import net.thucydides.core.batches.BatchManager;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.model.DataTable;
import net.thucydides.core.model.DataTableRow;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.reports.AcceptanceTestReporter;
import net.thucydides.core.reports.ReportService;
import net.thucydides.core.steps.StepEventBus;
import net.thucydides.core.tags.TagScanner;
import net.thucydides.core.tags.Taggable;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.webdriver.DriverConfiguration;
import net.thucydides.core.webdriver.WebDriverFactory;
import net.thucydides.junit.ThucydidesJUnitSystemProperties;
import net.thucydides.junit.annotations.Concurrent;
import org.apache.commons.lang3.StringUtils;
import org.junit.runner.Runner;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.Suite;

public class SerenityParameterizedRunner
extends Suite
implements Taggable {
    private static final int AVAILABLE_PROCESSORS = Runtime.getRuntime().availableProcessors();
    private List<Runner> runners = new ArrayList<Runner>();
    private final DriverConfiguration configuration;
    private ReportService reportService;
    private final ParameterizedTestsOutcomeAggregator parameterizedTestsOutcomeAggregator = ParameterizedTestsOutcomeAggregator.from(this);
    private TagScanner tagScanner;

    public SerenityParameterizedRunner(Class<?> klass, DriverConfiguration configuration, WebDriverFactory webDriverFactory, BatchManager batchManager) throws Throwable {
        super(klass, Collections.emptyList());
        DataDrivenAnnotations testClassAnnotations;
        this.configuration = configuration;
        this.tagScanner = new TagScanner(configuration.getEnvironmentVariables());
        if (this.runTestsInParallelFor(klass)) {
            this.scheduleParallelTestRunsFor(klass);
        }
        if ((testClassAnnotations = this.getTestAnnotations()).hasTestDataDefined()) {
            this.runners = this.buildTestRunnersForEachDataSetUsing(webDriverFactory, batchManager);
        } else if (testClassAnnotations.hasTestDataSourceDefined()) {
            this.runners = this.buildTestRunnersFromADataSourceUsing(webDriverFactory, batchManager);
        }
    }

    private void scheduleParallelTestRunsFor(Class<?> klass) {
        this.setScheduler(new ParameterizedRunnerScheduler(klass, this.getThreadCountFor(klass)));
    }

    public boolean runTestsInParallelFor(Class<?> klass) {
        return klass.getAnnotation(Concurrent.class) != null;
    }

    public int getThreadCountFor(Class<?> klass) {
        Concurrent concurrent = klass.getAnnotation(Concurrent.class);
        String threadValue = this.getThreadParameter(concurrent);
        int threads = AVAILABLE_PROCESSORS * 2;
        if (StringUtils.isNotEmpty((CharSequence)threadValue)) {
            if (StringUtils.isNumeric((CharSequence)threadValue)) {
                threads = Integer.parseInt(threadValue);
            } else if (threadValue.endsWith("x")) {
                threads = this.getRelativeThreadCount(threadValue);
            }
        }
        return threads;
    }

    private String getThreadParameter(Concurrent concurrent) {
        String systemPropertyThreadValue = EnvironmentSpecificConfiguration.from((EnvironmentVariables)this.configuration.getEnvironmentVariables()).getOptionalProperty(new String[]{ThucydidesJUnitSystemProperties.CONCURRENT_THREADS.getName()}).orElse(null);
        String annotatedThreadValue = concurrent.threads();
        return StringUtils.isNotEmpty((CharSequence)systemPropertyThreadValue) ? systemPropertyThreadValue : annotatedThreadValue;
    }

    private int getRelativeThreadCount(String threadValue) {
        try {
            String threadCount = threadValue.substring(0, threadValue.length() - 1);
            return Integer.parseInt(threadCount) * AVAILABLE_PROCESSORS;
        }
        catch (NumberFormatException cause) {
            throw new IllegalArgumentException("Illegal thread value: " + threadValue, cause);
        }
    }

    private List<Runner> buildTestRunnersForEachDataSetUsing(WebDriverFactory webDriverFactory, BatchManager batchManager) throws Throwable {
        if (this.shouldSkipAllTests()) {
            return new ArrayList<Runner>();
        }
        ArrayList<Runner> runners = new ArrayList<Runner>();
        DataTable parametersTable = this.getTestAnnotations().getParametersTableFromTestDataAnnotation();
        for (int i = 0; i < parametersTable.getRows().size(); ++i) {
            Class testClass = this.getTestClass().getJavaClass();
            TestClassRunnerForParameters runner = new TestClassRunnerForParameters(testClass, this.configuration, webDriverFactory, batchManager, parametersTable, i);
            ((SerenityRunner)runner).useQualifier(this.from(((DataTableRow)parametersTable.getRows().get(i)).getValues()));
            runners.add((Runner)runner);
        }
        return runners;
    }

    private List<Runner> buildTestRunnersFromADataSourceUsing(WebDriverFactory webDriverFactory, BatchManager batchManager) throws Throwable {
        if (this.shouldSkipAllTests()) {
            return new ArrayList<Runner>();
        }
        ArrayList<Runner> runners = new ArrayList<Runner>();
        List testCases = this.getTestAnnotations().getDataAsInstancesOf(this.getTestClass().getJavaClass());
        DataTable parametersTable = this.getTestAnnotations().getParametersTableFromTestDataSource();
        for (int i = 0; i < testCases.size(); ++i) {
            Object testCase = testCases.get(i);
            TestClassRunnerForInstanciatedTestCase runner = new TestClassRunnerForInstanciatedTestCase(testCase, this.configuration, webDriverFactory, batchManager, parametersTable, i);
            ((SerenityRunner)runner).useQualifier(this.getQualifierFor(testCase));
            runners.add((Runner)runner);
        }
        return runners;
    }

    private boolean shouldSkipTest(Method method) {
        return !this.tagScanner.shouldRunMethod(this.getTestClass().getJavaClass(), method.getName());
    }

    private boolean shouldSkipAllTests() {
        return this.getTestAnnotations().getTestMethods().stream().allMatch(this::shouldSkipTest);
    }

    private String getQualifierFor(Object testCase) {
        return QualifierFinder.forTestCase(testCase).getQualifier();
    }

    private DataDrivenAnnotations getTestAnnotations() {
        return DataDrivenAnnotations.forClass(this.getTestClass().getJavaClass());
    }

    private String from(Collection testData) {
        StringBuffer testDataQualifier = new StringBuffer();
        boolean firstEntry = true;
        for (Object testDataValue : testData) {
            if (!firstEntry) {
                testDataQualifier.append("/");
            }
            testDataQualifier.append(testDataValue);
            firstEntry = false;
        }
        return testDataQualifier.toString();
    }

    public SerenityParameterizedRunner(Class<?> klass) throws Throwable {
        this(klass, WebDriverConfiguredEnvironment.getDriverConfiguration(), new WebDriverFactory(), (BatchManager)Injectors.getInjector().getInstance(BatchManager.class));
    }

    protected List<Runner> getChildren() {
        return this.runners;
    }

    public void run(RunNotifier notifier) {
        try {
            super.run(notifier);
        }
        finally {
            StepEventBus.getEventBus().testSuiteFinished();
            this.generateReports();
        }
    }

    public void generateReports() {
        this.generateReportsFor(this.parameterizedTestsOutcomeAggregator.aggregateTestOutcomesByTestMethods());
    }

    private void generateReportsFor(List<TestOutcome> testOutcomes) {
        this.getReportService().generateReportsFor(testOutcomes);
        this.getReportService().generateConfigurationsReport();
    }

    private ReportService getReportService() {
        if (this.reportService == null) {
            this.reportService = new ReportService(this.getOutputDirectory(), this.getDefaultReporters());
        }
        return this.reportService;
    }

    private Collection<AcceptanceTestReporter> getDefaultReporters() {
        return ReportService.getDefaultReporters();
    }

    private File getOutputDirectory() {
        return this.configuration.getOutputDirectory();
    }

    public void subscribeReporter(AcceptanceTestReporter reporter) {
        this.getReportService().subscribe(reporter);
    }

    public List<Runner> getRunners() {
        return this.runners;
    }
}

