/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.junit.runners;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import net.serenitybdd.junit.runners.FailureRerunner;
import net.serenitybdd.junit.runners.RerunnableClass;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.webdriver.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FailureRerunnerJson
implements FailureRerunner {
    private final Logger logger = LoggerFactory.getLogger(FailureRerunnerJson.class);
    private final EnvironmentVariables environmentVariables;
    private static final String DEFAULT_RERUN_FOLDER_NAME = "rerun";
    private ObjectMapper objectMapper;
    private String rerunFolderName;

    public FailureRerunnerJson(Configuration configuration) {
        this.environmentVariables = configuration.getEnvironmentVariables();
        this.rerunFolderName = ThucydidesSystemProperty.RERUN_FAILURES_DIRECTORY.from(this.environmentVariables, DEFAULT_RERUN_FOLDER_NAME);
        this.objectMapper = new ObjectMapper();
        this.objectMapper.enable(SerializationFeature.INDENT_OUTPUT);
    }

    @Override
    public void recordFailedTests(Map<String, List<String>> failedTests) {
        if (!ThucydidesSystemProperty.RECORD_FAILURES.booleanFrom(this.environmentVariables, Boolean.valueOf(false)).booleanValue()) {
            return;
        }
        if (failedTests.size() == 0) {
            this.logger.info("no failed tests to record");
            return;
        }
        Path rerunFolder = Paths.get(this.rerunFolderName, new String[0]);
        if (!Files.exists(rerunFolder, new LinkOption[0])) {
            try {
                Files.createDirectory(rerunFolder, new FileAttribute[0]);
            }
            catch (FileAlreadyExistsException ex) {
                this.logger.error("directory of rerun files already exists");
            }
            catch (IOException e) {
                this.logger.error("cannot create directory of rerun files");
                return;
            }
        }
        try {
            RerunnableClass rerunnableClass = null;
            for (Map.Entry<String, List<String>> entry : failedTests.entrySet()) {
                String className = entry.getKey().replace("$", ".");
                Path rerunFile = Paths.get(this.rerunFolderName, className + "_rerun.json");
                this.logger.info("recording failing tests in file " + rerunFile);
                if (Files.exists(rerunFile, new LinkOption[0])) {
                    rerunnableClass = (RerunnableClass)this.objectMapper.readValue(rerunFile.toFile(), RerunnableClass.class);
                }
                if (rerunnableClass == null) {
                    rerunnableClass = new RerunnableClass();
                    rerunnableClass.setClassName(className);
                }
                for (String failedTestMethodName : entry.getValue()) {
                    this.logger.info("Adding failedTestMethodName " + failedTestMethodName);
                    rerunnableClass.getMethodNames().add(failedTestMethodName);
                }
                this.objectMapper.writeValue(rerunFile.toFile(), (Object)rerunnableClass);
            }
        }
        catch (Throwable th) {
            this.logger.error("Error recording failing tests " + th.getMessage(), th);
        }
    }

    @Override
    public boolean hasToRunTest(String className, String methodName) {
        if (!ThucydidesSystemProperty.REPLAY_FAILURES.booleanFrom(this.environmentVariables, Boolean.valueOf(false)).booleanValue()) {
            return true;
        }
        this.logger.info("Check if must rerun method " + className + " " + methodName);
        try {
            RerunnableClass rerunnableClass;
            Path rerunFile = Paths.get(this.rerunFolderName, className + "_rerun.json");
            if (Files.exists(rerunFile, new LinkOption[0]) && (rerunnableClass = (RerunnableClass)this.objectMapper.readValue(rerunFile.toFile(), RerunnableClass.class)).getClassName().equals(className) && rerunnableClass.getMethodNames().contains(methodName)) {
                this.logger.info("Found rerunnable method " + methodName);
                return true;
            }
        }
        catch (Throwable th) {
            this.logger.error("Error when checking if method must be rerun: " + th.getMessage(), th);
        }
        return false;
    }
}

