/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.junit.runners;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.serenitybdd.junit.runners.SerenityParameterizedRunner;
import net.serenitybdd.junit.runners.SerenityRunner;
import net.thucydides.model.domain.DataTableRow;
import net.thucydides.model.domain.TestOutcome;
import net.thucydides.model.domain.TestResult;
import net.thucydides.model.domain.TestResultList;
import net.thucydides.model.domain.TestStep;
import org.apache.commons.lang3.StringUtils;
import org.junit.runner.Runner;

public class ParameterizedTestsOutcomeAggregator {
    private final SerenityParameterizedRunner serenityParameterizedRunner;

    private ParameterizedTestsOutcomeAggregator(SerenityParameterizedRunner serenityParameterizedRunner) {
        this.serenityParameterizedRunner = serenityParameterizedRunner;
    }

    public static ParameterizedTestsOutcomeAggregator from(SerenityParameterizedRunner serenityParameterizedRunner) {
        return new ParameterizedTestsOutcomeAggregator(serenityParameterizedRunner);
    }

    public List<TestOutcome> aggregateTestOutcomesByTestMethods() {
        List<TestOutcome> allOutcomes = this.getTestOutcomesForAllParameterSets();
        if (allOutcomes.isEmpty()) {
            return new ArrayList<TestOutcome>();
        }
        return this.aggregatedScenarioOutcomes(allOutcomes);
    }

    private List<TestOutcome> aggregatedScenarioOutcomes(List<TestOutcome> allOutcomes) {
        HashMap<String, TestOutcome> scenarioOutcomes = new HashMap<String, TestOutcome>();
        for (TestOutcome testOutcome : allOutcomes) {
            TestOutcome scenarioOutcome = this.scenarioOutcomeFor(this.baseMethodName(testOutcome), testOutcome, scenarioOutcomes);
            this.recordTestOutcomeAsSteps(testOutcome, scenarioOutcome);
            scenarioOutcome.setContext(testOutcome.getContext());
            if (testOutcome.isManual()) {
                scenarioOutcome = scenarioOutcome.setToManual();
            }
            if (!testOutcome.isDataDriven()) continue;
            scenarioOutcome.addDataFrom(testOutcome.getDataTable());
        }
        ArrayList<TestOutcome> aggregatedScenarioOutcomes = new ArrayList<TestOutcome>();
        aggregatedScenarioOutcomes.addAll(scenarioOutcomes.values());
        return aggregatedScenarioOutcomes;
    }

    private void recordTestOutcomeAsSteps(TestOutcome testOutcome, TestOutcome scenarioOutcome) {
        String name = this.alternativeMethodName(testOutcome);
        TestStep nestedStep = TestStep.forStepCalled((String)name).withResult(testOutcome.getResult());
        List testSteps = testOutcome.getTestSteps();
        if (testOutcome.getTestFailureCause() != null) {
            nestedStep.failedWith(testOutcome.getTestFailureCause().toException());
        }
        if (!testSteps.isEmpty()) {
            for (TestStep nextStep : testSteps) {
                nextStep.setDescription(this.normalizeTestStepDescription(nextStep.getDescription(), scenarioOutcome.getTestSteps().size() + 1));
                nestedStep.addChildStep(nextStep);
                nestedStep.setDuration(nextStep.getDuration() + nestedStep.getDuration());
            }
        }
        if (nestedStep.getDuration() == 0L) {
            nestedStep.setDuration(testOutcome.getDuration().longValue());
        }
        scenarioOutcome.recordStep(nestedStep);
    }

    private TestOutcome scenarioOutcomeFor(String normalizedMethodName, TestOutcome testOutcome, Map<String, TestOutcome> scenarioOutcomes) {
        if (!scenarioOutcomes.containsKey(normalizedMethodName)) {
            TestOutcome scenarioOutcome = this.createScenarioOutcome(testOutcome);
            scenarioOutcomes.put(normalizedMethodName, scenarioOutcome);
        }
        return scenarioOutcomes.get(normalizedMethodName);
    }

    private TestResult overallResultFrom(List<DataTableRow> rows) {
        List resultsOfEachRow = rows.stream().map(DataTableRow::getResult).collect(Collectors.toList());
        return TestResultList.overallResultFrom(resultsOfEachRow);
    }

    private String normalizeTestStepDescription(String description, int index) {
        return StringUtils.replace((String)description, (String)"[1]", (String)("[" + index + "]"));
    }

    private TestOutcome createScenarioOutcome(TestOutcome parameterizedOutcome) {
        TestOutcome testOutcome = TestOutcome.forTest((String)this.baseMethodName(parameterizedOutcome), (Class)parameterizedOutcome.getTestCase());
        return testOutcome;
    }

    private String baseMethodName(TestOutcome testOutcome) {
        return testOutcome.getName().replaceAll("\\[\\d+\\]", "");
    }

    private String alternativeMethodName(TestOutcome testOutcome) {
        Optional qualifier = testOutcome.getQualifier();
        if (qualifier.isPresent()) {
            return testOutcome.getTitle(false) + " " + (String)testOutcome.getQualifier().get();
        }
        return testOutcome.getTitle();
    }

    public List<TestOutcome> getTestOutcomesForAllParameterSets() {
        ArrayList<TestOutcome> testOutcomes = new ArrayList<TestOutcome>();
        for (Runner runner : this.serenityParameterizedRunner.getRunners()) {
            for (TestOutcome testOutcome : ((SerenityRunner)runner).getTestOutcomes()) {
                if (testOutcomes.contains(testOutcome)) continue;
                testOutcomes.add(testOutcome);
            }
        }
        return testOutcomes;
    }
}

