/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.junit.platform.engine;

import io.cucumber.junit.platform.engine.CucumberEngineDescriptor;
import io.cucumber.junit.platform.engine.CucumberEngineExecutionContext;
import io.cucumber.junit.platform.engine.WeightedTest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.thucydides.model.ThucydidesSystemProperty;
import net.thucydides.model.environment.SystemEnvironmentVariables;
import net.thucydides.model.util.EnvironmentVariables;
import org.junit.jupiter.engine.config.DefaultJupiterConfiguration;
import org.junit.jupiter.engine.config.JupiterConfiguration;
import org.junit.jupiter.engine.descriptor.JupiterEngineDescriptor;
import org.junit.jupiter.engine.discovery.DiscoverySelectorResolver;
import org.junit.platform.engine.ConfigurationParameters;
import org.junit.platform.engine.EngineDiscoveryRequest;
import org.junit.platform.engine.ExecutionRequest;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.config.PrefixedConfigurationParameters;
import org.junit.platform.engine.support.hierarchical.ForkJoinPoolHierarchicalTestExecutorService;
import org.junit.platform.engine.support.hierarchical.HierarchicalTestEngine;
import org.junit.platform.engine.support.hierarchical.HierarchicalTestExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CucumberBatchTestEngine
extends HierarchicalTestEngine<CucumberEngineExecutionContext> {
    static final Logger LOGGER = LoggerFactory.getLogger(CucumberBatchTestEngine.class);

    public String getId() {
        return "cucumber-batch";
    }

    public TestDescriptor discover(EngineDiscoveryRequest discoveryRequest, UniqueId uniqueId) {
        CucumberEngineDescriptor engineDescriptor = new CucumberEngineDescriptor(uniqueId);
        DefaultJupiterConfiguration jupiterConfiguration = new DefaultJupiterConfiguration(null);
        JupiterEngineDescriptor dd = new JupiterEngineDescriptor(uniqueId, (JupiterConfiguration)jupiterConfiguration);
        new DiscoverySelectorResolver().resolveSelectors(discoveryRequest, dd);
        return engineDescriptor;
    }

    protected HierarchicalTestExecutorService createExecutorService(ExecutionRequest request) {
        ConfigurationParameters config = request.getConfigurationParameters();
        if (config.getBoolean("cucumber.execution.parallel.enabled").orElse(false).booleanValue()) {
            return new ForkJoinPoolHierarchicalTestExecutorService((ConfigurationParameters)new PrefixedConfigurationParameters(config, "cucumber.execution.parallel.config."));
        }
        if (!request.getRootTestDescriptor().getChildren().isEmpty()) {
            CucumberBatchTestEngine.processRequestIfBatched(request);
        }
        return super.createExecutorService(request);
    }

    static void processRequestIfBatched(ExecutionRequest request) {
        String tagFilter = request.getConfigurationParameters().get("cucumber.filter.tags").orElse(System.getProperty("cucumber.filter.tags"));
        List<WeightedTest> scenarioList = request.getRootTestDescriptor().getChildren().stream().map(TestDescriptor::getChildren).flatMap(Collection::stream).map(WeightedTest::new).collect(Collectors.toList());
        int total = scenarioList.size();
        List<WeightedTest> tagFilteredScenarioList = scenarioList.stream().filter(scenario -> scenario.isTagMatchingFilter(tagFilter)).collect(Collectors.toList());
        LOGGER.info("Found {} scenarios in classpath, {} match(es) tag filter {}", new Object[]{total, tagFilteredScenarioList.size(), tagFilter});
        EnvironmentVariables envs = SystemEnvironmentVariables.currentEnvironmentVariables();
        int batchCount = envs.getPropertyAsInteger((Enum)ThucydidesSystemProperty.SERENITY_BATCH_COUNT, Integer.valueOf(1));
        int batchNumber = envs.getPropertyAsInteger((Enum)ThucydidesSystemProperty.SERENITY_BATCH_NUMBER, Integer.valueOf(1));
        int forkCount = envs.getPropertyAsInteger((Enum)ThucydidesSystemProperty.SERENITY_FORK_COUNT, Integer.valueOf(1));
        int forkNumber = envs.getPropertyAsInteger((Enum)ThucydidesSystemProperty.SERENITY_FORK_NUMBER, Integer.valueOf(1));
        LOGGER.info("Parameters: \n{}", (Object)request.getConfigurationParameters());
        LOGGER.info("Running partitioning for batch {} of {} and fork {} of {}", new Object[]{batchNumber, batchCount, forkNumber, forkCount});
        List<WeightedTest> batch = CucumberBatchTestEngine.getPartition(tagFilteredScenarioList, batchCount, batchNumber);
        List<WeightedTest> testToRun = CucumberBatchTestEngine.getPartition(batch, forkCount, forkNumber);
        scenarioList.removeAll(testToRun);
        scenarioList.forEach(WeightedTest::removeFromHierarchy);
        LOGGER.info("Running {} of {} scenarios", (Object)testToRun.size(), (Object)total);
        LOGGER.info("Test to run: {}", testToRun);
        LOGGER.info("Root test descriptor has {} feature(s)", (Object)request.getRootTestDescriptor().getChildren().size());
    }

    protected CucumberEngineExecutionContext createExecutionContext(ExecutionRequest request) {
        return new CucumberEngineExecutionContext(request.getConfigurationParameters());
    }

    static List<WeightedTest> getPartition(List<WeightedTest> list, int partitions, int index) {
        if (partitions == 1 && index == 1) {
            return new ArrayList<WeightedTest>(list);
        }
        return CucumberBatchTestEngine.getPartitionedTests(list, partitions).get(index - 1);
    }

    static List<List<WeightedTest>> getPartitionedTests(List<WeightedTest> list, int partitions) {
        List<List<WeightedTest>> result = Stream.generate(ArrayList::new).limit(partitions).collect(Collectors.toList());
        list.sort(Comparator.comparing(WeightedTest::getWeight).reversed());
        int[] weights = new int[partitions];
        for (WeightedTest test : list) {
            int minPartition = CucumberBatchTestEngine.getMinPartition(weights);
            result.get(minPartition).add(test);
            int n = minPartition;
            weights[n] = weights[n] + test.getWeight();
        }
        for (int i = 0; i < result.size(); ++i) {
            LOGGER.info("{} of {}, weight = {}", new Object[]{i + 1, partitions, result.get(i).stream().mapToInt(WeightedTest::getWeight).sum()});
            LOGGER.info(CucumberBatchTestEngine.print(result.get(i)));
        }
        return result;
    }

    private static String print(List<WeightedTest> list) {
        return list.stream().map(WeightedTest::toString).collect(Collectors.joining("\n"));
    }

    private static int getMinPartition(int[] weights) {
        return IntStream.range(0, weights.length).boxed().min(Comparator.comparingInt(i -> weights[i])).orElse(-1);
    }
}

